import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMonitorScheduledQueryRulesLogConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_log#name DataAzurermMonitorScheduledQueryRulesLog#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_log#resource_group_name DataAzurermMonitorScheduledQueryRulesLog#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_log#timeouts DataAzurermMonitorScheduledQueryRulesLog#timeouts}
    */
    readonly timeouts?: DataAzurermMonitorScheduledQueryRulesLogTimeouts;
}
export declare class DataAzurermMonitorScheduledQueryRulesLogCriteriaDimension extends cdktf.ComplexComputedList {
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermMonitorScheduledQueryRulesLogCriteria extends cdktf.ComplexComputedList {
    get dimension(): cdktf.IResolvable;
    get metricName(): string;
}
export interface DataAzurermMonitorScheduledQueryRulesLogTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_log#read DataAzurermMonitorScheduledQueryRulesLog#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMonitorScheduledQueryRulesLogTimeoutsToTerraform(struct?: DataAzurermMonitorScheduledQueryRulesLogTimeoutsOutputReference | DataAzurermMonitorScheduledQueryRulesLogTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMonitorScheduledQueryRulesLogTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermMonitorScheduledQueryRulesLogTimeouts | undefined;
    set internalValue(value: DataAzurermMonitorScheduledQueryRulesLogTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_log azurerm_monitor_scheduled_query_rules_log}
*/
export declare class DataAzurermMonitorScheduledQueryRulesLog extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_log azurerm_monitor_scheduled_query_rules_log} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMonitorScheduledQueryRulesLogConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMonitorScheduledQueryRulesLogConfig);
    get authorizedResourceIds(): string[];
    criteria(index: string): DataAzurermMonitorScheduledQueryRulesLogCriteria;
    get dataSourceId(): string;
    get description(): string;
    get enabled(): cdktf.IResolvable;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermMonitorScheduledQueryRulesLogTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMonitorScheduledQueryRulesLogTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermMonitorScheduledQueryRulesLogTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
