import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMssqlElasticpoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_elasticpool#name DataAzurermMssqlElasticpool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_elasticpool#resource_group_name DataAzurermMssqlElasticpool#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_elasticpool#server_name DataAzurermMssqlElasticpool#server_name}
    */
    readonly serverName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_elasticpool#timeouts DataAzurermMssqlElasticpool#timeouts}
    */
    readonly timeouts?: DataAzurermMssqlElasticpoolTimeouts;
}
export declare class DataAzurermMssqlElasticpoolSku extends cdktf.ComplexComputedList {
    get capacity(): number;
    get family(): string;
    get name(): string;
    get tier(): string;
}
export interface DataAzurermMssqlElasticpoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_elasticpool#read DataAzurermMssqlElasticpool#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMssqlElasticpoolTimeoutsToTerraform(struct?: DataAzurermMssqlElasticpoolTimeoutsOutputReference | DataAzurermMssqlElasticpoolTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMssqlElasticpoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermMssqlElasticpoolTimeouts | undefined;
    set internalValue(value: DataAzurermMssqlElasticpoolTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_elasticpool azurerm_mssql_elasticpool}
*/
export declare class DataAzurermMssqlElasticpool extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_elasticpool azurerm_mssql_elasticpool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMssqlElasticpoolConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMssqlElasticpoolConfig);
    get id(): string;
    get licenseType(): string;
    get location(): string;
    get maxSizeBytes(): number;
    get maxSizeGb(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get perDbMaxCapacity(): number;
    get perDbMinCapacity(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serverName?;
    get serverName(): string;
    set serverName(value: string);
    get serverNameInput(): string | undefined;
    sku(index: string): DataAzurermMssqlElasticpoolSku;
    tags(key: string): string | cdktf.IResolvable;
    get zoneRedundant(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermMssqlElasticpoolTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMssqlElasticpoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermMssqlElasticpoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
