import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMysqlServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_server#name DataAzurermMysqlServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_server#resource_group_name DataAzurermMysqlServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_server#timeouts DataAzurermMysqlServer#timeouts}
    */
    readonly timeouts?: DataAzurermMysqlServerTimeouts;
}
export declare class DataAzurermMysqlServerIdentity extends cdktf.ComplexComputedList {
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermMysqlServerThreatDetectionPolicy extends cdktf.ComplexComputedList {
    get disabledAlerts(): string[];
    get emailAccountAdmins(): cdktf.IResolvable;
    get emailAddresses(): string[];
    get enabled(): cdktf.IResolvable;
    get retentionDays(): number;
    get storageAccountAccessKey(): string;
    get storageEndpoint(): string;
}
export interface DataAzurermMysqlServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_server#read DataAzurermMysqlServer#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMysqlServerTimeoutsToTerraform(struct?: DataAzurermMysqlServerTimeoutsOutputReference | DataAzurermMysqlServerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMysqlServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermMysqlServerTimeouts | undefined;
    set internalValue(value: DataAzurermMysqlServerTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_server azurerm_mysql_server}
*/
export declare class DataAzurermMysqlServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_server azurerm_mysql_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMysqlServerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMysqlServerConfig);
    get administratorLogin(): string;
    get autoGrowEnabled(): cdktf.IResolvable;
    get backupRetentionDays(): number;
    get fqdn(): string;
    get geoRedundantBackupEnabled(): cdktf.IResolvable;
    get id(): string;
    identity(index: string): DataAzurermMysqlServerIdentity;
    get infrastructureEncryptionEnabled(): cdktf.IResolvable;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get restorePointInTime(): string;
    get skuName(): string;
    get sslEnforcementEnabled(): cdktf.IResolvable;
    get sslMinimalTlsVersionEnforced(): string;
    get storageMb(): number;
    tags(key: string): string | cdktf.IResolvable;
    threatDetectionPolicy(index: string): DataAzurermMysqlServerThreatDetectionPolicy;
    get version(): string;
    private _timeouts;
    get timeouts(): DataAzurermMysqlServerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMysqlServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermMysqlServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
