import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetappVolumeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume#account_name DataAzurermNetappVolume#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume#name DataAzurermNetappVolume#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume#pool_name DataAzurermNetappVolume#pool_name}
    */
    readonly poolName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume#resource_group_name DataAzurermNetappVolume#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume#security_style DataAzurermNetappVolume#security_style}
    */
    readonly securityStyle?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume#timeouts DataAzurermNetappVolume#timeouts}
    */
    readonly timeouts?: DataAzurermNetappVolumeTimeouts;
}
export declare class DataAzurermNetappVolumeDataProtectionReplication extends cdktf.ComplexComputedList {
    get endpointType(): string;
    get remoteVolumeLocation(): string;
    get remoteVolumeResourceId(): string;
    get replicationFrequency(): string;
    get replicationSchedule(): string;
}
export interface DataAzurermNetappVolumeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume#read DataAzurermNetappVolume#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetappVolumeTimeoutsToTerraform(struct?: DataAzurermNetappVolumeTimeoutsOutputReference | DataAzurermNetappVolumeTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetappVolumeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermNetappVolumeTimeouts | undefined;
    set internalValue(value: DataAzurermNetappVolumeTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume azurerm_netapp_volume}
*/
export declare class DataAzurermNetappVolume extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume azurerm_netapp_volume} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetappVolumeConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetappVolumeConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    dataProtectionReplication(index: string): DataAzurermNetappVolumeDataProtectionReplication;
    get id(): string;
    get location(): string;
    get mountIpAddresses(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _poolName?;
    get poolName(): string;
    set poolName(value: string);
    get poolNameInput(): string | undefined;
    get protocols(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _securityStyle?;
    get securityStyle(): string;
    set securityStyle(value: string);
    resetSecurityStyle(): void;
    get securityStyleInput(): string | undefined;
    get serviceLevel(): string;
    get storageQuotaInGb(): number;
    get subnetId(): string;
    get volumePath(): string;
    private _timeouts;
    get timeouts(): DataAzurermNetappVolumeTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetappVolumeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermNetappVolumeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
