import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetworkSecurityGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_security_group#name DataAzurermNetworkSecurityGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_security_group#resource_group_name DataAzurermNetworkSecurityGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_security_group#timeouts DataAzurermNetworkSecurityGroup#timeouts}
    */
    readonly timeouts?: DataAzurermNetworkSecurityGroupTimeouts;
}
export declare class DataAzurermNetworkSecurityGroupSecurityRule extends cdktf.ComplexComputedList {
    get access(): string;
    get description(): string;
    get destinationAddressPrefix(): string;
    get destinationAddressPrefixes(): string[];
    get destinationApplicationSecurityGroupIds(): string[];
    get destinationPortRange(): string;
    get destinationPortRanges(): string[];
    get direction(): string;
    get name(): string;
    get priority(): number;
    get protocol(): string;
    get sourceAddressPrefix(): string;
    get sourceAddressPrefixes(): string[];
    get sourceApplicationSecurityGroupIds(): string[];
    get sourcePortRange(): string;
    get sourcePortRanges(): string[];
}
export interface DataAzurermNetworkSecurityGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_security_group#read DataAzurermNetworkSecurityGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetworkSecurityGroupTimeoutsToTerraform(struct?: DataAzurermNetworkSecurityGroupTimeoutsOutputReference | DataAzurermNetworkSecurityGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetworkSecurityGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermNetworkSecurityGroupTimeouts | undefined;
    set internalValue(value: DataAzurermNetworkSecurityGroupTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/network_security_group azurerm_network_security_group}
*/
export declare class DataAzurermNetworkSecurityGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/network_security_group azurerm_network_security_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetworkSecurityGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetworkSecurityGroupConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    securityRule(index: string): DataAzurermNetworkSecurityGroupSecurityRule;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermNetworkSecurityGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetworkSecurityGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermNetworkSecurityGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
