import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermRoleDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/role_definition#name DataAzurermRoleDefinition#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/role_definition#role_definition_id DataAzurermRoleDefinition#role_definition_id}
    */
    readonly roleDefinitionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/role_definition#scope DataAzurermRoleDefinition#scope}
    */
    readonly scope?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/role_definition#timeouts DataAzurermRoleDefinition#timeouts}
    */
    readonly timeouts?: DataAzurermRoleDefinitionTimeouts;
}
export declare class DataAzurermRoleDefinitionPermissions extends cdktf.ComplexComputedList {
    get actions(): string[];
    get dataActions(): string[];
    get notActions(): string[];
    get notDataActions(): string[];
}
export interface DataAzurermRoleDefinitionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/role_definition#read DataAzurermRoleDefinition#read}
    */
    readonly read?: string;
}
export declare function dataAzurermRoleDefinitionTimeoutsToTerraform(struct?: DataAzurermRoleDefinitionTimeoutsOutputReference | DataAzurermRoleDefinitionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermRoleDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermRoleDefinitionTimeouts | undefined;
    set internalValue(value: DataAzurermRoleDefinitionTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/role_definition azurerm_role_definition}
*/
export declare class DataAzurermRoleDefinition extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/role_definition azurerm_role_definition} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermRoleDefinitionConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermRoleDefinitionConfig);
    get assignableScopes(): string[];
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    permissions(index: string): DataAzurermRoleDefinitionPermissions;
    private _roleDefinitionId?;
    get roleDefinitionId(): string;
    set roleDefinitionId(value: string);
    resetRoleDefinitionId(): void;
    get roleDefinitionIdInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    get type(): string;
    private _timeouts;
    get timeouts(): DataAzurermRoleDefinitionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermRoleDefinitionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermRoleDefinitionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
