import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualNetworkGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway#name DataAzurermVirtualNetworkGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway#resource_group_name DataAzurermVirtualNetworkGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway#timeouts DataAzurermVirtualNetworkGateway#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualNetworkGatewayTimeouts;
}
export declare class DataAzurermVirtualNetworkGatewayBgpSettings extends cdktf.ComplexComputedList {
    get asn(): number;
    get peerWeight(): number;
    get peeringAddress(): string;
}
export declare class DataAzurermVirtualNetworkGatewayCustomRoute extends cdktf.ComplexComputedList {
    get addressPrefixes(): string[];
}
export declare class DataAzurermVirtualNetworkGatewayIpConfiguration extends cdktf.ComplexComputedList {
    get name(): string;
    get privateIpAddressAllocation(): string;
    get publicIpAddressId(): string;
    get subnetId(): string;
}
export declare class DataAzurermVirtualNetworkGatewayVpnClientConfigurationRevokedCertificate extends cdktf.ComplexComputedList {
    get name(): string;
    get thumbprint(): string;
}
export declare class DataAzurermVirtualNetworkGatewayVpnClientConfigurationRootCertificate extends cdktf.ComplexComputedList {
    get name(): string;
    get publicCertData(): string;
}
export declare class DataAzurermVirtualNetworkGatewayVpnClientConfiguration extends cdktf.ComplexComputedList {
    get aadAudience(): string;
    get aadIssuer(): string;
    get aadTenant(): string;
    get addressSpace(): string[];
    get radiusServerAddress(): string;
    get radiusServerSecret(): string;
    get revokedCertificate(): cdktf.IResolvable;
    get rootCertificate(): cdktf.IResolvable;
    get vpnClientProtocols(): string[];
}
export interface DataAzurermVirtualNetworkGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway#read DataAzurermVirtualNetworkGateway#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualNetworkGatewayTimeoutsToTerraform(struct?: DataAzurermVirtualNetworkGatewayTimeoutsOutputReference | DataAzurermVirtualNetworkGatewayTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualNetworkGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermVirtualNetworkGatewayTimeouts | undefined;
    set internalValue(value: DataAzurermVirtualNetworkGatewayTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway azurerm_virtual_network_gateway}
*/
export declare class DataAzurermVirtualNetworkGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway azurerm_virtual_network_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualNetworkGatewayConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualNetworkGatewayConfig);
    get activeActive(): cdktf.IResolvable;
    bgpSettings(index: string): DataAzurermVirtualNetworkGatewayBgpSettings;
    customRoute(index: string): DataAzurermVirtualNetworkGatewayCustomRoute;
    get defaultLocalNetworkGatewayId(): string;
    get enableBgp(): cdktf.IResolvable;
    get generation(): string;
    get id(): string;
    ipConfiguration(index: string): DataAzurermVirtualNetworkGatewayIpConfiguration;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateIpAddressEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    tags(key: string): string | cdktf.IResolvable;
    get type(): string;
    vpnClientConfiguration(index: string): DataAzurermVirtualNetworkGatewayVpnClientConfiguration;
    get vpnType(): string;
    private _timeouts;
    get timeouts(): DataAzurermVirtualNetworkGatewayTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualNetworkGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermVirtualNetworkGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
