import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryDatasetAzureBlobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#additional_properties DataFactoryDatasetAzureBlob#additional_properties}
    */
    readonly additionalProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#annotations DataFactoryDatasetAzureBlob#annotations}
    */
    readonly annotations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#data_factory_id DataFactoryDatasetAzureBlob#data_factory_id}
    */
    readonly dataFactoryId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#data_factory_name DataFactoryDatasetAzureBlob#data_factory_name}
    */
    readonly dataFactoryName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#description DataFactoryDatasetAzureBlob#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#dynamic_filename_enabled DataFactoryDatasetAzureBlob#dynamic_filename_enabled}
    */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#dynamic_path_enabled DataFactoryDatasetAzureBlob#dynamic_path_enabled}
    */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#filename DataFactoryDatasetAzureBlob#filename}
    */
    readonly filename?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#folder DataFactoryDatasetAzureBlob#folder}
    */
    readonly folder?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#linked_service_name DataFactoryDatasetAzureBlob#linked_service_name}
    */
    readonly linkedServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#name DataFactoryDatasetAzureBlob#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#parameters DataFactoryDatasetAzureBlob#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#path DataFactoryDatasetAzureBlob#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#resource_group_name DataFactoryDatasetAzureBlob#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * schema_column block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#schema_column DataFactoryDatasetAzureBlob#schema_column}
    */
    readonly schemaColumn?: DataFactoryDatasetAzureBlobSchemaColumn[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#timeouts DataFactoryDatasetAzureBlob#timeouts}
    */
    readonly timeouts?: DataFactoryDatasetAzureBlobTimeouts;
}
export interface DataFactoryDatasetAzureBlobSchemaColumn {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#description DataFactoryDatasetAzureBlob#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#name DataFactoryDatasetAzureBlob#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#type DataFactoryDatasetAzureBlob#type}
    */
    readonly type?: string;
}
export declare function dataFactoryDatasetAzureBlobSchemaColumnToTerraform(struct?: DataFactoryDatasetAzureBlobSchemaColumn | cdktf.IResolvable): any;
export interface DataFactoryDatasetAzureBlobTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#create DataFactoryDatasetAzureBlob#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#delete DataFactoryDatasetAzureBlob#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#read DataFactoryDatasetAzureBlob#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob#update DataFactoryDatasetAzureBlob#update}
    */
    readonly update?: string;
}
export declare function dataFactoryDatasetAzureBlobTimeoutsToTerraform(struct?: DataFactoryDatasetAzureBlobTimeoutsOutputReference | DataFactoryDatasetAzureBlobTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryDatasetAzureBlobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataFactoryDatasetAzureBlobTimeouts | undefined;
    set internalValue(value: DataFactoryDatasetAzureBlobTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob azurerm_data_factory_dataset_azure_blob}
*/
export declare class DataFactoryDatasetAzureBlob extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_azure_blob azurerm_data_factory_dataset_azure_blob} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryDatasetAzureBlobConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryDatasetAzureBlobConfig);
    private _additionalProperties?;
    get additionalProperties(): {
        [key: string]: string;
    };
    set additionalProperties(value: {
        [key: string]: string;
    });
    resetAdditionalProperties(): void;
    get additionalPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    get annotations(): string[];
    set annotations(value: string[]);
    resetAnnotations(): void;
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    resetDataFactoryId(): void;
    get dataFactoryIdInput(): string | undefined;
    private _dataFactoryName?;
    get dataFactoryName(): string;
    set dataFactoryName(value: string);
    resetDataFactoryName(): void;
    get dataFactoryNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _dynamicFilenameEnabled?;
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicFilenameEnabled(): void;
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicPathEnabled(): void;
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    resetFilename(): void;
    get filenameInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    get id(): string;
    private _linkedServiceName?;
    get linkedServiceName(): string;
    set linkedServiceName(value: string);
    get linkedServiceNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _schemaColumn?;
    get schemaColumn(): DataFactoryDatasetAzureBlobSchemaColumn[] | cdktf.IResolvable;
    set schemaColumn(value: DataFactoryDatasetAzureBlobSchemaColumn[] | cdktf.IResolvable);
    resetSchemaColumn(): void;
    get schemaColumnInput(): cdktf.IResolvable | DataFactoryDatasetAzureBlobSchemaColumn[] | undefined;
    private _timeouts;
    get timeouts(): DataFactoryDatasetAzureBlobTimeoutsOutputReference;
    putTimeouts(value: DataFactoryDatasetAzureBlobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataFactoryDatasetAzureBlobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
