import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataboxEdgeOrderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#device_name DataboxEdgeOrder#device_name}
    */
    readonly deviceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#resource_group_name DataboxEdgeOrder#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * contact block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#contact DataboxEdgeOrder#contact}
    */
    readonly contact: DataboxEdgeOrderContact;
    /**
    * shipment_address block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#shipment_address DataboxEdgeOrder#shipment_address}
    */
    readonly shipmentAddress: DataboxEdgeOrderShipmentAddress;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#timeouts DataboxEdgeOrder#timeouts}
    */
    readonly timeouts?: DataboxEdgeOrderTimeouts;
}
export declare class DataboxEdgeOrderReturnTracking extends cdktf.ComplexComputedList {
    get carrierName(): string;
    get serialNumber(): string;
    get trackingId(): string;
    get trackingUrl(): string;
}
export declare class DataboxEdgeOrderShipmentHistory extends cdktf.ComplexComputedList {
    get additionalDetails(): {
        [key: string]: string;
    };
    get comments(): string;
    get lastUpdate(): string;
}
export declare class DataboxEdgeOrderShipmentTracking extends cdktf.ComplexComputedList {
    get carrierName(): string;
    get serialNumber(): string;
    get trackingId(): string;
    get trackingUrl(): string;
}
export declare class DataboxEdgeOrderStatus extends cdktf.ComplexComputedList {
    get additionalDetails(): {
        [key: string]: string;
    };
    get comments(): string;
    get info(): string;
    get lastUpdate(): string;
}
export interface DataboxEdgeOrderContact {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#company_name DataboxEdgeOrder#company_name}
    */
    readonly companyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#emails DataboxEdgeOrder#emails}
    */
    readonly emails: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#name DataboxEdgeOrder#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#phone_number DataboxEdgeOrder#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function databoxEdgeOrderContactToTerraform(struct?: DataboxEdgeOrderContactOutputReference | DataboxEdgeOrderContact): any;
export declare class DataboxEdgeOrderContactOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataboxEdgeOrderContact | undefined;
    set internalValue(value: DataboxEdgeOrderContact | undefined);
    private _companyName?;
    get companyName(): string;
    set companyName(value: string);
    get companyNameInput(): string | undefined;
    private _emails?;
    get emails(): string[];
    set emails(value: string[]);
    get emailsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
}
export interface DataboxEdgeOrderShipmentAddress {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#address DataboxEdgeOrder#address}
    */
    readonly address: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#city DataboxEdgeOrder#city}
    */
    readonly city: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#country DataboxEdgeOrder#country}
    */
    readonly country: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#postal_code DataboxEdgeOrder#postal_code}
    */
    readonly postalCode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#state DataboxEdgeOrder#state}
    */
    readonly state: string;
}
export declare function databoxEdgeOrderShipmentAddressToTerraform(struct?: DataboxEdgeOrderShipmentAddressOutputReference | DataboxEdgeOrderShipmentAddress): any;
export declare class DataboxEdgeOrderShipmentAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataboxEdgeOrderShipmentAddress | undefined;
    set internalValue(value: DataboxEdgeOrderShipmentAddress | undefined);
    private _address?;
    get address(): string[];
    set address(value: string[]);
    get addressInput(): string[] | undefined;
    private _city?;
    get city(): string;
    set city(value: string);
    get cityInput(): string | undefined;
    private _country?;
    get country(): string;
    set country(value: string);
    get countryInput(): string | undefined;
    private _postalCode?;
    get postalCode(): string;
    set postalCode(value: string);
    get postalCodeInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    get stateInput(): string | undefined;
}
export interface DataboxEdgeOrderTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#create DataboxEdgeOrder#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#delete DataboxEdgeOrder#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#read DataboxEdgeOrder#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#update DataboxEdgeOrder#update}
    */
    readonly update?: string;
}
export declare function databoxEdgeOrderTimeoutsToTerraform(struct?: DataboxEdgeOrderTimeoutsOutputReference | DataboxEdgeOrderTimeouts | cdktf.IResolvable): any;
export declare class DataboxEdgeOrderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataboxEdgeOrderTimeouts | undefined;
    set internalValue(value: DataboxEdgeOrderTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order azurerm_databox_edge_order}
*/
export declare class DataboxEdgeOrder extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order azurerm_databox_edge_order} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataboxEdgeOrderConfig
    */
    constructor(scope: Construct, id: string, config: DataboxEdgeOrderConfig);
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    get deviceNameInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    returnTracking(index: string): DataboxEdgeOrderReturnTracking;
    get serialNumber(): string;
    shipmentHistory(index: string): DataboxEdgeOrderShipmentHistory;
    shipmentTracking(index: string): DataboxEdgeOrderShipmentTracking;
    status(index: string): DataboxEdgeOrderStatus;
    private _contact;
    get contact(): DataboxEdgeOrderContactOutputReference;
    putContact(value: DataboxEdgeOrderContact): void;
    get contactInput(): DataboxEdgeOrderContact | undefined;
    private _shipmentAddress;
    get shipmentAddress(): DataboxEdgeOrderShipmentAddressOutputReference;
    putShipmentAddress(value: DataboxEdgeOrderShipmentAddress): void;
    get shipmentAddressInput(): DataboxEdgeOrderShipmentAddress | undefined;
    private _timeouts;
    get timeouts(): DataboxEdgeOrderTimeoutsOutputReference;
    putTimeouts(value: DataboxEdgeOrderTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataboxEdgeOrderTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
