import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExpressRouteCircuitAuthorizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_authorization#express_route_circuit_name ExpressRouteCircuitAuthorization#express_route_circuit_name}
    */
    readonly expressRouteCircuitName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_authorization#name ExpressRouteCircuitAuthorization#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_authorization#resource_group_name ExpressRouteCircuitAuthorization#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_authorization#timeouts ExpressRouteCircuitAuthorization#timeouts}
    */
    readonly timeouts?: ExpressRouteCircuitAuthorizationTimeouts;
}
export interface ExpressRouteCircuitAuthorizationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_authorization#create ExpressRouteCircuitAuthorization#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_authorization#delete ExpressRouteCircuitAuthorization#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_authorization#read ExpressRouteCircuitAuthorization#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_authorization#update ExpressRouteCircuitAuthorization#update}
    */
    readonly update?: string;
}
export declare function expressRouteCircuitAuthorizationTimeoutsToTerraform(struct?: ExpressRouteCircuitAuthorizationTimeoutsOutputReference | ExpressRouteCircuitAuthorizationTimeouts | cdktf.IResolvable): any;
export declare class ExpressRouteCircuitAuthorizationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ExpressRouteCircuitAuthorizationTimeouts | undefined;
    set internalValue(value: ExpressRouteCircuitAuthorizationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_authorization azurerm_express_route_circuit_authorization}
*/
export declare class ExpressRouteCircuitAuthorization extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_authorization azurerm_express_route_circuit_authorization} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExpressRouteCircuitAuthorizationConfig
    */
    constructor(scope: Construct, id: string, config: ExpressRouteCircuitAuthorizationConfig);
    get authorizationKey(): string;
    get authorizationUseStatus(): string;
    private _expressRouteCircuitName?;
    get expressRouteCircuitName(): string;
    set expressRouteCircuitName(value: string);
    get expressRouteCircuitNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): ExpressRouteCircuitAuthorizationTimeoutsOutputReference;
    putTimeouts(value: ExpressRouteCircuitAuthorizationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ExpressRouteCircuitAuthorizationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
