import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirewallPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#base_policy_id FirewallPolicy#base_policy_id}
    */
    readonly basePolicyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#location FirewallPolicy#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#name FirewallPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#private_ip_ranges FirewallPolicy#private_ip_ranges}
    */
    readonly privateIpRanges?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#resource_group_name FirewallPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#sku FirewallPolicy#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#tags FirewallPolicy#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#threat_intelligence_mode FirewallPolicy#threat_intelligence_mode}
    */
    readonly threatIntelligenceMode?: string;
    /**
    * dns block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#dns FirewallPolicy#dns}
    */
    readonly dns?: FirewallPolicyDns;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#identity FirewallPolicy#identity}
    */
    readonly identity?: FirewallPolicyIdentity;
    /**
    * insights block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#insights FirewallPolicy#insights}
    */
    readonly insights?: FirewallPolicyInsights;
    /**
    * intrusion_detection block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#intrusion_detection FirewallPolicy#intrusion_detection}
    */
    readonly intrusionDetection?: FirewallPolicyIntrusionDetection;
    /**
    * threat_intelligence_allowlist block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#threat_intelligence_allowlist FirewallPolicy#threat_intelligence_allowlist}
    */
    readonly threatIntelligenceAllowlist?: FirewallPolicyThreatIntelligenceAllowlist;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#timeouts FirewallPolicy#timeouts}
    */
    readonly timeouts?: FirewallPolicyTimeouts;
    /**
    * tls_certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#tls_certificate FirewallPolicy#tls_certificate}
    */
    readonly tlsCertificate?: FirewallPolicyTlsCertificate;
}
export interface FirewallPolicyDns {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#network_rule_fqdn_enabled FirewallPolicy#network_rule_fqdn_enabled}
    */
    readonly networkRuleFqdnEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#proxy_enabled FirewallPolicy#proxy_enabled}
    */
    readonly proxyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#servers FirewallPolicy#servers}
    */
    readonly servers?: string[];
}
export declare function firewallPolicyDnsToTerraform(struct?: FirewallPolicyDnsOutputReference | FirewallPolicyDns): any;
export declare class FirewallPolicyDnsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): FirewallPolicyDns | undefined;
    set internalValue(value: FirewallPolicyDns | undefined);
    private _networkRuleFqdnEnabled?;
    get networkRuleFqdnEnabled(): boolean | cdktf.IResolvable;
    set networkRuleFqdnEnabled(value: boolean | cdktf.IResolvable);
    resetNetworkRuleFqdnEnabled(): void;
    get networkRuleFqdnEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _proxyEnabled?;
    get proxyEnabled(): boolean | cdktf.IResolvable;
    set proxyEnabled(value: boolean | cdktf.IResolvable);
    resetProxyEnabled(): void;
    get proxyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _servers?;
    get servers(): string[];
    set servers(value: string[]);
    resetServers(): void;
    get serversInput(): string[] | undefined;
}
export interface FirewallPolicyIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#type FirewallPolicy#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#user_assigned_identity_ids FirewallPolicy#user_assigned_identity_ids}
    */
    readonly userAssignedIdentityIds?: string[];
}
export declare function firewallPolicyIdentityToTerraform(struct?: FirewallPolicyIdentityOutputReference | FirewallPolicyIdentity): any;
export declare class FirewallPolicyIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): FirewallPolicyIdentity | undefined;
    set internalValue(value: FirewallPolicyIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _userAssignedIdentityIds?;
    get userAssignedIdentityIds(): string[];
    set userAssignedIdentityIds(value: string[]);
    resetUserAssignedIdentityIds(): void;
    get userAssignedIdentityIdsInput(): string[] | undefined;
}
export interface FirewallPolicyInsightsLogAnalyticsWorkspace {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#firewall_location FirewallPolicy#firewall_location}
    */
    readonly firewallLocation: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#id FirewallPolicy#id}
    */
    readonly id: string;
}
export declare function firewallPolicyInsightsLogAnalyticsWorkspaceToTerraform(struct?: FirewallPolicyInsightsLogAnalyticsWorkspace | cdktf.IResolvable): any;
export interface FirewallPolicyInsights {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#default_log_analytics_workspace_id FirewallPolicy#default_log_analytics_workspace_id}
    */
    readonly defaultLogAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#enabled FirewallPolicy#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#retention_in_days FirewallPolicy#retention_in_days}
    */
    readonly retentionInDays?: number;
    /**
    * log_analytics_workspace block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#log_analytics_workspace FirewallPolicy#log_analytics_workspace}
    */
    readonly logAnalyticsWorkspace?: FirewallPolicyInsightsLogAnalyticsWorkspace[] | cdktf.IResolvable;
}
export declare function firewallPolicyInsightsToTerraform(struct?: FirewallPolicyInsightsOutputReference | FirewallPolicyInsights): any;
export declare class FirewallPolicyInsightsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): FirewallPolicyInsights | undefined;
    set internalValue(value: FirewallPolicyInsights | undefined);
    private _defaultLogAnalyticsWorkspaceId?;
    get defaultLogAnalyticsWorkspaceId(): string;
    set defaultLogAnalyticsWorkspaceId(value: string);
    get defaultLogAnalyticsWorkspaceIdInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    resetRetentionInDays(): void;
    get retentionInDaysInput(): number | undefined;
    private _logAnalyticsWorkspace?;
    get logAnalyticsWorkspace(): FirewallPolicyInsightsLogAnalyticsWorkspace[] | cdktf.IResolvable;
    set logAnalyticsWorkspace(value: FirewallPolicyInsightsLogAnalyticsWorkspace[] | cdktf.IResolvable);
    resetLogAnalyticsWorkspace(): void;
    get logAnalyticsWorkspaceInput(): cdktf.IResolvable | FirewallPolicyInsightsLogAnalyticsWorkspace[] | undefined;
}
export interface FirewallPolicyIntrusionDetectionSignatureOverrides {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#id FirewallPolicy#id}
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#state FirewallPolicy#state}
    */
    readonly state?: string;
}
export declare function firewallPolicyIntrusionDetectionSignatureOverridesToTerraform(struct?: FirewallPolicyIntrusionDetectionSignatureOverrides | cdktf.IResolvable): any;
export interface FirewallPolicyIntrusionDetectionTrafficBypass {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#description FirewallPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#destination_addresses FirewallPolicy#destination_addresses}
    */
    readonly destinationAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#destination_ip_groups FirewallPolicy#destination_ip_groups}
    */
    readonly destinationIpGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#destination_ports FirewallPolicy#destination_ports}
    */
    readonly destinationPorts?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#name FirewallPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#protocol FirewallPolicy#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#source_addresses FirewallPolicy#source_addresses}
    */
    readonly sourceAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#source_ip_groups FirewallPolicy#source_ip_groups}
    */
    readonly sourceIpGroups?: string[];
}
export declare function firewallPolicyIntrusionDetectionTrafficBypassToTerraform(struct?: FirewallPolicyIntrusionDetectionTrafficBypass | cdktf.IResolvable): any;
export interface FirewallPolicyIntrusionDetection {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#mode FirewallPolicy#mode}
    */
    readonly mode?: string;
    /**
    * signature_overrides block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#signature_overrides FirewallPolicy#signature_overrides}
    */
    readonly signatureOverrides?: FirewallPolicyIntrusionDetectionSignatureOverrides[] | cdktf.IResolvable;
    /**
    * traffic_bypass block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#traffic_bypass FirewallPolicy#traffic_bypass}
    */
    readonly trafficBypass?: FirewallPolicyIntrusionDetectionTrafficBypass[] | cdktf.IResolvable;
}
export declare function firewallPolicyIntrusionDetectionToTerraform(struct?: FirewallPolicyIntrusionDetectionOutputReference | FirewallPolicyIntrusionDetection): any;
export declare class FirewallPolicyIntrusionDetectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): FirewallPolicyIntrusionDetection | undefined;
    set internalValue(value: FirewallPolicyIntrusionDetection | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _signatureOverrides?;
    get signatureOverrides(): FirewallPolicyIntrusionDetectionSignatureOverrides[] | cdktf.IResolvable;
    set signatureOverrides(value: FirewallPolicyIntrusionDetectionSignatureOverrides[] | cdktf.IResolvable);
    resetSignatureOverrides(): void;
    get signatureOverridesInput(): cdktf.IResolvable | FirewallPolicyIntrusionDetectionSignatureOverrides[] | undefined;
    private _trafficBypass?;
    get trafficBypass(): FirewallPolicyIntrusionDetectionTrafficBypass[] | cdktf.IResolvable;
    set trafficBypass(value: FirewallPolicyIntrusionDetectionTrafficBypass[] | cdktf.IResolvable);
    resetTrafficBypass(): void;
    get trafficBypassInput(): cdktf.IResolvable | FirewallPolicyIntrusionDetectionTrafficBypass[] | undefined;
}
export interface FirewallPolicyThreatIntelligenceAllowlist {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#fqdns FirewallPolicy#fqdns}
    */
    readonly fqdns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#ip_addresses FirewallPolicy#ip_addresses}
    */
    readonly ipAddresses?: string[];
}
export declare function firewallPolicyThreatIntelligenceAllowlistToTerraform(struct?: FirewallPolicyThreatIntelligenceAllowlistOutputReference | FirewallPolicyThreatIntelligenceAllowlist): any;
export declare class FirewallPolicyThreatIntelligenceAllowlistOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): FirewallPolicyThreatIntelligenceAllowlist | undefined;
    set internalValue(value: FirewallPolicyThreatIntelligenceAllowlist | undefined);
    private _fqdns?;
    get fqdns(): string[];
    set fqdns(value: string[]);
    resetFqdns(): void;
    get fqdnsInput(): string[] | undefined;
    private _ipAddresses?;
    get ipAddresses(): string[];
    set ipAddresses(value: string[]);
    resetIpAddresses(): void;
    get ipAddressesInput(): string[] | undefined;
}
export interface FirewallPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#create FirewallPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#delete FirewallPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#read FirewallPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#update FirewallPolicy#update}
    */
    readonly update?: string;
}
export declare function firewallPolicyTimeoutsToTerraform(struct?: FirewallPolicyTimeoutsOutputReference | FirewallPolicyTimeouts | cdktf.IResolvable): any;
export declare class FirewallPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): FirewallPolicyTimeouts | undefined;
    set internalValue(value: FirewallPolicyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface FirewallPolicyTlsCertificate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#key_vault_secret_id FirewallPolicy#key_vault_secret_id}
    */
    readonly keyVaultSecretId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy#name FirewallPolicy#name}
    */
    readonly name: string;
}
export declare function firewallPolicyTlsCertificateToTerraform(struct?: FirewallPolicyTlsCertificateOutputReference | FirewallPolicyTlsCertificate): any;
export declare class FirewallPolicyTlsCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): FirewallPolicyTlsCertificate | undefined;
    set internalValue(value: FirewallPolicyTlsCertificate | undefined);
    private _keyVaultSecretId?;
    get keyVaultSecretId(): string;
    set keyVaultSecretId(value: string);
    get keyVaultSecretIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy azurerm_firewall_policy}
*/
export declare class FirewallPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy azurerm_firewall_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FirewallPolicyConfig
    */
    constructor(scope: Construct, id: string, config: FirewallPolicyConfig);
    private _basePolicyId?;
    get basePolicyId(): string;
    set basePolicyId(value: string);
    resetBasePolicyId(): void;
    get basePolicyIdInput(): string | undefined;
    get childPolicies(): string[];
    get firewalls(): string[];
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateIpRanges?;
    get privateIpRanges(): string[];
    set privateIpRanges(value: string[]);
    resetPrivateIpRanges(): void;
    get privateIpRangesInput(): string[] | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get ruleCollectionGroups(): string[];
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _threatIntelligenceMode?;
    get threatIntelligenceMode(): string;
    set threatIntelligenceMode(value: string);
    resetThreatIntelligenceMode(): void;
    get threatIntelligenceModeInput(): string | undefined;
    private _dns;
    get dns(): FirewallPolicyDnsOutputReference;
    putDns(value: FirewallPolicyDns): void;
    resetDns(): void;
    get dnsInput(): FirewallPolicyDns | undefined;
    private _identity;
    get identity(): FirewallPolicyIdentityOutputReference;
    putIdentity(value: FirewallPolicyIdentity): void;
    resetIdentity(): void;
    get identityInput(): FirewallPolicyIdentity | undefined;
    private _insights;
    get insights(): FirewallPolicyInsightsOutputReference;
    putInsights(value: FirewallPolicyInsights): void;
    resetInsights(): void;
    get insightsInput(): FirewallPolicyInsights | undefined;
    private _intrusionDetection;
    get intrusionDetection(): FirewallPolicyIntrusionDetectionOutputReference;
    putIntrusionDetection(value: FirewallPolicyIntrusionDetection): void;
    resetIntrusionDetection(): void;
    get intrusionDetectionInput(): FirewallPolicyIntrusionDetection | undefined;
    private _threatIntelligenceAllowlist;
    get threatIntelligenceAllowlist(): FirewallPolicyThreatIntelligenceAllowlistOutputReference;
    putThreatIntelligenceAllowlist(value: FirewallPolicyThreatIntelligenceAllowlist): void;
    resetThreatIntelligenceAllowlist(): void;
    get threatIntelligenceAllowlistInput(): FirewallPolicyThreatIntelligenceAllowlist | undefined;
    private _timeouts;
    get timeouts(): FirewallPolicyTimeoutsOutputReference;
    putTimeouts(value: FirewallPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): FirewallPolicyTimeouts | undefined;
    private _tlsCertificate;
    get tlsCertificate(): FirewallPolicyTlsCertificateOutputReference;
    putTlsCertificate(value: FirewallPolicyTlsCertificate): void;
    resetTlsCertificate(): void;
    get tlsCertificateInput(): FirewallPolicyTlsCertificate | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
