import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IothubConsumerGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_consumer_group#eventhub_endpoint_name IothubConsumerGroup#eventhub_endpoint_name}
    */
    readonly eventhubEndpointName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_consumer_group#iothub_name IothubConsumerGroup#iothub_name}
    */
    readonly iothubName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_consumer_group#name IothubConsumerGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_consumer_group#resource_group_name IothubConsumerGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_consumer_group#timeouts IothubConsumerGroup#timeouts}
    */
    readonly timeouts?: IothubConsumerGroupTimeouts;
}
export interface IothubConsumerGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_consumer_group#create IothubConsumerGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_consumer_group#delete IothubConsumerGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_consumer_group#read IothubConsumerGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_consumer_group#update IothubConsumerGroup#update}
    */
    readonly update?: string;
}
export declare function iothubConsumerGroupTimeoutsToTerraform(struct?: IothubConsumerGroupTimeoutsOutputReference | IothubConsumerGroupTimeouts | cdktf.IResolvable): any;
export declare class IothubConsumerGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): IothubConsumerGroupTimeouts | undefined;
    set internalValue(value: IothubConsumerGroupTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_consumer_group azurerm_iothub_consumer_group}
*/
export declare class IothubConsumerGroup extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_consumer_group azurerm_iothub_consumer_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IothubConsumerGroupConfig
    */
    constructor(scope: Construct, id: string, config: IothubConsumerGroupConfig);
    private _eventhubEndpointName?;
    get eventhubEndpointName(): string;
    set eventhubEndpointName(value: string);
    get eventhubEndpointNameInput(): string | undefined;
    get id(): string;
    private _iothubName?;
    get iothubName(): string;
    set iothubName(value: string);
    get iothubNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): IothubConsumerGroupTimeoutsOutputReference;
    putTimeouts(value: IothubConsumerGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): IothubConsumerGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
