import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IothubEndpointServicebusTopicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_servicebus_topic#authentication_type IothubEndpointServicebusTopic#authentication_type}
    */
    readonly authenticationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_servicebus_topic#connection_string IothubEndpointServicebusTopic#connection_string}
    */
    readonly connectionString?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_servicebus_topic#endpoint_uri IothubEndpointServicebusTopic#endpoint_uri}
    */
    readonly endpointUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_servicebus_topic#entity_path IothubEndpointServicebusTopic#entity_path}
    */
    readonly entityPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_servicebus_topic#identity_id IothubEndpointServicebusTopic#identity_id}
    */
    readonly identityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_servicebus_topic#iothub_id IothubEndpointServicebusTopic#iothub_id}
    */
    readonly iothubId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_servicebus_topic#iothub_name IothubEndpointServicebusTopic#iothub_name}
    */
    readonly iothubName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_servicebus_topic#name IothubEndpointServicebusTopic#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_servicebus_topic#resource_group_name IothubEndpointServicebusTopic#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_servicebus_topic#timeouts IothubEndpointServicebusTopic#timeouts}
    */
    readonly timeouts?: IothubEndpointServicebusTopicTimeouts;
}
export interface IothubEndpointServicebusTopicTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_servicebus_topic#create IothubEndpointServicebusTopic#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_servicebus_topic#delete IothubEndpointServicebusTopic#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_servicebus_topic#read IothubEndpointServicebusTopic#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_servicebus_topic#update IothubEndpointServicebusTopic#update}
    */
    readonly update?: string;
}
export declare function iothubEndpointServicebusTopicTimeoutsToTerraform(struct?: IothubEndpointServicebusTopicTimeoutsOutputReference | IothubEndpointServicebusTopicTimeouts | cdktf.IResolvable): any;
export declare class IothubEndpointServicebusTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): IothubEndpointServicebusTopicTimeouts | undefined;
    set internalValue(value: IothubEndpointServicebusTopicTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_servicebus_topic azurerm_iothub_endpoint_servicebus_topic}
*/
export declare class IothubEndpointServicebusTopic extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_servicebus_topic azurerm_iothub_endpoint_servicebus_topic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IothubEndpointServicebusTopicConfig
    */
    constructor(scope: Construct, id: string, config: IothubEndpointServicebusTopicConfig);
    private _authenticationType?;
    get authenticationType(): string;
    set authenticationType(value: string);
    resetAuthenticationType(): void;
    get authenticationTypeInput(): string | undefined;
    private _connectionString?;
    get connectionString(): string;
    set connectionString(value: string);
    resetConnectionString(): void;
    get connectionStringInput(): string | undefined;
    private _endpointUri?;
    get endpointUri(): string;
    set endpointUri(value: string);
    resetEndpointUri(): void;
    get endpointUriInput(): string | undefined;
    private _entityPath?;
    get entityPath(): string;
    set entityPath(value: string);
    resetEntityPath(): void;
    get entityPathInput(): string | undefined;
    get id(): string;
    private _identityId?;
    get identityId(): string;
    set identityId(value: string);
    resetIdentityId(): void;
    get identityIdInput(): string | undefined;
    private _iothubId?;
    get iothubId(): string;
    set iothubId(value: string);
    resetIothubId(): void;
    get iothubIdInput(): string | undefined;
    private _iothubName?;
    get iothubName(): string;
    set iothubName(value: string);
    resetIothubName(): void;
    get iothubNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): IothubEndpointServicebusTopicTimeoutsOutputReference;
    putTimeouts(value: IothubEndpointServicebusTopicTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): IothubEndpointServicebusTopicTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
