import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IothubSharedAccessPolicyAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy#device_connect IothubSharedAccessPolicyA#device_connect}
    */
    readonly deviceConnect?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy#iothub_name IothubSharedAccessPolicyA#iothub_name}
    */
    readonly iothubName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy#name IothubSharedAccessPolicyA#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy#registry_read IothubSharedAccessPolicyA#registry_read}
    */
    readonly registryRead?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy#registry_write IothubSharedAccessPolicyA#registry_write}
    */
    readonly registryWrite?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy#resource_group_name IothubSharedAccessPolicyA#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy#service_connect IothubSharedAccessPolicyA#service_connect}
    */
    readonly serviceConnect?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy#timeouts IothubSharedAccessPolicyA#timeouts}
    */
    readonly timeouts?: IothubSharedAccessPolicyTimeouts;
}
export interface IothubSharedAccessPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy#create IothubSharedAccessPolicyA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy#delete IothubSharedAccessPolicyA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy#read IothubSharedAccessPolicyA#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy#update IothubSharedAccessPolicyA#update}
    */
    readonly update?: string;
}
export declare function iothubSharedAccessPolicyTimeoutsToTerraform(struct?: IothubSharedAccessPolicyTimeoutsOutputReference | IothubSharedAccessPolicyTimeouts | cdktf.IResolvable): any;
export declare class IothubSharedAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): IothubSharedAccessPolicyTimeouts | undefined;
    set internalValue(value: IothubSharedAccessPolicyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy azurerm_iothub_shared_access_policy}
*/
export declare class IothubSharedAccessPolicyA extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy azurerm_iothub_shared_access_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IothubSharedAccessPolicyAConfig
    */
    constructor(scope: Construct, id: string, config: IothubSharedAccessPolicyAConfig);
    private _deviceConnect?;
    get deviceConnect(): boolean | cdktf.IResolvable;
    set deviceConnect(value: boolean | cdktf.IResolvable);
    resetDeviceConnect(): void;
    get deviceConnectInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _iothubName?;
    get iothubName(): string;
    set iothubName(value: string);
    get iothubNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryConnectionString(): string;
    get primaryKey(): string;
    private _registryRead?;
    get registryRead(): boolean | cdktf.IResolvable;
    set registryRead(value: boolean | cdktf.IResolvable);
    resetRegistryRead(): void;
    get registryReadInput(): boolean | cdktf.IResolvable | undefined;
    private _registryWrite?;
    get registryWrite(): boolean | cdktf.IResolvable;
    set registryWrite(value: boolean | cdktf.IResolvable);
    resetRegistryWrite(): void;
    get registryWriteInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryConnectionString(): string;
    get secondaryKey(): string;
    private _serviceConnect?;
    get serviceConnect(): boolean | cdktf.IResolvable;
    set serviceConnect(value: boolean | cdktf.IResolvable);
    resetServiceConnect(): void;
    get serviceConnectInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): IothubSharedAccessPolicyTimeoutsOutputReference;
    putTimeouts(value: IothubSharedAccessPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): IothubSharedAccessPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
