import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbOutboundRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule#allocated_outbound_ports LbOutboundRule#allocated_outbound_ports}
    */
    readonly allocatedOutboundPorts?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule#backend_address_pool_id LbOutboundRule#backend_address_pool_id}
    */
    readonly backendAddressPoolId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule#enable_tcp_reset LbOutboundRule#enable_tcp_reset}
    */
    readonly enableTcpReset?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule#idle_timeout_in_minutes LbOutboundRule#idle_timeout_in_minutes}
    */
    readonly idleTimeoutInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule#loadbalancer_id LbOutboundRule#loadbalancer_id}
    */
    readonly loadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule#name LbOutboundRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule#protocol LbOutboundRule#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule#resource_group_name LbOutboundRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * frontend_ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule#frontend_ip_configuration LbOutboundRule#frontend_ip_configuration}
    */
    readonly frontendIpConfiguration?: LbOutboundRuleFrontendIpConfiguration[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule#timeouts LbOutboundRule#timeouts}
    */
    readonly timeouts?: LbOutboundRuleTimeouts;
}
export interface LbOutboundRuleFrontendIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule#name LbOutboundRule#name}
    */
    readonly name: string;
}
export declare function lbOutboundRuleFrontendIpConfigurationToTerraform(struct?: LbOutboundRuleFrontendIpConfiguration | cdktf.IResolvable): any;
export interface LbOutboundRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule#create LbOutboundRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule#delete LbOutboundRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule#read LbOutboundRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule#update LbOutboundRule#update}
    */
    readonly update?: string;
}
export declare function lbOutboundRuleTimeoutsToTerraform(struct?: LbOutboundRuleTimeoutsOutputReference | LbOutboundRuleTimeouts | cdktf.IResolvable): any;
export declare class LbOutboundRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): LbOutboundRuleTimeouts | undefined;
    set internalValue(value: LbOutboundRuleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule azurerm_lb_outbound_rule}
*/
export declare class LbOutboundRule extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule azurerm_lb_outbound_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbOutboundRuleConfig
    */
    constructor(scope: Construct, id: string, config: LbOutboundRuleConfig);
    private _allocatedOutboundPorts?;
    get allocatedOutboundPorts(): number;
    set allocatedOutboundPorts(value: number);
    resetAllocatedOutboundPorts(): void;
    get allocatedOutboundPortsInput(): number | undefined;
    private _backendAddressPoolId?;
    get backendAddressPoolId(): string;
    set backendAddressPoolId(value: string);
    get backendAddressPoolIdInput(): string | undefined;
    private _enableTcpReset?;
    get enableTcpReset(): boolean | cdktf.IResolvable;
    set enableTcpReset(value: boolean | cdktf.IResolvable);
    resetEnableTcpReset(): void;
    get enableTcpResetInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _idleTimeoutInMinutes?;
    get idleTimeoutInMinutes(): number;
    set idleTimeoutInMinutes(value: number);
    resetIdleTimeoutInMinutes(): void;
    get idleTimeoutInMinutesInput(): number | undefined;
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _frontendIpConfiguration?;
    get frontendIpConfiguration(): LbOutboundRuleFrontendIpConfiguration[] | cdktf.IResolvable;
    set frontendIpConfiguration(value: LbOutboundRuleFrontendIpConfiguration[] | cdktf.IResolvable);
    resetFrontendIpConfiguration(): void;
    get frontendIpConfigurationInput(): cdktf.IResolvable | LbOutboundRuleFrontendIpConfiguration[] | undefined;
    private _timeouts;
    get timeouts(): LbOutboundRuleTimeoutsOutputReference;
    putTimeouts(value: LbOutboundRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): LbOutboundRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
