"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MysqlServer = exports.MysqlServerTimeoutsOutputReference = exports.mysqlServerTimeoutsToTerraform = exports.MysqlServerThreatDetectionPolicyOutputReference = exports.mysqlServerThreatDetectionPolicyToTerraform = exports.MysqlServerStorageProfileOutputReference = exports.mysqlServerStorageProfileToTerraform = exports.MysqlServerIdentityOutputReference = exports.mysqlServerIdentityToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function mysqlServerIdentityToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        type: cdktf.stringToTerraform(struct.type),
    };
}
exports.mysqlServerIdentityToTerraform = mysqlServerIdentityToTerraform;
class MysqlServerIdentityOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._type !== undefined) {
            hasAnyValues = true;
            internalValueResult.type = this._type;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._type = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._type = value.type;
        }
    }
    // principal_id - computed: true, optional: false, required: false
    get principalId() {
        return this.getStringAttribute('principal_id');
    }
    // tenant_id - computed: true, optional: false, required: false
    get tenantId() {
        return this.getStringAttribute('tenant_id');
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
}
exports.MysqlServerIdentityOutputReference = MysqlServerIdentityOutputReference;
_a = JSII_RTTI_SYMBOL_1;
MysqlServerIdentityOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.MysqlServerIdentityOutputReference", version: "0.5.51" };
function mysqlServerStorageProfileToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        auto_grow: cdktf.stringToTerraform(struct.autoGrow),
        backup_retention_days: cdktf.numberToTerraform(struct.backupRetentionDays),
        geo_redundant_backup: cdktf.stringToTerraform(struct.geoRedundantBackup),
        storage_mb: cdktf.numberToTerraform(struct.storageMb),
    };
}
exports.mysqlServerStorageProfileToTerraform = mysqlServerStorageProfileToTerraform;
class MysqlServerStorageProfileOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._autoGrow !== undefined) {
            hasAnyValues = true;
            internalValueResult.autoGrow = this._autoGrow;
        }
        if (this._backupRetentionDays !== undefined) {
            hasAnyValues = true;
            internalValueResult.backupRetentionDays = this._backupRetentionDays;
        }
        if (this._geoRedundantBackup !== undefined) {
            hasAnyValues = true;
            internalValueResult.geoRedundantBackup = this._geoRedundantBackup;
        }
        if (this._storageMb !== undefined) {
            hasAnyValues = true;
            internalValueResult.storageMb = this._storageMb;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._autoGrow = undefined;
            this._backupRetentionDays = undefined;
            this._geoRedundantBackup = undefined;
            this._storageMb = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._autoGrow = value.autoGrow;
            this._backupRetentionDays = value.backupRetentionDays;
            this._geoRedundantBackup = value.geoRedundantBackup;
            this._storageMb = value.storageMb;
        }
    }
    get autoGrow() {
        return this.getStringAttribute('auto_grow');
    }
    set autoGrow(value) {
        this._autoGrow = value;
    }
    resetAutoGrow() {
        this._autoGrow = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoGrowInput() {
        return this._autoGrow;
    }
    get backupRetentionDays() {
        return this.getNumberAttribute('backup_retention_days');
    }
    set backupRetentionDays(value) {
        this._backupRetentionDays = value;
    }
    resetBackupRetentionDays() {
        this._backupRetentionDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backupRetentionDaysInput() {
        return this._backupRetentionDays;
    }
    get geoRedundantBackup() {
        return this.getStringAttribute('geo_redundant_backup');
    }
    set geoRedundantBackup(value) {
        this._geoRedundantBackup = value;
    }
    resetGeoRedundantBackup() {
        this._geoRedundantBackup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get geoRedundantBackupInput() {
        return this._geoRedundantBackup;
    }
    get storageMb() {
        return this.getNumberAttribute('storage_mb');
    }
    set storageMb(value) {
        this._storageMb = value;
    }
    resetStorageMb() {
        this._storageMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageMbInput() {
        return this._storageMb;
    }
}
exports.MysqlServerStorageProfileOutputReference = MysqlServerStorageProfileOutputReference;
_b = JSII_RTTI_SYMBOL_1;
MysqlServerStorageProfileOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.MysqlServerStorageProfileOutputReference", version: "0.5.51" };
function mysqlServerThreatDetectionPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        disabled_alerts: cdktf.listMapper(cdktf.stringToTerraform)(struct.disabledAlerts),
        email_account_admins: cdktf.booleanToTerraform(struct.emailAccountAdmins),
        email_addresses: cdktf.listMapper(cdktf.stringToTerraform)(struct.emailAddresses),
        enabled: cdktf.booleanToTerraform(struct.enabled),
        retention_days: cdktf.numberToTerraform(struct.retentionDays),
        storage_account_access_key: cdktf.stringToTerraform(struct.storageAccountAccessKey),
        storage_endpoint: cdktf.stringToTerraform(struct.storageEndpoint),
    };
}
exports.mysqlServerThreatDetectionPolicyToTerraform = mysqlServerThreatDetectionPolicyToTerraform;
class MysqlServerThreatDetectionPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._disabledAlerts !== undefined) {
            hasAnyValues = true;
            internalValueResult.disabledAlerts = this._disabledAlerts;
        }
        if (this._emailAccountAdmins !== undefined) {
            hasAnyValues = true;
            internalValueResult.emailAccountAdmins = this._emailAccountAdmins;
        }
        if (this._emailAddresses !== undefined) {
            hasAnyValues = true;
            internalValueResult.emailAddresses = this._emailAddresses;
        }
        if (this._enabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.enabled = this._enabled;
        }
        if (this._retentionDays !== undefined) {
            hasAnyValues = true;
            internalValueResult.retentionDays = this._retentionDays;
        }
        if (this._storageAccountAccessKey !== undefined) {
            hasAnyValues = true;
            internalValueResult.storageAccountAccessKey = this._storageAccountAccessKey;
        }
        if (this._storageEndpoint !== undefined) {
            hasAnyValues = true;
            internalValueResult.storageEndpoint = this._storageEndpoint;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._disabledAlerts = undefined;
            this._emailAccountAdmins = undefined;
            this._emailAddresses = undefined;
            this._enabled = undefined;
            this._retentionDays = undefined;
            this._storageAccountAccessKey = undefined;
            this._storageEndpoint = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._disabledAlerts = value.disabledAlerts;
            this._emailAccountAdmins = value.emailAccountAdmins;
            this._emailAddresses = value.emailAddresses;
            this._enabled = value.enabled;
            this._retentionDays = value.retentionDays;
            this._storageAccountAccessKey = value.storageAccountAccessKey;
            this._storageEndpoint = value.storageEndpoint;
        }
    }
    get disabledAlerts() {
        return cdktf.Fn.tolist(this.getListAttribute('disabled_alerts'));
    }
    set disabledAlerts(value) {
        this._disabledAlerts = value;
    }
    resetDisabledAlerts() {
        this._disabledAlerts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disabledAlertsInput() {
        return this._disabledAlerts;
    }
    get emailAccountAdmins() {
        return this.getBooleanAttribute('email_account_admins');
    }
    set emailAccountAdmins(value) {
        this._emailAccountAdmins = value;
    }
    resetEmailAccountAdmins() {
        this._emailAccountAdmins = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailAccountAdminsInput() {
        return this._emailAccountAdmins;
    }
    get emailAddresses() {
        return cdktf.Fn.tolist(this.getListAttribute('email_addresses'));
    }
    set emailAddresses(value) {
        this._emailAddresses = value;
    }
    resetEmailAddresses() {
        this._emailAddresses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailAddressesInput() {
        return this._emailAddresses;
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    get retentionDays() {
        return this.getNumberAttribute('retention_days');
    }
    set retentionDays(value) {
        this._retentionDays = value;
    }
    resetRetentionDays() {
        this._retentionDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get retentionDaysInput() {
        return this._retentionDays;
    }
    get storageAccountAccessKey() {
        return this.getStringAttribute('storage_account_access_key');
    }
    set storageAccountAccessKey(value) {
        this._storageAccountAccessKey = value;
    }
    resetStorageAccountAccessKey() {
        this._storageAccountAccessKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageAccountAccessKeyInput() {
        return this._storageAccountAccessKey;
    }
    get storageEndpoint() {
        return this.getStringAttribute('storage_endpoint');
    }
    set storageEndpoint(value) {
        this._storageEndpoint = value;
    }
    resetStorageEndpoint() {
        this._storageEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageEndpointInput() {
        return this._storageEndpoint;
    }
}
exports.MysqlServerThreatDetectionPolicyOutputReference = MysqlServerThreatDetectionPolicyOutputReference;
_c = JSII_RTTI_SYMBOL_1;
MysqlServerThreatDetectionPolicyOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.MysqlServerThreatDetectionPolicyOutputReference", version: "0.5.51" };
function mysqlServerTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.mysqlServerTimeoutsToTerraform = mysqlServerTimeoutsToTerraform;
class MysqlServerTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.MysqlServerTimeoutsOutputReference = MysqlServerTimeoutsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
MysqlServerTimeoutsOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.MysqlServerTimeoutsOutputReference", version: "0.5.51" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server azurerm_mysql_server}
*/
class MysqlServer extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server azurerm_mysql_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MysqlServerConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_mysql_server',
            terraformGeneratorMetadata: {
                providerName: 'azurerm'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // identity - computed: false, optional: true, required: false
        this._identity = new MysqlServerIdentityOutputReference(this, "identity", true);
        // storage_profile - computed: false, optional: true, required: false
        this._storageProfile = new MysqlServerStorageProfileOutputReference(this, "storage_profile", true);
        // threat_detection_policy - computed: false, optional: true, required: false
        this._threatDetectionPolicy = new MysqlServerThreatDetectionPolicyOutputReference(this, "threat_detection_policy", true);
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new MysqlServerTimeoutsOutputReference(this, "timeouts", true);
        this._administratorLogin = config.administratorLogin;
        this._administratorLoginPassword = config.administratorLoginPassword;
        this._autoGrowEnabled = config.autoGrowEnabled;
        this._backupRetentionDays = config.backupRetentionDays;
        this._createMode = config.createMode;
        this._creationSourceServerId = config.creationSourceServerId;
        this._geoRedundantBackupEnabled = config.geoRedundantBackupEnabled;
        this._infrastructureEncryptionEnabled = config.infrastructureEncryptionEnabled;
        this._location = config.location;
        this._name = config.name;
        this._publicNetworkAccessEnabled = config.publicNetworkAccessEnabled;
        this._resourceGroupName = config.resourceGroupName;
        this._restorePointInTime = config.restorePointInTime;
        this._skuName = config.skuName;
        this._sslEnforcement = config.sslEnforcement;
        this._sslEnforcementEnabled = config.sslEnforcementEnabled;
        this._sslMinimalTlsVersionEnforced = config.sslMinimalTlsVersionEnforced;
        this._storageMb = config.storageMb;
        this._tags = config.tags;
        this._version = config.version;
        this._identity.internalValue = config.identity;
        this._storageProfile.internalValue = config.storageProfile;
        this._threatDetectionPolicy.internalValue = config.threatDetectionPolicy;
        this._timeouts.internalValue = config.timeouts;
    }
    get administratorLogin() {
        return this.getStringAttribute('administrator_login');
    }
    set administratorLogin(value) {
        this._administratorLogin = value;
    }
    resetAdministratorLogin() {
        this._administratorLogin = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get administratorLoginInput() {
        return this._administratorLogin;
    }
    get administratorLoginPassword() {
        return this.getStringAttribute('administrator_login_password');
    }
    set administratorLoginPassword(value) {
        this._administratorLoginPassword = value;
    }
    resetAdministratorLoginPassword() {
        this._administratorLoginPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get administratorLoginPasswordInput() {
        return this._administratorLoginPassword;
    }
    get autoGrowEnabled() {
        return this.getBooleanAttribute('auto_grow_enabled');
    }
    set autoGrowEnabled(value) {
        this._autoGrowEnabled = value;
    }
    resetAutoGrowEnabled() {
        this._autoGrowEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoGrowEnabledInput() {
        return this._autoGrowEnabled;
    }
    get backupRetentionDays() {
        return this.getNumberAttribute('backup_retention_days');
    }
    set backupRetentionDays(value) {
        this._backupRetentionDays = value;
    }
    resetBackupRetentionDays() {
        this._backupRetentionDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backupRetentionDaysInput() {
        return this._backupRetentionDays;
    }
    get createMode() {
        return this.getStringAttribute('create_mode');
    }
    set createMode(value) {
        this._createMode = value;
    }
    resetCreateMode() {
        this._createMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createModeInput() {
        return this._createMode;
    }
    get creationSourceServerId() {
        return this.getStringAttribute('creation_source_server_id');
    }
    set creationSourceServerId(value) {
        this._creationSourceServerId = value;
    }
    resetCreationSourceServerId() {
        this._creationSourceServerId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get creationSourceServerIdInput() {
        return this._creationSourceServerId;
    }
    // fqdn - computed: true, optional: false, required: false
    get fqdn() {
        return this.getStringAttribute('fqdn');
    }
    get geoRedundantBackupEnabled() {
        return this.getBooleanAttribute('geo_redundant_backup_enabled');
    }
    set geoRedundantBackupEnabled(value) {
        this._geoRedundantBackupEnabled = value;
    }
    resetGeoRedundantBackupEnabled() {
        this._geoRedundantBackupEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get geoRedundantBackupEnabledInput() {
        return this._geoRedundantBackupEnabled;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get infrastructureEncryptionEnabled() {
        return this.getBooleanAttribute('infrastructure_encryption_enabled');
    }
    set infrastructureEncryptionEnabled(value) {
        this._infrastructureEncryptionEnabled = value;
    }
    resetInfrastructureEncryptionEnabled() {
        this._infrastructureEncryptionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get infrastructureEncryptionEnabledInput() {
        return this._infrastructureEncryptionEnabled;
    }
    get location() {
        return this.getStringAttribute('location');
    }
    set location(value) {
        this._location = value;
    }
    // Temporarily expose input value. Use with caution.
    get locationInput() {
        return this._location;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get publicNetworkAccessEnabled() {
        return this.getBooleanAttribute('public_network_access_enabled');
    }
    set publicNetworkAccessEnabled(value) {
        this._publicNetworkAccessEnabled = value;
    }
    resetPublicNetworkAccessEnabled() {
        this._publicNetworkAccessEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publicNetworkAccessEnabledInput() {
        return this._publicNetworkAccessEnabled;
    }
    get resourceGroupName() {
        return this.getStringAttribute('resource_group_name');
    }
    set resourceGroupName(value) {
        this._resourceGroupName = value;
    }
    // Temporarily expose input value. Use with caution.
    get resourceGroupNameInput() {
        return this._resourceGroupName;
    }
    get restorePointInTime() {
        return this.getStringAttribute('restore_point_in_time');
    }
    set restorePointInTime(value) {
        this._restorePointInTime = value;
    }
    resetRestorePointInTime() {
        this._restorePointInTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get restorePointInTimeInput() {
        return this._restorePointInTime;
    }
    get skuName() {
        return this.getStringAttribute('sku_name');
    }
    set skuName(value) {
        this._skuName = value;
    }
    // Temporarily expose input value. Use with caution.
    get skuNameInput() {
        return this._skuName;
    }
    get sslEnforcement() {
        return this.getStringAttribute('ssl_enforcement');
    }
    set sslEnforcement(value) {
        this._sslEnforcement = value;
    }
    resetSslEnforcement() {
        this._sslEnforcement = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sslEnforcementInput() {
        return this._sslEnforcement;
    }
    get sslEnforcementEnabled() {
        return this.getBooleanAttribute('ssl_enforcement_enabled');
    }
    set sslEnforcementEnabled(value) {
        this._sslEnforcementEnabled = value;
    }
    resetSslEnforcementEnabled() {
        this._sslEnforcementEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sslEnforcementEnabledInput() {
        return this._sslEnforcementEnabled;
    }
    get sslMinimalTlsVersionEnforced() {
        return this.getStringAttribute('ssl_minimal_tls_version_enforced');
    }
    set sslMinimalTlsVersionEnforced(value) {
        this._sslMinimalTlsVersionEnforced = value;
    }
    resetSslMinimalTlsVersionEnforced() {
        this._sslMinimalTlsVersionEnforced = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sslMinimalTlsVersionEnforcedInput() {
        return this._sslMinimalTlsVersionEnforced;
    }
    get storageMb() {
        return this.getNumberAttribute('storage_mb');
    }
    set storageMb(value) {
        this._storageMb = value;
    }
    resetStorageMb() {
        this._storageMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageMbInput() {
        return this._storageMb;
    }
    get tags() {
        return this.getStringMapAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get version() {
        return this.getStringAttribute('version');
    }
    set version(value) {
        this._version = value;
    }
    // Temporarily expose input value. Use with caution.
    get versionInput() {
        return this._version;
    }
    get identity() {
        return this._identity;
    }
    putIdentity(value) {
        this._identity.internalValue = value;
    }
    resetIdentity() {
        this._identity.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get identityInput() {
        return this._identity.internalValue;
    }
    get storageProfile() {
        return this._storageProfile;
    }
    putStorageProfile(value) {
        this._storageProfile.internalValue = value;
    }
    resetStorageProfile() {
        this._storageProfile.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageProfileInput() {
        return this._storageProfile.internalValue;
    }
    get threatDetectionPolicy() {
        return this._threatDetectionPolicy;
    }
    putThreatDetectionPolicy(value) {
        this._threatDetectionPolicy.internalValue = value;
    }
    resetThreatDetectionPolicy() {
        this._threatDetectionPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get threatDetectionPolicyInput() {
        return this._threatDetectionPolicy.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            administrator_login: cdktf.stringToTerraform(this._administratorLogin),
            administrator_login_password: cdktf.stringToTerraform(this._administratorLoginPassword),
            auto_grow_enabled: cdktf.booleanToTerraform(this._autoGrowEnabled),
            backup_retention_days: cdktf.numberToTerraform(this._backupRetentionDays),
            create_mode: cdktf.stringToTerraform(this._createMode),
            creation_source_server_id: cdktf.stringToTerraform(this._creationSourceServerId),
            geo_redundant_backup_enabled: cdktf.booleanToTerraform(this._geoRedundantBackupEnabled),
            infrastructure_encryption_enabled: cdktf.booleanToTerraform(this._infrastructureEncryptionEnabled),
            location: cdktf.stringToTerraform(this._location),
            name: cdktf.stringToTerraform(this._name),
            public_network_access_enabled: cdktf.booleanToTerraform(this._publicNetworkAccessEnabled),
            resource_group_name: cdktf.stringToTerraform(this._resourceGroupName),
            restore_point_in_time: cdktf.stringToTerraform(this._restorePointInTime),
            sku_name: cdktf.stringToTerraform(this._skuName),
            ssl_enforcement: cdktf.stringToTerraform(this._sslEnforcement),
            ssl_enforcement_enabled: cdktf.booleanToTerraform(this._sslEnforcementEnabled),
            ssl_minimal_tls_version_enforced: cdktf.stringToTerraform(this._sslMinimalTlsVersionEnforced),
            storage_mb: cdktf.numberToTerraform(this._storageMb),
            tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._tags),
            version: cdktf.stringToTerraform(this._version),
            identity: mysqlServerIdentityToTerraform(this._identity.internalValue),
            storage_profile: mysqlServerStorageProfileToTerraform(this._storageProfile.internalValue),
            threat_detection_policy: mysqlServerThreatDetectionPolicyToTerraform(this._threatDetectionPolicy.internalValue),
            timeouts: mysqlServerTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.MysqlServer = MysqlServer;
_e = JSII_RTTI_SYMBOL_1;
MysqlServer[_e] = { fqn: "@cdktf/provider-azurerm.MysqlServer", version: "0.5.51" };
// =================
// STATIC PROPERTIES
// =================
MysqlServer.tfResourceType = "azurerm_mysql_server";
//# sourceMappingURL=data:application/json;base64,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