import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PortalTenantConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/portal_tenant_configuration#private_markdown_storage_enforced PortalTenantConfiguration#private_markdown_storage_enforced}
    */
    readonly privateMarkdownStorageEnforced: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/portal_tenant_configuration#timeouts PortalTenantConfiguration#timeouts}
    */
    readonly timeouts?: PortalTenantConfigurationTimeouts;
}
export interface PortalTenantConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/portal_tenant_configuration#create PortalTenantConfiguration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/portal_tenant_configuration#delete PortalTenantConfiguration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/portal_tenant_configuration#read PortalTenantConfiguration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/portal_tenant_configuration#update PortalTenantConfiguration#update}
    */
    readonly update?: string;
}
export declare function portalTenantConfigurationTimeoutsToTerraform(struct?: PortalTenantConfigurationTimeoutsOutputReference | PortalTenantConfigurationTimeouts | cdktf.IResolvable): any;
export declare class PortalTenantConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): PortalTenantConfigurationTimeouts | undefined;
    set internalValue(value: PortalTenantConfigurationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/portal_tenant_configuration azurerm_portal_tenant_configuration}
*/
export declare class PortalTenantConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/portal_tenant_configuration azurerm_portal_tenant_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PortalTenantConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: PortalTenantConfigurationConfig);
    get id(): string;
    private _privateMarkdownStorageEnforced?;
    get privateMarkdownStorageEnforced(): boolean | cdktf.IResolvable;
    set privateMarkdownStorageEnforced(value: boolean | cdktf.IResolvable);
    get privateMarkdownStorageEnforcedInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): PortalTenantConfigurationTimeoutsOutputReference;
    putTimeouts(value: PortalTenantConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): PortalTenantConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
