import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivateLinkServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#auto_approval_subscription_ids PrivateLinkService#auto_approval_subscription_ids}
    */
    readonly autoApprovalSubscriptionIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#enable_proxy_protocol PrivateLinkService#enable_proxy_protocol}
    */
    readonly enableProxyProtocol?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#load_balancer_frontend_ip_configuration_ids PrivateLinkService#load_balancer_frontend_ip_configuration_ids}
    */
    readonly loadBalancerFrontendIpConfigurationIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#location PrivateLinkService#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#name PrivateLinkService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#resource_group_name PrivateLinkService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#tags PrivateLinkService#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#visibility_subscription_ids PrivateLinkService#visibility_subscription_ids}
    */
    readonly visibilitySubscriptionIds?: string[];
    /**
    * nat_ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#nat_ip_configuration PrivateLinkService#nat_ip_configuration}
    */
    readonly natIpConfiguration: PrivateLinkServiceNatIpConfiguration[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#timeouts PrivateLinkService#timeouts}
    */
    readonly timeouts?: PrivateLinkServiceTimeouts;
}
export interface PrivateLinkServiceNatIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#name PrivateLinkService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#primary PrivateLinkService#primary}
    */
    readonly primary: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#private_ip_address PrivateLinkService#private_ip_address}
    */
    readonly privateIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#private_ip_address_version PrivateLinkService#private_ip_address_version}
    */
    readonly privateIpAddressVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#subnet_id PrivateLinkService#subnet_id}
    */
    readonly subnetId: string;
}
export declare function privateLinkServiceNatIpConfigurationToTerraform(struct?: PrivateLinkServiceNatIpConfiguration | cdktf.IResolvable): any;
export interface PrivateLinkServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#create PrivateLinkService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#delete PrivateLinkService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#read PrivateLinkService#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service#update PrivateLinkService#update}
    */
    readonly update?: string;
}
export declare function privateLinkServiceTimeoutsToTerraform(struct?: PrivateLinkServiceTimeoutsOutputReference | PrivateLinkServiceTimeouts | cdktf.IResolvable): any;
export declare class PrivateLinkServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): PrivateLinkServiceTimeouts | undefined;
    set internalValue(value: PrivateLinkServiceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service azurerm_private_link_service}
*/
export declare class PrivateLinkService extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service azurerm_private_link_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivateLinkServiceConfig
    */
    constructor(scope: Construct, id: string, config: PrivateLinkServiceConfig);
    get alias(): string;
    private _autoApprovalSubscriptionIds?;
    get autoApprovalSubscriptionIds(): string[];
    set autoApprovalSubscriptionIds(value: string[]);
    resetAutoApprovalSubscriptionIds(): void;
    get autoApprovalSubscriptionIdsInput(): string[] | undefined;
    private _enableProxyProtocol?;
    get enableProxyProtocol(): boolean | cdktf.IResolvable;
    set enableProxyProtocol(value: boolean | cdktf.IResolvable);
    resetEnableProxyProtocol(): void;
    get enableProxyProtocolInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _loadBalancerFrontendIpConfigurationIds?;
    get loadBalancerFrontendIpConfigurationIds(): string[];
    set loadBalancerFrontendIpConfigurationIds(value: string[]);
    get loadBalancerFrontendIpConfigurationIdsInput(): string[] | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _visibilitySubscriptionIds?;
    get visibilitySubscriptionIds(): string[];
    set visibilitySubscriptionIds(value: string[]);
    resetVisibilitySubscriptionIds(): void;
    get visibilitySubscriptionIdsInput(): string[] | undefined;
    private _natIpConfiguration?;
    get natIpConfiguration(): PrivateLinkServiceNatIpConfiguration[] | cdktf.IResolvable;
    set natIpConfiguration(value: PrivateLinkServiceNatIpConfiguration[] | cdktf.IResolvable);
    get natIpConfigurationInput(): cdktf.IResolvable | PrivateLinkServiceNatIpConfiguration[] | undefined;
    private _timeouts;
    get timeouts(): PrivateLinkServiceTimeoutsOutputReference;
    putTimeouts(value: PrivateLinkServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): PrivateLinkServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
