import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SentinelDataConnectorAwsCloudTrailConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_aws_cloud_trail#aws_role_arn SentinelDataConnectorAwsCloudTrail#aws_role_arn}
    */
    readonly awsRoleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_aws_cloud_trail#log_analytics_workspace_id SentinelDataConnectorAwsCloudTrail#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_aws_cloud_trail#name SentinelDataConnectorAwsCloudTrail#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_aws_cloud_trail#timeouts SentinelDataConnectorAwsCloudTrail#timeouts}
    */
    readonly timeouts?: SentinelDataConnectorAwsCloudTrailTimeouts;
}
export interface SentinelDataConnectorAwsCloudTrailTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_aws_cloud_trail#create SentinelDataConnectorAwsCloudTrail#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_aws_cloud_trail#delete SentinelDataConnectorAwsCloudTrail#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_aws_cloud_trail#read SentinelDataConnectorAwsCloudTrail#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_aws_cloud_trail#update SentinelDataConnectorAwsCloudTrail#update}
    */
    readonly update?: string;
}
export declare function sentinelDataConnectorAwsCloudTrailTimeoutsToTerraform(struct?: SentinelDataConnectorAwsCloudTrailTimeoutsOutputReference | SentinelDataConnectorAwsCloudTrailTimeouts | cdktf.IResolvable): any;
export declare class SentinelDataConnectorAwsCloudTrailTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SentinelDataConnectorAwsCloudTrailTimeouts | undefined;
    set internalValue(value: SentinelDataConnectorAwsCloudTrailTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_aws_cloud_trail azurerm_sentinel_data_connector_aws_cloud_trail}
*/
export declare class SentinelDataConnectorAwsCloudTrail extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_aws_cloud_trail azurerm_sentinel_data_connector_aws_cloud_trail} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SentinelDataConnectorAwsCloudTrailConfig
    */
    constructor(scope: Construct, id: string, config: SentinelDataConnectorAwsCloudTrailConfig);
    private _awsRoleArn?;
    get awsRoleArn(): string;
    set awsRoleArn(value: string);
    get awsRoleArnInput(): string | undefined;
    get id(): string;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): SentinelDataConnectorAwsCloudTrailTimeoutsOutputReference;
    putTimeouts(value: SentinelDataConnectorAwsCloudTrailTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SentinelDataConnectorAwsCloudTrailTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
