import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicebusSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#auto_delete_on_idle ServicebusSubscription#auto_delete_on_idle}
    */
    readonly autoDeleteOnIdle?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#dead_lettering_on_filter_evaluation_error ServicebusSubscription#dead_lettering_on_filter_evaluation_error}
    */
    readonly deadLetteringOnFilterEvaluationError?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#dead_lettering_on_message_expiration ServicebusSubscription#dead_lettering_on_message_expiration}
    */
    readonly deadLetteringOnMessageExpiration?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#default_message_ttl ServicebusSubscription#default_message_ttl}
    */
    readonly defaultMessageTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#enable_batched_operations ServicebusSubscription#enable_batched_operations}
    */
    readonly enableBatchedOperations?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#forward_dead_lettered_messages_to ServicebusSubscription#forward_dead_lettered_messages_to}
    */
    readonly forwardDeadLetteredMessagesTo?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#forward_to ServicebusSubscription#forward_to}
    */
    readonly forwardTo?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#lock_duration ServicebusSubscription#lock_duration}
    */
    readonly lockDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#max_delivery_count ServicebusSubscription#max_delivery_count}
    */
    readonly maxDeliveryCount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#name ServicebusSubscription#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#namespace_name ServicebusSubscription#namespace_name}
    */
    readonly namespaceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#requires_session ServicebusSubscription#requires_session}
    */
    readonly requiresSession?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#resource_group_name ServicebusSubscription#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#status ServicebusSubscription#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#topic_id ServicebusSubscription#topic_id}
    */
    readonly topicId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#topic_name ServicebusSubscription#topic_name}
    */
    readonly topicName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#timeouts ServicebusSubscription#timeouts}
    */
    readonly timeouts?: ServicebusSubscriptionTimeouts;
}
export interface ServicebusSubscriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#create ServicebusSubscription#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#delete ServicebusSubscription#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#read ServicebusSubscription#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription#update ServicebusSubscription#update}
    */
    readonly update?: string;
}
export declare function servicebusSubscriptionTimeoutsToTerraform(struct?: ServicebusSubscriptionTimeoutsOutputReference | ServicebusSubscriptionTimeouts | cdktf.IResolvable): any;
export declare class ServicebusSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ServicebusSubscriptionTimeouts | undefined;
    set internalValue(value: ServicebusSubscriptionTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription azurerm_servicebus_subscription}
*/
export declare class ServicebusSubscription extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription azurerm_servicebus_subscription} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicebusSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: ServicebusSubscriptionConfig);
    private _autoDeleteOnIdle?;
    get autoDeleteOnIdle(): string;
    set autoDeleteOnIdle(value: string);
    resetAutoDeleteOnIdle(): void;
    get autoDeleteOnIdleInput(): string | undefined;
    private _deadLetteringOnFilterEvaluationError?;
    get deadLetteringOnFilterEvaluationError(): boolean | cdktf.IResolvable;
    set deadLetteringOnFilterEvaluationError(value: boolean | cdktf.IResolvable);
    resetDeadLetteringOnFilterEvaluationError(): void;
    get deadLetteringOnFilterEvaluationErrorInput(): boolean | cdktf.IResolvable | undefined;
    private _deadLetteringOnMessageExpiration?;
    get deadLetteringOnMessageExpiration(): boolean | cdktf.IResolvable;
    set deadLetteringOnMessageExpiration(value: boolean | cdktf.IResolvable);
    resetDeadLetteringOnMessageExpiration(): void;
    get deadLetteringOnMessageExpirationInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultMessageTtl?;
    get defaultMessageTtl(): string;
    set defaultMessageTtl(value: string);
    resetDefaultMessageTtl(): void;
    get defaultMessageTtlInput(): string | undefined;
    private _enableBatchedOperations?;
    get enableBatchedOperations(): boolean | cdktf.IResolvable;
    set enableBatchedOperations(value: boolean | cdktf.IResolvable);
    resetEnableBatchedOperations(): void;
    get enableBatchedOperationsInput(): boolean | cdktf.IResolvable | undefined;
    private _forwardDeadLetteredMessagesTo?;
    get forwardDeadLetteredMessagesTo(): string;
    set forwardDeadLetteredMessagesTo(value: string);
    resetForwardDeadLetteredMessagesTo(): void;
    get forwardDeadLetteredMessagesToInput(): string | undefined;
    private _forwardTo?;
    get forwardTo(): string;
    set forwardTo(value: string);
    resetForwardTo(): void;
    get forwardToInput(): string | undefined;
    get id(): string;
    private _lockDuration?;
    get lockDuration(): string;
    set lockDuration(value: string);
    resetLockDuration(): void;
    get lockDurationInput(): string | undefined;
    private _maxDeliveryCount?;
    get maxDeliveryCount(): number;
    set maxDeliveryCount(value: number);
    get maxDeliveryCountInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    resetNamespaceName(): void;
    get namespaceNameInput(): string | undefined;
    private _requiresSession?;
    get requiresSession(): boolean | cdktf.IResolvable;
    set requiresSession(value: boolean | cdktf.IResolvable);
    resetRequiresSession(): void;
    get requiresSessionInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _topicId?;
    get topicId(): string;
    set topicId(value: string);
    resetTopicId(): void;
    get topicIdInput(): string | undefined;
    private _topicName?;
    get topicName(): string;
    set topicName(value: string);
    resetTopicName(): void;
    get topicNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): ServicebusSubscriptionTimeoutsOutputReference;
    putTimeouts(value: ServicebusSubscriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ServicebusSubscriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
