"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageManagementPolicy = exports.StorageManagementPolicyTimeoutsOutputReference = exports.storageManagementPolicyTimeoutsToTerraform = exports.storageManagementPolicyRuleToTerraform = exports.StorageManagementPolicyRuleFiltersOutputReference = exports.storageManagementPolicyRuleFiltersToTerraform = exports.storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform = exports.StorageManagementPolicyRuleActionsOutputReference = exports.storageManagementPolicyRuleActionsToTerraform = exports.StorageManagementPolicyRuleActionsVersionOutputReference = exports.storageManagementPolicyRuleActionsVersionToTerraform = exports.StorageManagementPolicyRuleActionsSnapshotOutputReference = exports.storageManagementPolicyRuleActionsSnapshotToTerraform = exports.StorageManagementPolicyRuleActionsBaseBlobOutputReference = exports.storageManagementPolicyRuleActionsBaseBlobToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function storageManagementPolicyRuleActionsBaseBlobToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        delete_after_days_since_last_access_time_greater_than: cdktf.numberToTerraform(struct.deleteAfterDaysSinceLastAccessTimeGreaterThan),
        delete_after_days_since_modification_greater_than: cdktf.numberToTerraform(struct.deleteAfterDaysSinceModificationGreaterThan),
        tier_to_archive_after_days_since_last_access_time_greater_than: cdktf.numberToTerraform(struct.tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan),
        tier_to_archive_after_days_since_modification_greater_than: cdktf.numberToTerraform(struct.tierToArchiveAfterDaysSinceModificationGreaterThan),
        tier_to_cool_after_days_since_last_access_time_greater_than: cdktf.numberToTerraform(struct.tierToCoolAfterDaysSinceLastAccessTimeGreaterThan),
        tier_to_cool_after_days_since_modification_greater_than: cdktf.numberToTerraform(struct.tierToCoolAfterDaysSinceModificationGreaterThan),
    };
}
exports.storageManagementPolicyRuleActionsBaseBlobToTerraform = storageManagementPolicyRuleActionsBaseBlobToTerraform;
class StorageManagementPolicyRuleActionsBaseBlobOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._deleteAfterDaysSinceLastAccessTimeGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceLastAccessTimeGreaterThan = this._deleteAfterDaysSinceLastAccessTimeGreaterThan;
        }
        if (this._deleteAfterDaysSinceModificationGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceModificationGreaterThan = this._deleteAfterDaysSinceModificationGreaterThan;
        }
        if (this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan = this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan;
        }
        if (this._tierToArchiveAfterDaysSinceModificationGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.tierToArchiveAfterDaysSinceModificationGreaterThan = this._tierToArchiveAfterDaysSinceModificationGreaterThan;
        }
        if (this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.tierToCoolAfterDaysSinceLastAccessTimeGreaterThan = this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan;
        }
        if (this._tierToCoolAfterDaysSinceModificationGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.tierToCoolAfterDaysSinceModificationGreaterThan = this._tierToCoolAfterDaysSinceModificationGreaterThan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._deleteAfterDaysSinceLastAccessTimeGreaterThan = undefined;
            this._deleteAfterDaysSinceModificationGreaterThan = undefined;
            this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan = undefined;
            this._tierToArchiveAfterDaysSinceModificationGreaterThan = undefined;
            this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan = undefined;
            this._tierToCoolAfterDaysSinceModificationGreaterThan = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._deleteAfterDaysSinceLastAccessTimeGreaterThan = value.deleteAfterDaysSinceLastAccessTimeGreaterThan;
            this._deleteAfterDaysSinceModificationGreaterThan = value.deleteAfterDaysSinceModificationGreaterThan;
            this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan = value.tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan;
            this._tierToArchiveAfterDaysSinceModificationGreaterThan = value.tierToArchiveAfterDaysSinceModificationGreaterThan;
            this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan = value.tierToCoolAfterDaysSinceLastAccessTimeGreaterThan;
            this._tierToCoolAfterDaysSinceModificationGreaterThan = value.tierToCoolAfterDaysSinceModificationGreaterThan;
        }
    }
    get deleteAfterDaysSinceLastAccessTimeGreaterThan() {
        return this.getNumberAttribute('delete_after_days_since_last_access_time_greater_than');
    }
    set deleteAfterDaysSinceLastAccessTimeGreaterThan(value) {
        this._deleteAfterDaysSinceLastAccessTimeGreaterThan = value;
    }
    resetDeleteAfterDaysSinceLastAccessTimeGreaterThan() {
        this._deleteAfterDaysSinceLastAccessTimeGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteAfterDaysSinceLastAccessTimeGreaterThanInput() {
        return this._deleteAfterDaysSinceLastAccessTimeGreaterThan;
    }
    get deleteAfterDaysSinceModificationGreaterThan() {
        return this.getNumberAttribute('delete_after_days_since_modification_greater_than');
    }
    set deleteAfterDaysSinceModificationGreaterThan(value) {
        this._deleteAfterDaysSinceModificationGreaterThan = value;
    }
    resetDeleteAfterDaysSinceModificationGreaterThan() {
        this._deleteAfterDaysSinceModificationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteAfterDaysSinceModificationGreaterThanInput() {
        return this._deleteAfterDaysSinceModificationGreaterThan;
    }
    get tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan() {
        return this.getNumberAttribute('tier_to_archive_after_days_since_last_access_time_greater_than');
    }
    set tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan(value) {
        this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan = value;
    }
    resetTierToArchiveAfterDaysSinceLastAccessTimeGreaterThan() {
        this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tierToArchiveAfterDaysSinceLastAccessTimeGreaterThanInput() {
        return this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan;
    }
    get tierToArchiveAfterDaysSinceModificationGreaterThan() {
        return this.getNumberAttribute('tier_to_archive_after_days_since_modification_greater_than');
    }
    set tierToArchiveAfterDaysSinceModificationGreaterThan(value) {
        this._tierToArchiveAfterDaysSinceModificationGreaterThan = value;
    }
    resetTierToArchiveAfterDaysSinceModificationGreaterThan() {
        this._tierToArchiveAfterDaysSinceModificationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tierToArchiveAfterDaysSinceModificationGreaterThanInput() {
        return this._tierToArchiveAfterDaysSinceModificationGreaterThan;
    }
    get tierToCoolAfterDaysSinceLastAccessTimeGreaterThan() {
        return this.getNumberAttribute('tier_to_cool_after_days_since_last_access_time_greater_than');
    }
    set tierToCoolAfterDaysSinceLastAccessTimeGreaterThan(value) {
        this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan = value;
    }
    resetTierToCoolAfterDaysSinceLastAccessTimeGreaterThan() {
        this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tierToCoolAfterDaysSinceLastAccessTimeGreaterThanInput() {
        return this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan;
    }
    get tierToCoolAfterDaysSinceModificationGreaterThan() {
        return this.getNumberAttribute('tier_to_cool_after_days_since_modification_greater_than');
    }
    set tierToCoolAfterDaysSinceModificationGreaterThan(value) {
        this._tierToCoolAfterDaysSinceModificationGreaterThan = value;
    }
    resetTierToCoolAfterDaysSinceModificationGreaterThan() {
        this._tierToCoolAfterDaysSinceModificationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tierToCoolAfterDaysSinceModificationGreaterThanInput() {
        return this._tierToCoolAfterDaysSinceModificationGreaterThan;
    }
}
exports.StorageManagementPolicyRuleActionsBaseBlobOutputReference = StorageManagementPolicyRuleActionsBaseBlobOutputReference;
_a = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsBaseBlobOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsBaseBlobOutputReference", version: "0.5.51" };
function storageManagementPolicyRuleActionsSnapshotToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        change_tier_to_archive_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToArchiveAfterDaysSinceCreation),
        change_tier_to_cool_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToCoolAfterDaysSinceCreation),
        delete_after_days_since_creation_greater_than: cdktf.numberToTerraform(struct.deleteAfterDaysSinceCreationGreaterThan),
    };
}
exports.storageManagementPolicyRuleActionsSnapshotToTerraform = storageManagementPolicyRuleActionsSnapshotToTerraform;
class StorageManagementPolicyRuleActionsSnapshotOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._changeTierToArchiveAfterDaysSinceCreation !== undefined) {
            hasAnyValues = true;
            internalValueResult.changeTierToArchiveAfterDaysSinceCreation = this._changeTierToArchiveAfterDaysSinceCreation;
        }
        if (this._changeTierToCoolAfterDaysSinceCreation !== undefined) {
            hasAnyValues = true;
            internalValueResult.changeTierToCoolAfterDaysSinceCreation = this._changeTierToCoolAfterDaysSinceCreation;
        }
        if (this._deleteAfterDaysSinceCreationGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceCreationGreaterThan = this._deleteAfterDaysSinceCreationGreaterThan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._changeTierToArchiveAfterDaysSinceCreation = undefined;
            this._changeTierToCoolAfterDaysSinceCreation = undefined;
            this._deleteAfterDaysSinceCreationGreaterThan = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._changeTierToArchiveAfterDaysSinceCreation = value.changeTierToArchiveAfterDaysSinceCreation;
            this._changeTierToCoolAfterDaysSinceCreation = value.changeTierToCoolAfterDaysSinceCreation;
            this._deleteAfterDaysSinceCreationGreaterThan = value.deleteAfterDaysSinceCreationGreaterThan;
        }
    }
    get changeTierToArchiveAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_archive_after_days_since_creation');
    }
    set changeTierToArchiveAfterDaysSinceCreation(value) {
        this._changeTierToArchiveAfterDaysSinceCreation = value;
    }
    resetChangeTierToArchiveAfterDaysSinceCreation() {
        this._changeTierToArchiveAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get changeTierToArchiveAfterDaysSinceCreationInput() {
        return this._changeTierToArchiveAfterDaysSinceCreation;
    }
    get changeTierToCoolAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_cool_after_days_since_creation');
    }
    set changeTierToCoolAfterDaysSinceCreation(value) {
        this._changeTierToCoolAfterDaysSinceCreation = value;
    }
    resetChangeTierToCoolAfterDaysSinceCreation() {
        this._changeTierToCoolAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get changeTierToCoolAfterDaysSinceCreationInput() {
        return this._changeTierToCoolAfterDaysSinceCreation;
    }
    get deleteAfterDaysSinceCreationGreaterThan() {
        return this.getNumberAttribute('delete_after_days_since_creation_greater_than');
    }
    set deleteAfterDaysSinceCreationGreaterThan(value) {
        this._deleteAfterDaysSinceCreationGreaterThan = value;
    }
    resetDeleteAfterDaysSinceCreationGreaterThan() {
        this._deleteAfterDaysSinceCreationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteAfterDaysSinceCreationGreaterThanInput() {
        return this._deleteAfterDaysSinceCreationGreaterThan;
    }
}
exports.StorageManagementPolicyRuleActionsSnapshotOutputReference = StorageManagementPolicyRuleActionsSnapshotOutputReference;
_b = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsSnapshotOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsSnapshotOutputReference", version: "0.5.51" };
function storageManagementPolicyRuleActionsVersionToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        change_tier_to_archive_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToArchiveAfterDaysSinceCreation),
        change_tier_to_cool_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToCoolAfterDaysSinceCreation),
        delete_after_days_since_creation: cdktf.numberToTerraform(struct.deleteAfterDaysSinceCreation),
    };
}
exports.storageManagementPolicyRuleActionsVersionToTerraform = storageManagementPolicyRuleActionsVersionToTerraform;
class StorageManagementPolicyRuleActionsVersionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._changeTierToArchiveAfterDaysSinceCreation !== undefined) {
            hasAnyValues = true;
            internalValueResult.changeTierToArchiveAfterDaysSinceCreation = this._changeTierToArchiveAfterDaysSinceCreation;
        }
        if (this._changeTierToCoolAfterDaysSinceCreation !== undefined) {
            hasAnyValues = true;
            internalValueResult.changeTierToCoolAfterDaysSinceCreation = this._changeTierToCoolAfterDaysSinceCreation;
        }
        if (this._deleteAfterDaysSinceCreation !== undefined) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceCreation = this._deleteAfterDaysSinceCreation;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._changeTierToArchiveAfterDaysSinceCreation = undefined;
            this._changeTierToCoolAfterDaysSinceCreation = undefined;
            this._deleteAfterDaysSinceCreation = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._changeTierToArchiveAfterDaysSinceCreation = value.changeTierToArchiveAfterDaysSinceCreation;
            this._changeTierToCoolAfterDaysSinceCreation = value.changeTierToCoolAfterDaysSinceCreation;
            this._deleteAfterDaysSinceCreation = value.deleteAfterDaysSinceCreation;
        }
    }
    get changeTierToArchiveAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_archive_after_days_since_creation');
    }
    set changeTierToArchiveAfterDaysSinceCreation(value) {
        this._changeTierToArchiveAfterDaysSinceCreation = value;
    }
    resetChangeTierToArchiveAfterDaysSinceCreation() {
        this._changeTierToArchiveAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get changeTierToArchiveAfterDaysSinceCreationInput() {
        return this._changeTierToArchiveAfterDaysSinceCreation;
    }
    get changeTierToCoolAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_cool_after_days_since_creation');
    }
    set changeTierToCoolAfterDaysSinceCreation(value) {
        this._changeTierToCoolAfterDaysSinceCreation = value;
    }
    resetChangeTierToCoolAfterDaysSinceCreation() {
        this._changeTierToCoolAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get changeTierToCoolAfterDaysSinceCreationInput() {
        return this._changeTierToCoolAfterDaysSinceCreation;
    }
    get deleteAfterDaysSinceCreation() {
        return this.getNumberAttribute('delete_after_days_since_creation');
    }
    set deleteAfterDaysSinceCreation(value) {
        this._deleteAfterDaysSinceCreation = value;
    }
    resetDeleteAfterDaysSinceCreation() {
        this._deleteAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteAfterDaysSinceCreationInput() {
        return this._deleteAfterDaysSinceCreation;
    }
}
exports.StorageManagementPolicyRuleActionsVersionOutputReference = StorageManagementPolicyRuleActionsVersionOutputReference;
_c = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsVersionOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsVersionOutputReference", version: "0.5.51" };
function storageManagementPolicyRuleActionsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        base_blob: storageManagementPolicyRuleActionsBaseBlobToTerraform(struct.baseBlob),
        snapshot: storageManagementPolicyRuleActionsSnapshotToTerraform(struct.snapshot),
        version: storageManagementPolicyRuleActionsVersionToTerraform(struct.version),
    };
}
exports.storageManagementPolicyRuleActionsToTerraform = storageManagementPolicyRuleActionsToTerraform;
class StorageManagementPolicyRuleActionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
        // base_blob - computed: false, optional: true, required: false
        this._baseBlob = new StorageManagementPolicyRuleActionsBaseBlobOutputReference(this, "base_blob", true);
        // snapshot - computed: false, optional: true, required: false
        this._snapshot = new StorageManagementPolicyRuleActionsSnapshotOutputReference(this, "snapshot", true);
        // version - computed: false, optional: true, required: false
        this._version = new StorageManagementPolicyRuleActionsVersionOutputReference(this, "version", true);
    }
    get internalValue() {
        var _h, _j, _k, _l, _m, _o;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (((_h = this._baseBlob) === null || _h === void 0 ? void 0 : _h.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.baseBlob = (_j = this._baseBlob) === null || _j === void 0 ? void 0 : _j.internalValue;
        }
        if (((_k = this._snapshot) === null || _k === void 0 ? void 0 : _k.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.snapshot = (_l = this._snapshot) === null || _l === void 0 ? void 0 : _l.internalValue;
        }
        if (((_m = this._version) === null || _m === void 0 ? void 0 : _m.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.version = (_o = this._version) === null || _o === void 0 ? void 0 : _o.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._baseBlob.internalValue = undefined;
            this._snapshot.internalValue = undefined;
            this._version.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._baseBlob.internalValue = value.baseBlob;
            this._snapshot.internalValue = value.snapshot;
            this._version.internalValue = value.version;
        }
    }
    get baseBlob() {
        return this._baseBlob;
    }
    putBaseBlob(value) {
        this._baseBlob.internalValue = value;
    }
    resetBaseBlob() {
        this._baseBlob.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get baseBlobInput() {
        return this._baseBlob.internalValue;
    }
    get snapshot() {
        return this._snapshot;
    }
    putSnapshot(value) {
        this._snapshot.internalValue = value;
    }
    resetSnapshot() {
        this._snapshot.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snapshotInput() {
        return this._snapshot.internalValue;
    }
    get version() {
        return this._version;
    }
    putVersion(value) {
        this._version.internalValue = value;
    }
    resetVersion() {
        this._version.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get versionInput() {
        return this._version.internalValue;
    }
}
exports.StorageManagementPolicyRuleActionsOutputReference = StorageManagementPolicyRuleActionsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsOutputReference", version: "0.5.51" };
function storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        operation: cdktf.stringToTerraform(struct.operation),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform = storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform;
function storageManagementPolicyRuleFiltersToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        blob_types: cdktf.listMapper(cdktf.stringToTerraform)(struct.blobTypes),
        prefix_match: cdktf.listMapper(cdktf.stringToTerraform)(struct.prefixMatch),
        match_blob_index_tag: cdktf.listMapper(storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform)(struct.matchBlobIndexTag),
    };
}
exports.storageManagementPolicyRuleFiltersToTerraform = storageManagementPolicyRuleFiltersToTerraform;
class StorageManagementPolicyRuleFiltersOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._blobTypes !== undefined) {
            hasAnyValues = true;
            internalValueResult.blobTypes = this._blobTypes;
        }
        if (this._prefixMatch !== undefined) {
            hasAnyValues = true;
            internalValueResult.prefixMatch = this._prefixMatch;
        }
        if (this._matchBlobIndexTag !== undefined) {
            hasAnyValues = true;
            internalValueResult.matchBlobIndexTag = this._matchBlobIndexTag;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._blobTypes = undefined;
            this._prefixMatch = undefined;
            this._matchBlobIndexTag = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._blobTypes = value.blobTypes;
            this._prefixMatch = value.prefixMatch;
            this._matchBlobIndexTag = value.matchBlobIndexTag;
        }
    }
    get blobTypes() {
        return cdktf.Fn.tolist(this.getListAttribute('blob_types'));
    }
    set blobTypes(value) {
        this._blobTypes = value;
    }
    resetBlobTypes() {
        this._blobTypes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get blobTypesInput() {
        return this._blobTypes;
    }
    get prefixMatch() {
        return cdktf.Fn.tolist(this.getListAttribute('prefix_match'));
    }
    set prefixMatch(value) {
        this._prefixMatch = value;
    }
    resetPrefixMatch() {
        this._prefixMatch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get prefixMatchInput() {
        return this._prefixMatch;
    }
    get matchBlobIndexTag() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('match_blob_index_tag')));
    }
    set matchBlobIndexTag(value) {
        this._matchBlobIndexTag = value;
    }
    resetMatchBlobIndexTag() {
        this._matchBlobIndexTag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get matchBlobIndexTagInput() {
        return this._matchBlobIndexTag;
    }
}
exports.StorageManagementPolicyRuleFiltersOutputReference = StorageManagementPolicyRuleFiltersOutputReference;
_e = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleFiltersOutputReference[_e] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleFiltersOutputReference", version: "0.5.51" };
function storageManagementPolicyRuleToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        enabled: cdktf.booleanToTerraform(struct.enabled),
        name: cdktf.stringToTerraform(struct.name),
        actions: storageManagementPolicyRuleActionsToTerraform(struct.actions),
        filters: storageManagementPolicyRuleFiltersToTerraform(struct.filters),
    };
}
exports.storageManagementPolicyRuleToTerraform = storageManagementPolicyRuleToTerraform;
function storageManagementPolicyTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.storageManagementPolicyTimeoutsToTerraform = storageManagementPolicyTimeoutsToTerraform;
class StorageManagementPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.StorageManagementPolicyTimeoutsOutputReference = StorageManagementPolicyTimeoutsOutputReference;
_f = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyTimeoutsOutputReference[_f] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyTimeoutsOutputReference", version: "0.5.51" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy azurerm_storage_management_policy}
*/
class StorageManagementPolicy extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy azurerm_storage_management_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageManagementPolicyConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_storage_management_policy',
            terraformGeneratorMetadata: {
                providerName: 'azurerm'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new StorageManagementPolicyTimeoutsOutputReference(this, "timeouts", true);
        this._storageAccountId = config.storageAccountId;
        this._rule = config.rule;
        this._timeouts.internalValue = config.timeouts;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get storageAccountId() {
        return this.getStringAttribute('storage_account_id');
    }
    set storageAccountId(value) {
        this._storageAccountId = value;
    }
    // Temporarily expose input value. Use with caution.
    get storageAccountIdInput() {
        return this._storageAccountId;
    }
    get rule() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('rule');
    }
    set rule(value) {
        this._rule = value;
    }
    resetRule() {
        this._rule = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ruleInput() {
        return this._rule;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            storage_account_id: cdktf.stringToTerraform(this._storageAccountId),
            rule: cdktf.listMapper(storageManagementPolicyRuleToTerraform)(this._rule),
            timeouts: storageManagementPolicyTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.StorageManagementPolicy = StorageManagementPolicy;
_g = JSII_RTTI_SYMBOL_1;
StorageManagementPolicy[_g] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicy", version: "0.5.51" };
// =================
// STATIC PROPERTIES
// =================
StorageManagementPolicy.tfResourceType = "azurerm_storage_management_policy";
//# sourceMappingURL=data:application/json;base64,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