import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_table#name StorageTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_table#storage_account_name StorageTable#storage_account_name}
    */
    readonly storageAccountName: string;
    /**
    * acl block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_table#acl StorageTable#acl}
    */
    readonly acl?: StorageTableAcl[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_table#timeouts StorageTable#timeouts}
    */
    readonly timeouts?: StorageTableTimeouts;
}
export interface StorageTableAclAccessPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_table#expiry StorageTable#expiry}
    */
    readonly expiry: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_table#permissions StorageTable#permissions}
    */
    readonly permissions: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_table#start StorageTable#start}
    */
    readonly start: string;
}
export declare function storageTableAclAccessPolicyToTerraform(struct?: StorageTableAclAccessPolicy | cdktf.IResolvable): any;
export interface StorageTableAcl {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_table#id StorageTable#id}
    */
    readonly id: string;
    /**
    * access_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_table#access_policy StorageTable#access_policy}
    */
    readonly accessPolicy?: StorageTableAclAccessPolicy[] | cdktf.IResolvable;
}
export declare function storageTableAclToTerraform(struct?: StorageTableAcl | cdktf.IResolvable): any;
export interface StorageTableTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_table#create StorageTable#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_table#delete StorageTable#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_table#read StorageTable#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_table#update StorageTable#update}
    */
    readonly update?: string;
}
export declare function storageTableTimeoutsToTerraform(struct?: StorageTableTimeoutsOutputReference | StorageTableTimeouts | cdktf.IResolvable): any;
export declare class StorageTableTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): StorageTableTimeouts | undefined;
    set internalValue(value: StorageTableTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_table azurerm_storage_table}
*/
export declare class StorageTable extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_table azurerm_storage_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageTableConfig
    */
    constructor(scope: Construct, id: string, config: StorageTableConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    get storageAccountNameInput(): string | undefined;
    private _acl?;
    get acl(): StorageTableAcl[] | cdktf.IResolvable;
    set acl(value: StorageTableAcl[] | cdktf.IResolvable);
    resetAcl(): void;
    get aclInput(): cdktf.IResolvable | StorageTableAcl[] | undefined;
    private _timeouts;
    get timeouts(): StorageTableTimeoutsOutputReference;
    putTimeouts(value: StorageTableTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): StorageTableTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
