import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StreamAnalyticsOutputBlobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#batch_max_wait_time StreamAnalyticsOutputBlob#batch_max_wait_time}
    */
    readonly batchMaxWaitTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#batch_min_rows StreamAnalyticsOutputBlob#batch_min_rows}
    */
    readonly batchMinRows?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#date_format StreamAnalyticsOutputBlob#date_format}
    */
    readonly dateFormat: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#name StreamAnalyticsOutputBlob#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#path_pattern StreamAnalyticsOutputBlob#path_pattern}
    */
    readonly pathPattern: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#resource_group_name StreamAnalyticsOutputBlob#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#storage_account_key StreamAnalyticsOutputBlob#storage_account_key}
    */
    readonly storageAccountKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#storage_account_name StreamAnalyticsOutputBlob#storage_account_name}
    */
    readonly storageAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#storage_container_name StreamAnalyticsOutputBlob#storage_container_name}
    */
    readonly storageContainerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#stream_analytics_job_name StreamAnalyticsOutputBlob#stream_analytics_job_name}
    */
    readonly streamAnalyticsJobName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#time_format StreamAnalyticsOutputBlob#time_format}
    */
    readonly timeFormat: string;
    /**
    * serialization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#serialization StreamAnalyticsOutputBlob#serialization}
    */
    readonly serialization: StreamAnalyticsOutputBlobSerialization;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#timeouts StreamAnalyticsOutputBlob#timeouts}
    */
    readonly timeouts?: StreamAnalyticsOutputBlobTimeouts;
}
export interface StreamAnalyticsOutputBlobSerialization {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#encoding StreamAnalyticsOutputBlob#encoding}
    */
    readonly encoding?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#field_delimiter StreamAnalyticsOutputBlob#field_delimiter}
    */
    readonly fieldDelimiter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#format StreamAnalyticsOutputBlob#format}
    */
    readonly format?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#type StreamAnalyticsOutputBlob#type}
    */
    readonly type: string;
}
export declare function streamAnalyticsOutputBlobSerializationToTerraform(struct?: StreamAnalyticsOutputBlobSerializationOutputReference | StreamAnalyticsOutputBlobSerialization): any;
export declare class StreamAnalyticsOutputBlobSerializationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): StreamAnalyticsOutputBlobSerialization | undefined;
    set internalValue(value: StreamAnalyticsOutputBlobSerialization | undefined);
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _fieldDelimiter?;
    get fieldDelimiter(): string;
    set fieldDelimiter(value: string);
    resetFieldDelimiter(): void;
    get fieldDelimiterInput(): string | undefined;
    private _format?;
    get format(): string;
    set format(value: string);
    resetFormat(): void;
    get formatInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface StreamAnalyticsOutputBlobTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#create StreamAnalyticsOutputBlob#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#delete StreamAnalyticsOutputBlob#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#read StreamAnalyticsOutputBlob#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#update StreamAnalyticsOutputBlob#update}
    */
    readonly update?: string;
}
export declare function streamAnalyticsOutputBlobTimeoutsToTerraform(struct?: StreamAnalyticsOutputBlobTimeoutsOutputReference | StreamAnalyticsOutputBlobTimeouts | cdktf.IResolvable): any;
export declare class StreamAnalyticsOutputBlobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): StreamAnalyticsOutputBlobTimeouts | undefined;
    set internalValue(value: StreamAnalyticsOutputBlobTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob azurerm_stream_analytics_output_blob}
*/
export declare class StreamAnalyticsOutputBlob extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob azurerm_stream_analytics_output_blob} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StreamAnalyticsOutputBlobConfig
    */
    constructor(scope: Construct, id: string, config: StreamAnalyticsOutputBlobConfig);
    private _batchMaxWaitTime?;
    get batchMaxWaitTime(): string;
    set batchMaxWaitTime(value: string);
    resetBatchMaxWaitTime(): void;
    get batchMaxWaitTimeInput(): string | undefined;
    private _batchMinRows?;
    get batchMinRows(): number;
    set batchMinRows(value: number);
    resetBatchMinRows(): void;
    get batchMinRowsInput(): number | undefined;
    private _dateFormat?;
    get dateFormat(): string;
    set dateFormat(value: string);
    get dateFormatInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pathPattern?;
    get pathPattern(): string;
    set pathPattern(value: string);
    get pathPatternInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _storageAccountKey?;
    get storageAccountKey(): string;
    set storageAccountKey(value: string);
    get storageAccountKeyInput(): string | undefined;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    get storageAccountNameInput(): string | undefined;
    private _storageContainerName?;
    get storageContainerName(): string;
    set storageContainerName(value: string);
    get storageContainerNameInput(): string | undefined;
    private _streamAnalyticsJobName?;
    get streamAnalyticsJobName(): string;
    set streamAnalyticsJobName(value: string);
    get streamAnalyticsJobNameInput(): string | undefined;
    private _timeFormat?;
    get timeFormat(): string;
    set timeFormat(value: string);
    get timeFormatInput(): string | undefined;
    private _serialization;
    get serialization(): StreamAnalyticsOutputBlobSerializationOutputReference;
    putSerialization(value: StreamAnalyticsOutputBlobSerialization): void;
    get serializationInput(): StreamAnalyticsOutputBlobSerialization | undefined;
    private _timeouts;
    get timeouts(): StreamAnalyticsOutputBlobTimeoutsOutputReference;
    putTimeouts(value: StreamAnalyticsOutputBlobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): StreamAnalyticsOutputBlobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
