import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SubnetNetworkSecurityGroupAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_network_security_group_association#network_security_group_id SubnetNetworkSecurityGroupAssociation#network_security_group_id}
    */
    readonly networkSecurityGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_network_security_group_association#subnet_id SubnetNetworkSecurityGroupAssociation#subnet_id}
    */
    readonly subnetId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_network_security_group_association#timeouts SubnetNetworkSecurityGroupAssociation#timeouts}
    */
    readonly timeouts?: SubnetNetworkSecurityGroupAssociationTimeouts;
}
export interface SubnetNetworkSecurityGroupAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_network_security_group_association#create SubnetNetworkSecurityGroupAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_network_security_group_association#delete SubnetNetworkSecurityGroupAssociation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_network_security_group_association#read SubnetNetworkSecurityGroupAssociation#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_network_security_group_association#update SubnetNetworkSecurityGroupAssociation#update}
    */
    readonly update?: string;
}
export declare function subnetNetworkSecurityGroupAssociationTimeoutsToTerraform(struct?: SubnetNetworkSecurityGroupAssociationTimeoutsOutputReference | SubnetNetworkSecurityGroupAssociationTimeouts | cdktf.IResolvable): any;
export declare class SubnetNetworkSecurityGroupAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SubnetNetworkSecurityGroupAssociationTimeouts | undefined;
    set internalValue(value: SubnetNetworkSecurityGroupAssociationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_network_security_group_association azurerm_subnet_network_security_group_association}
*/
export declare class SubnetNetworkSecurityGroupAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_network_security_group_association azurerm_subnet_network_security_group_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SubnetNetworkSecurityGroupAssociationConfig
    */
    constructor(scope: Construct, id: string, config: SubnetNetworkSecurityGroupAssociationConfig);
    get id(): string;
    private _networkSecurityGroupId?;
    get networkSecurityGroupId(): string;
    set networkSecurityGroupId(value: string);
    get networkSecurityGroupIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SubnetNetworkSecurityGroupAssociationTimeoutsOutputReference;
    putTimeouts(value: SubnetNetworkSecurityGroupAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SubnetNetworkSecurityGroupAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
