import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return its metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/database#name DataSnowflakeDatabase#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/database snowflake_database}
*/
export declare class DataSnowflakeDatabase extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/database snowflake_database} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeDatabaseConfig);
    get comment(): string;
    get createdOn(): string;
    get id(): string;
    get isCurrent(): cdktf.IResolvable;
    get isDefault(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get options(): string;
    get origin(): string;
    get owner(): string;
    get retentionTime(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
