import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeMaskingPoliciesConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/masking_policies#database DataSnowflakeMaskingPolicies#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the maskingPolicies from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/masking_policies#schema DataSnowflakeMaskingPolicies#schema}
    */
    readonly schema: string;
}
export declare class DataSnowflakeMaskingPoliciesMaskingPolicies extends cdktf.ComplexComputedList {
    get comment(): string;
    get database(): string;
    get kind(): string;
    get name(): string;
    get schema(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/masking_policies snowflake_masking_policies}
*/
export declare class DataSnowflakeMaskingPolicies extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/masking_policies snowflake_masking_policies} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeMaskingPoliciesConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeMaskingPoliciesConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    maskingPolicies(index: string): DataSnowflakeMaskingPoliciesMaskingPolicies;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
