import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeViewsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/views#database DataSnowflakeViews#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the views from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/views#schema DataSnowflakeViews#schema}
    */
    readonly schema: string;
}
export declare class DataSnowflakeViewsViews extends cdktf.ComplexComputedList {
    get comment(): string;
    get database(): string;
    get name(): string;
    get schema(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/views snowflake_views}
*/
export declare class DataSnowflakeViews extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/views snowflake_views} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeViewsConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeViewsConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    views(index: string): DataSnowflakeViewsViews;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
