import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabaseGrantConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the database on which to grant privileges.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database_grant#database_name DatabaseGrant#database_name}
    */
    readonly databaseName: string;
    /**
    * When this is set to true, multiple grants of the same type can be created. This will cause Terraform to not revoke grants applied to roles and objects outside Terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database_grant#enable_multiple_grants DatabaseGrant#enable_multiple_grants}
    */
    readonly enableMultipleGrants?: boolean | cdktf.IResolvable;
    /**
    * The privilege to grant on the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database_grant#privilege DatabaseGrant#privilege}
    */
    readonly privilege?: string;
    /**
    * Grants privilege to these roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database_grant#roles DatabaseGrant#roles}
    */
    readonly roles?: string[];
    /**
    * Grants privilege to these shares.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database_grant#shares DatabaseGrant#shares}
    */
    readonly shares?: string[];
    /**
    * When this is set to true, allows the recipient role to grant the privileges to other roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database_grant#with_grant_option DatabaseGrant#with_grant_option}
    */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/database_grant snowflake_database_grant}
*/
export declare class DatabaseGrant extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/database_grant snowflake_database_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseGrantConfig
    */
    constructor(scope: Construct, id: string, config: DatabaseGrantConfig);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _enableMultipleGrants?;
    get enableMultipleGrants(): boolean | cdktf.IResolvable;
    set enableMultipleGrants(value: boolean | cdktf.IResolvable);
    resetEnableMultipleGrants(): void;
    get enableMultipleGrantsInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _privilege?;
    get privilege(): string;
    set privilege(value: string);
    resetPrivilege(): void;
    get privilegeInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    resetRoles(): void;
    get rolesInput(): string[] | undefined;
    private _shares?;
    get shares(): string[];
    set shares(value: string[]);
    resetShares(): void;
    get sharesInput(): string[] | undefined;
    private _withGrantOption?;
    get withGrantOption(): boolean | cdktf.IResolvable;
    set withGrantOption(value: boolean | cdktf.IResolvable);
    resetWithGrantOption(): void;
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
