import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SamlIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies whether this security integration is enabled or disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#enabled SamlIntegration#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Specifies the name of the SAML2 integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#name SamlIntegration#name}
    */
    readonly name: string;
    /**
    * The Boolean indicating if the Log In With button will be shown on the login page. TRUE: displays the Log in WIth button on the login page.  FALSE: does not display the Log in With button on the login page.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_enable_sp_initiated SamlIntegration#saml2_enable_sp_initiated}
    */
    readonly saml2EnableSpInitiated?: boolean | cdktf.IResolvable;
    /**
    * The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake. When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_force_authn SamlIntegration#saml2_force_authn}
    */
    readonly saml2ForceAuthn?: boolean | cdktf.IResolvable;
    /**
    * The string containing the IdP EntityID / Issuer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_issuer SamlIntegration#saml2_issuer}
    */
    readonly saml2Issuer: string;
    /**
    * The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface. Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_post_logout_redirect_url SamlIntegration#saml2_post_logout_redirect_url}
    */
    readonly saml2PostLogoutRedirectUrl?: string;
    /**
    * The string describing the IdP. One of the following: OKTA, ADFS, Custom.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_provider SamlIntegration#saml2_provider}
    */
    readonly saml2Provider: string;
    /**
    * The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. If a value is not specified, Snowflake sends the urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress value in the authentication request to the IdP. NameID must be one of the following values: urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified, urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress, urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName, urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName, urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos, urn:oasis:names:tc:SAML:2.0:nameid-format:persistent, urn:oasis:names:tc:SAML:2.0:nameid-format:transient .
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_requested_nameid_format SamlIntegration#saml2_requested_nameid_format}
    */
    readonly saml2RequestedNameidFormat?: string;
    /**
    * The Boolean indicating whether SAML requests are signed. TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_sign_request SamlIntegration#saml2_sign_request}
    */
    readonly saml2SignRequest?: boolean | cdktf.IResolvable;
    /**
    * The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake. This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Default: https://<account_locator>.<region>.snowflakecomputing.com/fed/login
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_snowflake_acs_url SamlIntegration#saml2_snowflake_acs_url}
    */
    readonly saml2SnowflakeAcsUrl?: string;
    /**
    * The string containing the EntityID / Issuer for the Snowflake service provider. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_snowflake_issuer_url SamlIntegration#saml2_snowflake_issuer_url}
    */
    readonly saml2SnowflakeIssuerUrl?: string;
    /**
    * The Base64 encoded self-signed certificate generated by Snowflake for use with Encrypting SAML Assertions and Signed SAML Requests. You must have at least one of these features (encrypted SAML assertions or signed SAML responses) enabled in your Snowflake account to access the certificate value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_snowflake_x509_cert SamlIntegration#saml2_snowflake_x509_cert}
    */
    readonly saml2SnowflakeX509Cert?: string;
    /**
    * The string containing the label to display after the Log In With button on the login page.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_sp_initiated_login_page_label SamlIntegration#saml2_sp_initiated_login_page_label}
    */
    readonly saml2SpInitiatedLoginPageLabel?: string;
    /**
    * The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_sso_url SamlIntegration#saml2_sso_url}
    */
    readonly saml2SsoUrl: string;
    /**
    * The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_x509_cert SamlIntegration#saml2_x509_cert}
    */
    readonly saml2X509Cert: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration snowflake_saml_integration}
*/
export declare class SamlIntegration extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration snowflake_saml_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SamlIntegrationConfig
    */
    constructor(scope: Construct, id: string, config: SamlIntegrationConfig);
    get createdOn(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get saml2DigestMethodsUsed(): string;
    private _saml2EnableSpInitiated?;
    get saml2EnableSpInitiated(): boolean | cdktf.IResolvable;
    set saml2EnableSpInitiated(value: boolean | cdktf.IResolvable);
    resetSaml2EnableSpInitiated(): void;
    get saml2EnableSpInitiatedInput(): boolean | cdktf.IResolvable | undefined;
    private _saml2ForceAuthn?;
    get saml2ForceAuthn(): boolean | cdktf.IResolvable;
    set saml2ForceAuthn(value: boolean | cdktf.IResolvable);
    resetSaml2ForceAuthn(): void;
    get saml2ForceAuthnInput(): boolean | cdktf.IResolvable | undefined;
    private _saml2Issuer?;
    get saml2Issuer(): string;
    set saml2Issuer(value: string);
    get saml2IssuerInput(): string | undefined;
    private _saml2PostLogoutRedirectUrl?;
    get saml2PostLogoutRedirectUrl(): string;
    set saml2PostLogoutRedirectUrl(value: string);
    resetSaml2PostLogoutRedirectUrl(): void;
    get saml2PostLogoutRedirectUrlInput(): string | undefined;
    private _saml2Provider?;
    get saml2Provider(): string;
    set saml2Provider(value: string);
    get saml2ProviderInput(): string | undefined;
    private _saml2RequestedNameidFormat?;
    get saml2RequestedNameidFormat(): string;
    set saml2RequestedNameidFormat(value: string);
    resetSaml2RequestedNameidFormat(): void;
    get saml2RequestedNameidFormatInput(): string | undefined;
    private _saml2SignRequest?;
    get saml2SignRequest(): boolean | cdktf.IResolvable;
    set saml2SignRequest(value: boolean | cdktf.IResolvable);
    resetSaml2SignRequest(): void;
    get saml2SignRequestInput(): boolean | cdktf.IResolvable | undefined;
    get saml2SignatureMethodsUsed(): string;
    private _saml2SnowflakeAcsUrl?;
    get saml2SnowflakeAcsUrl(): string;
    set saml2SnowflakeAcsUrl(value: string);
    resetSaml2SnowflakeAcsUrl(): void;
    get saml2SnowflakeAcsUrlInput(): string | undefined;
    private _saml2SnowflakeIssuerUrl?;
    get saml2SnowflakeIssuerUrl(): string;
    set saml2SnowflakeIssuerUrl(value: string);
    resetSaml2SnowflakeIssuerUrl(): void;
    get saml2SnowflakeIssuerUrlInput(): string | undefined;
    get saml2SnowflakeMetadata(): string;
    private _saml2SnowflakeX509Cert?;
    get saml2SnowflakeX509Cert(): string;
    set saml2SnowflakeX509Cert(value: string);
    resetSaml2SnowflakeX509Cert(): void;
    get saml2SnowflakeX509CertInput(): string | undefined;
    private _saml2SpInitiatedLoginPageLabel?;
    get saml2SpInitiatedLoginPageLabel(): string;
    set saml2SpInitiatedLoginPageLabel(value: string);
    resetSaml2SpInitiatedLoginPageLabel(): void;
    get saml2SpInitiatedLoginPageLabelInput(): string | undefined;
    private _saml2SsoUrl?;
    get saml2SsoUrl(): string;
    set saml2SsoUrl(value: string);
    get saml2SsoUrlInput(): string | undefined;
    private _saml2X509Cert?;
    get saml2X509Cert(): string;
    set saml2X509Cert(value: string);
    get saml2X509CertInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
