import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SchemaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the schema.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#comment Schema#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the schema, as well as specifying the default Time Travel retention time for all tables created in the schema.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#data_retention_days Schema#data_retention_days}
    */
    readonly dataRetentionDays?: number;
    /**
    * The database in which to create the schema.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#database Schema#database}
    */
    readonly database: string;
    /**
    * Specifies a managed schema. Managed access schemas centralize privilege management with the schema owner.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#is_managed Schema#is_managed}
    */
    readonly isManaged?: boolean | cdktf.IResolvable;
    /**
    * Specifies a schema as transient. Transient schemas do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#is_transient Schema#is_transient}
    */
    readonly isTransient?: boolean | cdktf.IResolvable;
    /**
    * Specifies the identifier for the schema; must be unique for the database in which the schema is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#name Schema#name}
    */
    readonly name: string;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#tag Schema#tag}
    */
    readonly tag?: SchemaTag[] | cdktf.IResolvable;
}
export interface SchemaTag {
    /**
    * Name of the database that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#database Schema#database}
    */
    readonly database?: string;
    /**
    * Tag name, e.g. department.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#name Schema#name}
    */
    readonly name: string;
    /**
    * Name of the schema that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#schema Schema#schema}
    */
    readonly schema?: string;
    /**
    * Tag value, e.g. marketing_info.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#value Schema#value}
    */
    readonly value: string;
}
export declare function schemaTagToTerraform(struct?: SchemaTag | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/schema snowflake_schema}
*/
export declare class Schema extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/schema snowflake_schema} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SchemaConfig
    */
    constructor(scope: Construct, id: string, config: SchemaConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _dataRetentionDays?;
    get dataRetentionDays(): number;
    set dataRetentionDays(value: number);
    resetDataRetentionDays(): void;
    get dataRetentionDaysInput(): number | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    private _isManaged?;
    get isManaged(): boolean | cdktf.IResolvable;
    set isManaged(value: boolean | cdktf.IResolvable);
    resetIsManaged(): void;
    get isManagedInput(): boolean | cdktf.IResolvable | undefined;
    private _isTransient?;
    get isTransient(): boolean | cdktf.IResolvable;
    set isTransient(value: boolean | cdktf.IResolvable);
    resetIsTransient(): void;
    get isTransientInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tag?;
    get tag(): SchemaTag[] | cdktf.IResolvable;
    set tag(value: SchemaTag[] | cdktf.IResolvable);
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | SchemaTag[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
