# eis-billing
The EMIL BillingService API description

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 1.7.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.emil.de](https://www.emil.de)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install eis.billing
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/emilDev/eis-billing-sdk.git`)

Then import the package:
```python
import eis.billing
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import eis.billing
```

## Getting Started

The environment variables must be set in order to properly use this SDK.

```shell 
export EMIL_USERNAME=XXXXXXX
export EMIL_PASSWORD=XXXXXXX
```

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
import time
import eis.billing
from pprint import pprint
from eis.billing.api import correction_invoices_api
from eis.billing.model.create_correction_invoices_response_class import CreateCorrectionInvoicesResponseClass
from eis.billing.model.create_invoice_request_dto import CreateInvoiceRequestDto
# Defining the host is optional and defaults to https://apiv2.emil.de
# See configuration.py for a list of all supported configuration parameters.
configuration = eis.billing.Configuration(
    host = "https://apiv2.emil.de"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Bearer is automatically handled with exported environment variables. However, you
# can manuallay configure Bearer authorization (JWT): bearer
configuration = eis.billing.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# After manual token becomes invalid, the SDK will default to re-login automatically
# with environment variable credentials.


# Enter a context with an instance of the API client
with eis.billing.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = correction_invoices_api.CorrectionInvoicesApi(api_client)
    create_invoice_request_dto = CreateInvoiceRequestDto(
        invoice_number="3",
        account_number="472922",
        policy_code="pol_4EQEnLC1pVaPKNSZ",
        policy_number="472922",
        type="initial",
        metadata={},
        billing_interval_from=dateutil_parser('2024-04-01T00:00:00Z'),
        billing_interval_to=dateutil_parser('2024-05-01T00:00:00Z'),
        due_date=dateutil_parser('2024-04-01T00:00:00Z'),
    ) # CreateInvoiceRequestDto | 
    authorization = "Authorization_example" # str | Bearer Token (optional)
    idempotency_key = "Idempotency-Key_example" # str | Idempotency Key used to make the request idempotent. The key should be unique.       Usually, a generated v4 UUID is enough. (optional)

    try:
        # Create the correction invoice
        api_response = api_instance.create_correction_invoice(create_invoice_request_dto, authorization=authorization, idempotency_key=idempotency_key)
        pprint(api_response)
    except eis.billing.ApiException as e:
        print("Exception when calling CorrectionInvoicesApi->create_correction_invoice: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://apiv2.emil.de*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CorrectionInvoicesApi* | [**create_correction_invoice**](docs/CorrectionInvoicesApi.md#create_correction_invoice) | **POST** /billingservice/v1/correction-invoices | Create the correction invoice
*DraftInvoiceApi* | [**create_draft_invoice**](docs/DraftInvoiceApi.md#create_draft_invoice) | **POST** /billingservice/v1/draft-invoices | 
*DraftInvoiceApi* | [**delete_all_draft_invoices**](docs/DraftInvoiceApi.md#delete_all_draft_invoices) | **DELETE** /billingservice/v1/draft-invoices | 
*DraftInvoiceApi* | [**delete_draft_invoice**](docs/DraftInvoiceApi.md#delete_draft_invoice) | **DELETE** /billingservice/v1/draft-invoices/code | 
*EstimatedInvoicesApi* | [**create_custom_estimated_invoice**](docs/EstimatedInvoicesApi.md#create_custom_estimated_invoice) | **POST** /billingservice/v1/estimated-invoices/custom | Create the custom estimated invoice
*EstimatedInvoicesApi* | [**create_estimated_invoice**](docs/EstimatedInvoicesApi.md#create_estimated_invoice) | **POST** /billingservice/v1/estimated-invoices | Create the estimated invoice
*EstimatedInvoicesApi* | [**create_estimated_invoice_from_interval**](docs/EstimatedInvoicesApi.md#create_estimated_invoice_from_interval) | **POST** /billingservice/v1/estimated-invoices/interval | Create the estimated invoice
*InitialInvoicesApi* | [**create_initial_invoice**](docs/InitialInvoicesApi.md#create_initial_invoice) | **POST** /billingservice/v1/initial-invoices | Create the initial invoice
*InvoicesApi* | [**get_invoice**](docs/InvoicesApi.md#get_invoice) | **GET** /billingservice/v1/invoices/{code} | Retrieve the invoice
*InvoicesApi* | [**list_invoices**](docs/InvoicesApi.md#list_invoices) | **GET** /billingservice/v1/invoices | List invoices
*InvoicesApi* | [**list_policies_billing_dates**](docs/InvoicesApi.md#list_policies_billing_dates) | **GET** /billingservice/v1/invoices/policies-billing-dates | List policies billing dates
*RecurringInvoicesApi* | [**create_recurring_invoice**](docs/RecurringInvoicesApi.md#create_recurring_invoice) | **POST** /billingservice/v1/recurring-invoices | Create the recurring invoice
*DefaultApi* | [**check**](docs/DefaultApi.md#check) | **GET** /billingservice/health | 


## Documentation For Models

 - [CreateCorrectionInvoicesResponseClass](docs/CreateCorrectionInvoicesResponseClass.md)
 - [CreateCustomEstimatedInvoiceRequestDto](docs/CreateCustomEstimatedInvoiceRequestDto.md)
 - [CreateCustomEstimatedInvoiceResponseClass](docs/CreateCustomEstimatedInvoiceResponseClass.md)
 - [CreateDraftInvoiceRequestDto](docs/CreateDraftInvoiceRequestDto.md)
 - [CreateEstimatedInvoiceForIntervalRequestDto](docs/CreateEstimatedInvoiceForIntervalRequestDto.md)
 - [CreateEstimatedInvoiceForIntervalResponseClass](docs/CreateEstimatedInvoiceForIntervalResponseClass.md)
 - [CreateEstimatedInvoiceRequestDto](docs/CreateEstimatedInvoiceRequestDto.md)
 - [CreateEstimatedInvoiceResponseClass](docs/CreateEstimatedInvoiceResponseClass.md)
 - [CreateInvoicePaymentRequestDto](docs/CreateInvoicePaymentRequestDto.md)
 - [CreateInvoiceRequestDto](docs/CreateInvoiceRequestDto.md)
 - [CreateInvoiceResponseClass](docs/CreateInvoiceResponseClass.md)
 - [CreateInvoiceStatusRequestDto](docs/CreateInvoiceStatusRequestDto.md)
 - [CreateTerminationInvoiceRequestDto](docs/CreateTerminationInvoiceRequestDto.md)
 - [GetInvoiceResponseClass](docs/GetInvoiceResponseClass.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse503](docs/InlineResponse503.md)
 - [InvoiceClass](docs/InvoiceClass.md)
 - [InvoiceItemClass](docs/InvoiceItemClass.md)
 - [InvoicePaymentClass](docs/InvoicePaymentClass.md)
 - [InvoicePaymentsClass](docs/InvoicePaymentsClass.md)
 - [InvoiceStatusClass](docs/InvoiceStatusClass.md)
 - [ListInvoicesResponseClass](docs/ListInvoicesResponseClass.md)
 - [ListPoliciesBillingDatesResponseClass](docs/ListPoliciesBillingDatesResponseClass.md)
 - [ListRequestDto](docs/ListRequestDto.md)
 - [OmitTypeClass](docs/OmitTypeClass.md)
 - [PolicyBillingDateClass](docs/PolicyBillingDateClass.md)
 - [PolicyDto](docs/PolicyDto.md)
 - [PolicyObjectDto](docs/PolicyObjectDto.md)
 - [PolicyPremiumDto](docs/PolicyPremiumDto.md)
 - [PolicyPremiumItemDto](docs/PolicyPremiumItemDto.md)
 - [PolicyVersionDto](docs/PolicyVersionDto.md)
 - [PremiumFormulaDto](docs/PremiumFormulaDto.md)
 - [RevertInvoiceRequestDto](docs/RevertInvoiceRequestDto.md)
 - [TimesliceDto](docs/TimesliceDto.md)


## Documentation For Authorization


## bearer

- **Type**: Bearer authentication (JWT)


## Author

kontakt@emil.de


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in eis.billing.apis and eis.billing.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from eis.billing.api.default_api import DefaultApi`
- `from eis.billing.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import eis.billing
from eis.billing.apis import *
from eis.billing.models import *
```

