"""
    EMIL BillingService

    The EMIL BillingService API description  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: kontakt@emil.de
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from eis.billing.api_client import ApiClient, Endpoint as _Endpoint
from eis.billing.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from eis.billing.model.create_custom_estimated_invoice_request_dto import CreateCustomEstimatedInvoiceRequestDto
from eis.billing.model.create_custom_estimated_invoice_response_class import CreateCustomEstimatedInvoiceResponseClass
from eis.billing.model.create_estimated_invoice_for_interval_request_dto import CreateEstimatedInvoiceForIntervalRequestDto
from eis.billing.model.create_estimated_invoice_for_interval_response_class import CreateEstimatedInvoiceForIntervalResponseClass
from eis.billing.model.create_estimated_invoice_request_dto import CreateEstimatedInvoiceRequestDto
from eis.billing.model.create_estimated_invoice_response_class import CreateEstimatedInvoiceResponseClass


class EstimatedInvoicesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_custom_estimated_invoice_endpoint = _Endpoint(
            settings={
                'response_type': (CreateCustomEstimatedInvoiceResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/billingservice/v1/estimated-invoices/custom',
                'operation_id': 'create_custom_estimated_invoice',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_custom_estimated_invoice_request_dto',
                    'authorization',
                ],
                'required': [
                    'create_custom_estimated_invoice_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_custom_estimated_invoice_request_dto':
                        (CreateCustomEstimatedInvoiceRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'create_custom_estimated_invoice_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_estimated_invoice_endpoint = _Endpoint(
            settings={
                'response_type': (CreateEstimatedInvoiceResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/billingservice/v1/estimated-invoices',
                'operation_id': 'create_estimated_invoice',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_estimated_invoice_request_dto',
                    'authorization',
                ],
                'required': [
                    'create_estimated_invoice_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_estimated_invoice_request_dto':
                        (CreateEstimatedInvoiceRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'create_estimated_invoice_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_estimated_invoice_from_interval_endpoint = _Endpoint(
            settings={
                'response_type': (CreateEstimatedInvoiceForIntervalResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/billingservice/v1/estimated-invoices/interval',
                'operation_id': 'create_estimated_invoice_from_interval',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_estimated_invoice_for_interval_request_dto',
                    'authorization',
                ],
                'required': [
                    'create_estimated_invoice_for_interval_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_estimated_invoice_for_interval_request_dto':
                        (CreateEstimatedInvoiceForIntervalRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'create_estimated_invoice_for_interval_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_custom_estimated_invoice(
        self,
        create_custom_estimated_invoice_request_dto,
        **kwargs
    ):
        """Create the custom estimated invoice  # noqa: E501

        This will create a custom estimated invoice.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_custom_estimated_invoice(create_custom_estimated_invoice_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            create_custom_estimated_invoice_request_dto (CreateCustomEstimatedInvoiceRequestDto):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateCustomEstimatedInvoiceResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_custom_estimated_invoice_request_dto'] = \
            create_custom_estimated_invoice_request_dto
        return self.create_custom_estimated_invoice_endpoint.call_with_http_info(**kwargs)

    def create_estimated_invoice(
        self,
        create_estimated_invoice_request_dto,
        **kwargs
    ):
        """Create the estimated invoice  # noqa: E501

        This creates an estimated invoice. It will not be saved in the database.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_estimated_invoice(create_estimated_invoice_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            create_estimated_invoice_request_dto (CreateEstimatedInvoiceRequestDto):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateEstimatedInvoiceResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_estimated_invoice_request_dto'] = \
            create_estimated_invoice_request_dto
        return self.create_estimated_invoice_endpoint.call_with_http_info(**kwargs)

    def create_estimated_invoice_from_interval(
        self,
        create_estimated_invoice_for_interval_request_dto,
        **kwargs
    ):
        """Create the estimated invoice  # noqa: E501

        This creates an estimated invoice. It will not be saved in the database.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_estimated_invoice_from_interval(create_estimated_invoice_for_interval_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            create_estimated_invoice_for_interval_request_dto (CreateEstimatedInvoiceForIntervalRequestDto):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateEstimatedInvoiceForIntervalResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_estimated_invoice_for_interval_request_dto'] = \
            create_estimated_invoice_for_interval_request_dto
        return self.create_estimated_invoice_from_interval_endpoint.call_with_http_info(**kwargs)

