"""
    EMIL BillingService

    The EMIL BillingService API description  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: kontakt@emil.de
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from eis.billing.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from eis.billing.exceptions import ApiAttributeError


def lazy_import():
    from eis.billing.model.invoice_item_class import InvoiceItemClass
    from eis.billing.model.invoice_payments_class import InvoicePaymentsClass
    globals()['InvoiceItemClass'] = InvoiceItemClass
    globals()['InvoicePaymentsClass'] = InvoicePaymentsClass


class OmitTypeClass(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('type',): {
            'INITIAL': "initial",
            'RECURRING': "recurring",
            'CORRECTION': "correction",
            'ESTIMATED': "estimated",
            'PENALTY': "penalty",
            'OTHER': "other",
            'WITHDRAW': "withdraw",
            'FINAL': "final",
        },
        ('status',): {
            'OPEN': "open",
            'PAID': "paid",
            'PARTIALLY-PAID': "partially-paid",
            'REFUNDED': "refunded",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (float,),  # noqa: E501
            'policy_code': (str,),  # noqa: E501
            'account_number': (str,),  # noqa: E501
            'policy_number': (str,),  # noqa: E501
            'code': (str,),  # noqa: E501
            'type': (str,),  # noqa: E501
            'invoice_number': (str,),  # noqa: E501
            'net_amount': (float,),  # noqa: E501
            'tax_amount': (float,),  # noqa: E501
            'credit_amount': (float,),  # noqa: E501
            'gross_amount': (float,),  # noqa: E501
            'paid_amount': (float,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'due_date': (datetime,),  # noqa: E501
            'metadata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'billing_interval_from': (datetime,),  # noqa: E501
            'billing_interval_to': (datetime,),  # noqa: E501
            'created_at': (datetime,),  # noqa: E501
            'invoice_items': ([InvoiceItemClass],),  # noqa: E501
            'currency': (str,),  # noqa: E501
            'payments': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'policy_code': 'policyCode',  # noqa: E501
        'account_number': 'accountNumber',  # noqa: E501
        'policy_number': 'policyNumber',  # noqa: E501
        'code': 'code',  # noqa: E501
        'type': 'type',  # noqa: E501
        'invoice_number': 'invoiceNumber',  # noqa: E501
        'net_amount': 'netAmount',  # noqa: E501
        'tax_amount': 'taxAmount',  # noqa: E501
        'credit_amount': 'creditAmount',  # noqa: E501
        'gross_amount': 'grossAmount',  # noqa: E501
        'paid_amount': 'paidAmount',  # noqa: E501
        'status': 'status',  # noqa: E501
        'due_date': 'dueDate',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
        'billing_interval_from': 'billingIntervalFrom',  # noqa: E501
        'billing_interval_to': 'billingIntervalTo',  # noqa: E501
        'created_at': 'createdAt',  # noqa: E501
        'invoice_items': 'invoiceItems',  # noqa: E501
        'currency': 'currency',  # noqa: E501
        'payments': 'payments',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, id, policy_code, account_number, policy_number, code, type, invoice_number, net_amount, tax_amount, credit_amount, gross_amount, paid_amount, status, due_date, metadata, billing_interval_from, billing_interval_to, created_at, invoice_items, currency, payments, *args, **kwargs):  # noqa: E501
        """OmitTypeClass - a model defined in OpenAPI

        Args:
            id (float): Internal unique identifier for the object. You should not have to use this, use code instead.
            policy_code (str): Unique identifier of the policy that this object belongs to.
            account_number (str): Account number.
            policy_number (str): Policy number.
            code (str): Unique identifier for the object.
            type (str): Invoice type.
            invoice_number (str): Invoice number.
            net_amount (float): Net amount is in cents.
            tax_amount (float): Tax amount is in cents.
            credit_amount (float): Credit amount.
            gross_amount (float): Gross amount. This property is sum of taxAmount and netAmount.
            paid_amount (float): Paid amount. This property is amount paid by this invoice. The amount corresponds to the sum (positives and negatives) of all payments relating to that invoice.
            status (str): Invoice status.
            due_date (datetime): Invoice due date.
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Metadata contains extra information that the object would need for specific cases.
            billing_interval_from (datetime): Start date of billing interval.
            billing_interval_to (datetime): End date of billing interval.
            created_at (datetime): Time at which the object was created.
            invoice_items ([InvoiceItemClass]): Invoice items.
            currency (str): Invoice currency. EUR is used by default.
            payments (bool, date, datetime, dict, float, int, list, str, none_type): Invoice payments.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.policy_code = policy_code
        self.account_number = account_number
        self.policy_number = policy_number
        self.code = code
        self.type = type
        self.invoice_number = invoice_number
        self.net_amount = net_amount
        self.tax_amount = tax_amount
        self.credit_amount = credit_amount
        self.gross_amount = gross_amount
        self.paid_amount = paid_amount
        self.status = status
        self.due_date = due_date
        self.metadata = metadata
        self.billing_interval_from = billing_interval_from
        self.billing_interval_to = billing_interval_to
        self.created_at = created_at
        self.invoice_items = invoice_items
        self.currency = currency
        self.payments = payments
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, id, policy_code, account_number, policy_number, code, type, invoice_number, net_amount, tax_amount, credit_amount, gross_amount, paid_amount, status, due_date, metadata, billing_interval_from, billing_interval_to, created_at, invoice_items, currency, payments, *args, **kwargs):  # noqa: E501
        """OmitTypeClass - a model defined in OpenAPI

        Args:
            id (float): Internal unique identifier for the object. You should not have to use this, use code instead.
            policy_code (str): Unique identifier of the policy that this object belongs to.
            account_number (str): Account number.
            policy_number (str): Policy number.
            code (str): Unique identifier for the object.
            type (str): Invoice type.
            invoice_number (str): Invoice number.
            net_amount (float): Net amount is in cents.
            tax_amount (float): Tax amount is in cents.
            credit_amount (float): Credit amount.
            gross_amount (float): Gross amount. This property is sum of taxAmount and netAmount.
            paid_amount (float): Paid amount. This property is amount paid by this invoice. The amount corresponds to the sum (positives and negatives) of all payments relating to that invoice.
            status (str): Invoice status.
            due_date (datetime): Invoice due date.
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Metadata contains extra information that the object would need for specific cases.
            billing_interval_from (datetime): Start date of billing interval.
            billing_interval_to (datetime): End date of billing interval.
            created_at (datetime): Time at which the object was created.
            invoice_items ([InvoiceItemClass]): Invoice items.
            currency (str): Invoice currency. EUR is used by default.
            payments (bool, date, datetime, dict, float, int, list, str, none_type): Invoice payments.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.policy_code = policy_code
        self.account_number = account_number
        self.policy_number = policy_number
        self.code = code
        self.type = type
        self.invoice_number = invoice_number
        self.net_amount = net_amount
        self.tax_amount = tax_amount
        self.credit_amount = credit_amount
        self.gross_amount = gross_amount
        self.paid_amount = paid_amount
        self.status = status
        self.due_date = due_date
        self.metadata = metadata
        self.billing_interval_from = billing_interval_from
        self.billing_interval_to = billing_interval_to
        self.created_at = created_at
        self.invoice_items = invoice_items
        self.currency = currency
        self.payments = payments
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
