"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiCanary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_synthetics_alpha_1 = require("@aws-cdk/aws-synthetics-alpha");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const aws_s3_assets_1 = require("aws-cdk-lib/aws-s3-assets");
const code_bundling_1 = require("./code-bundling");
/**
 * A CloudWatch Synthetic Canary for monitoring APIs.
 */
class ApiCanary extends aws_synthetics_alpha_1.Canary {
    constructor(scope, id, props) {
        const bundler = new code_bundling_1.CanaryCodeBundler(path.join(__dirname, '..', '..', 'canary-src'));
        const canaryAsset = new aws_s3_assets_1.Asset(scope, `${id}ApiCanaryAsset`, {
            path: bundler.codePath,
            bundling: {
                image: aws_cdk_lib_1.DockerImage.fromRegistry('node:14'),
                local: bundler,
            },
        });
        let artifactsBucket = props.artifactsBucketLocation?.bucket;
        if (!artifactsBucket) {
            artifactsBucket = new aws_s3_1.Bucket(scope, `${id}ArtifactsBucket`, {
                encryption: aws_s3_1.BucketEncryption.S3_MANAGED,
                blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
                enforceSSL: true,
            });
        }
        super(scope, id, {
            ...props,
            test: aws_synthetics_alpha_1.Test.custom({
                code: aws_synthetics_alpha_1.Code.fromBucket(canaryAsset.bucket, canaryAsset.s3ObjectKey),
                handler: 'index.handler',
            }),
            runtime: aws_synthetics_alpha_1.Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_8,
            environmentVariables: {
                baseUrl: props.baseUrl,
                threadCount: (props.threadCount ?? 20).toString(),
                testSteps: aws_cdk_lib_1.Lazy.string({ produce: () => JSON.stringify(this._steps) }),
            },
            artifactsBucketLocation: {
                bucket: artifactsBucket,
                prefix: props.artifactsBucketLocation?.prefix,
            },
        });
        this._steps = props.steps ?? [];
        const period = aws_cdk_lib_1.Duration.minutes(5);
        this.successAlarm = new aws_cloudwatch_1.Alarm(this, 'SuccessAlarm', {
            metric: this.metricSuccessPercent({ period }),
            evaluationPeriods: 2,
            threshold: 100,
            comparisonOperator: aws_cloudwatch_1.ComparisonOperator.LESS_THAN_THRESHOLD,
        });
        if (props.durationAlarmThreshold) {
            this.durationAlarm = new aws_cloudwatch_1.Alarm(this, 'DurationAlarm', {
                metric: this.metricDuration({ period }),
                evaluationPeriods: 2,
                threshold: props.durationAlarmThreshold.toMilliseconds(),
                comparisonOperator: aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            });
        }
    }
    /**
     * Add a new test step to this canary.
     *
     * @param step - ApiTestStep to add.
     */
    addTestStep(step) {
        this._steps.push(step);
    }
}
exports.ApiCanary = ApiCanary;
_a = JSII_RTTI_SYMBOL_1;
ApiCanary[_a] = { fqn: "@cdklabs/cdk-ecs-codedeploy.ApiCanary", version: "0.0.89" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvYXBpLWNhbmFyeS9pbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZCQUE2QjtBQUM3Qix3RUFBK0c7QUFDL0csNkNBQTBEO0FBQzFELCtEQUF1RTtBQUd2RSwrQ0FBaUY7QUFDakYsNkRBQWtEO0FBRWxELG1EQUFvRDtBQTZLcEQ7O0dBRUc7QUFDSCxNQUFhLFNBQVUsU0FBUSw2QkFBTTtJQWdCbkMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFxQjtRQUM3RCxNQUFNLE9BQU8sR0FBRyxJQUFJLGlDQUFpQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsWUFBWSxDQUFDLENBQUMsQ0FBQztRQUN0RixNQUFNLFdBQVcsR0FBRyxJQUFJLHFCQUFLLENBQUMsS0FBSyxFQUFFLEdBQUcsRUFBRSxnQkFBZ0IsRUFBRTtZQUMxRCxJQUFJLEVBQUUsT0FBTyxDQUFDLFFBQVE7WUFDdEIsUUFBUSxFQUFFO2dCQUNSLEtBQUssRUFBRSx5QkFBVyxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUM7Z0JBQzFDLEtBQUssRUFBRSxPQUFPO2FBQ2Y7U0FDRixDQUFDLENBQUM7UUFDSCxJQUFJLGVBQWUsR0FBRyxLQUFLLENBQUMsdUJBQXVCLEVBQUUsTUFBTSxDQUFDO1FBQzVELElBQUksQ0FBQyxlQUFlLEVBQUU7WUFDcEIsZUFBZSxHQUFHLElBQUksZUFBTSxDQUFDLEtBQUssRUFBRSxHQUFHLEVBQUUsaUJBQWlCLEVBQUU7Z0JBQzFELFVBQVUsRUFBRSx5QkFBZ0IsQ0FBQyxVQUFVO2dCQUN2QyxpQkFBaUIsRUFBRSwwQkFBaUIsQ0FBQyxTQUFTO2dCQUM5QyxVQUFVLEVBQUUsSUFBSTthQUNqQixDQUFDLENBQUM7U0FDSjtRQUVELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsR0FBRyxLQUFLO1lBQ1IsSUFBSSxFQUFFLDJCQUFJLENBQUMsTUFBTSxDQUFDO2dCQUNoQixJQUFJLEVBQUUsMkJBQUksQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLE1BQU0sRUFBRSxXQUFXLENBQUMsV0FBVyxDQUFDO2dCQUNsRSxPQUFPLEVBQUUsZUFBZTthQUN6QixDQUFDO1lBQ0YsT0FBTyxFQUFFLDhCQUFPLENBQUMsK0JBQStCO1lBQ2hELG9CQUFvQixFQUFFO2dCQUNwQixPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU87Z0JBQ3RCLFdBQVcsRUFBRSxDQUFDLEtBQUssQ0FBQyxXQUFXLElBQUksRUFBRSxDQUFDLENBQUMsUUFBUSxFQUFFO2dCQUNqRCxTQUFTLEVBQUUsa0JBQUksQ0FBQyxNQUFNLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEVBQUUsQ0FBQzthQUN2RTtZQUNELHVCQUF1QixFQUFFO2dCQUN2QixNQUFNLEVBQUUsZUFBZTtnQkFDdkIsTUFBTSxFQUFFLEtBQUssQ0FBQyx1QkFBdUIsRUFBRSxNQUFNO2FBQzlDO1NBQ0YsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUMsS0FBSyxJQUFJLEVBQUUsQ0FBQztRQUVoQyxNQUFNLE1BQU0sR0FBRyxzQkFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUVuQyxJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksc0JBQUssQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFO1lBQ2xELE1BQU0sRUFBRSxJQUFJLENBQUMsb0JBQW9CLENBQUMsRUFBRSxNQUFNLEVBQUUsQ0FBQztZQUM3QyxpQkFBaUIsRUFBRSxDQUFDO1lBQ3BCLFNBQVMsRUFBRSxHQUFHO1lBQ2Qsa0JBQWtCLEVBQUUsbUNBQWtCLENBQUMsbUJBQW1CO1NBQzNELENBQUMsQ0FBQztRQUVILElBQUksS0FBSyxDQUFDLHNCQUFzQixFQUFFO1lBQ2hDLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxzQkFBSyxDQUFDLElBQUksRUFBRSxlQUFlLEVBQUU7Z0JBQ3BELE1BQU0sRUFBRSxJQUFJLENBQUMsY0FBYyxDQUFDLEVBQUUsTUFBTSxFQUFFLENBQUM7Z0JBQ3ZDLGlCQUFpQixFQUFFLENBQUM7Z0JBQ3BCLFNBQVMsRUFBRSxLQUFLLENBQUMsc0JBQXNCLENBQUMsY0FBYyxFQUFFO2dCQUN4RCxrQkFBa0IsRUFBRSxtQ0FBa0IsQ0FBQyxzQkFBc0I7YUFDOUQsQ0FBQyxDQUFDO1NBQ0o7SUFDSCxDQUFDO0lBRUQ7Ozs7T0FJRztJQUNILFdBQVcsQ0FBQyxJQUFpQjtRQUMzQixJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN6QixDQUFDOztBQS9FSCw4QkFnRkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0IHsgQ2FuYXJ5LCBBcnRpZmFjdHNCdWNrZXRMb2NhdGlvbiwgU2NoZWR1bGUsIFRlc3QsIENvZGUsIFJ1bnRpbWUgfSBmcm9tICdAYXdzLWNkay9hd3Mtc3ludGhldGljcy1hbHBoYSc7XG5pbXBvcnQgeyBEdXJhdGlvbiwgRG9ja2VySW1hZ2UsIExhenkgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBBbGFybSwgQ29tcGFyaXNvbk9wZXJhdG9yIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWNsb3Vkd2F0Y2gnO1xuaW1wb3J0IHsgSVZwYywgU3VibmV0U2VsZWN0aW9uLCBJU2VjdXJpdHlHcm91cCB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1lYzInO1xuaW1wb3J0IHsgSVJvbGUgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCB7IEJsb2NrUHVibGljQWNjZXNzLCBCdWNrZXQsIEJ1Y2tldEVuY3J5cHRpb24gfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtczMnO1xuaW1wb3J0IHsgQXNzZXQgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtczMtYXNzZXRzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2FuYXJ5Q29kZUJ1bmRsZXIgfSBmcm9tICcuL2NvZGUtYnVuZGxpbmcnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEFwaVRlc3RTdGVwIHtcbiAgLyoqXG4gICAqIE5hbWUgb2YgdGVzdC5cbiAgICovXG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogUGF0aCBvZiBIVFRQIHJlcXVlc3QsIHJlbGF0aXZlIHRvIGJhc2VVcmwuXG4gICAqL1xuICByZWFkb25seSBwYXRoOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIE9wdGlvbmFsIG1ldGhvZCB0byBmb3IgSFRUUCByZXF1ZXN0LlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIEdFVFxuICAgKi9cbiAgcmVhZG9ubHkgbWV0aG9kPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBPcHRpb25hbCBoZWFkZXJzIHRvIGluY2x1ZGUgaW4gSFRUUCByZXF1ZXN0LlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIGhlYWRlcnMgaW5jbHVkZWQuXG4gICAqL1xuICByZWFkb25seSBoZWFkZXJzPzogeyBbIG5hbWU6IHN0cmluZyBdOiBzdHJpbmcgfTtcblxuICAvKipcbiAgICogT3B0aW9uYWwgYm9keSB0byBpbmNsdWRlIGluIEhUVFAgcmVxdWVzdC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBib2R5IGluY2x1ZGVkLlxuICAgKi9cbiAgcmVhZG9ubHkgYm9keT86IHN0cmluZztcblxuICAvKipcbiAgICogSk1FU1BhdGggdG8gYXBwbHkgYWdhaW5zdCB0aGUgcmVzcG9uc2UgZnJvbSB0aGUgSFRUUCByZXF1ZXN0IGFuZCBjb21wYXJlIGFnYWluc3QgZXhwZWN0ZWQgdmFsdWUuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm8gSk1FU1BhdGggYXNzZXJ0aW9uIHdpbGwgYmUgcGVyZm9ybWVkLlxuICAgKi9cbiAgcmVhZG9ubHkgam1lc1BhdGg/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEV4cGVjdGVkIHZhbHVlIHRvIGNvbXBhcmUgYWdhaW5zdCB0aGUgam1lc1BhdGguXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdW5kZWZpbmVkXG4gICAqL1xuICByZWFkb25seSBleHBlY3RlZFZhbHVlPzogYW55O1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEFwaUNhbmFyeVByb3BzIGV4dGVuZHMgQmFzZUNhbmFyeVByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBiYXNlIFVSTCB0byB1c2UgZm9yIHRlc3RzLlxuICAgKi9cbiAgcmVhZG9ubHkgYmFzZVVybDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgdGhyZXNob2xkIGZvciB0cmlnZ2VyaW5nIGFuIGFsYXJtIG9uIHRoZSB0ZXN0IGR1cmF0aW9uLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIGFsYXJtIGlzIGNyZWF0ZWQgZm9yIGR1cmF0aW9uXG4gICAqL1xuICByZWFkb25seSBkdXJhdGlvbkFsYXJtVGhyZXNob2xkPzogRHVyYXRpb247XG5cbiAgLyoqXG4gICAqIFRoZSBudW1iZXIgb2YgdGhyZWFkcyB0byBydW4gY29uY3VycmVudGx5IGZvciB0aGUgc3ludGhldGljIHRlc3QuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gMjBcbiAgICovXG4gIHJlYWRvbmx5IHRocmVhZENvdW50PzogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBUaGUgc3RlcHMgdG8gcGVyZm9ybSBpbiB0aGUgc3ludGhldGljIHRlc3QuXG4gICAqL1xuICByZWFkb25seSBzdGVwcz86IEFwaVRlc3RTdGVwW107XG59XG5cbmludGVyZmFjZSBCYXNlQ2FuYXJ5UHJvcHMge1xuICAvKipcbiAgICogVGhlIHMzIGxvY2F0aW9uIHRoYXQgc3RvcmVzIHRoZSBkYXRhIG9mIHRoZSBjYW5hcnkgcnVucy5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBBIG5ldyBzMyBidWNrZXQgd2lsbCBiZSBjcmVhdGVkIHdpdGhvdXQgYSBwcmVmaXguXG4gICAqL1xuICByZWFkb25seSBhcnRpZmFjdHNCdWNrZXRMb2NhdGlvbj86IEFydGlmYWN0c0J1Y2tldExvY2F0aW9uO1xuXG4gIC8qKlxuICAgKiBDYW5hcnkgZXhlY3V0aW9uIHJvbGUuXG4gICAqXG4gICAqIFRoaXMgaXMgdGhlIHJvbGUgdGhhdCB3aWxsIGJlIGFzc3VtZWQgYnkgdGhlIGNhbmFyeSB1cG9uIGV4ZWN1dGlvbi5cbiAgICogSXQgY29udHJvbHMgdGhlIHBlcm1pc3Npb25zIHRoYXQgdGhlIGNhbmFyeSB3aWxsIGhhdmUuIFRoZSByb2xlIG11c3RcbiAgICogYmUgYXNzdW1hYmxlIGJ5IHRoZSBBV1MgTGFtYmRhIHNlcnZpY2UgcHJpbmNpcGFsLlxuICAgKlxuICAgKiBJZiBub3Qgc3VwcGxpZWQsIGEgcm9sZSB3aWxsIGJlIGNyZWF0ZWQgd2l0aCBhbGwgdGhlIHJlcXVpcmVkIHBlcm1pc3Npb25zLlxuICAgKiBJZiB5b3UgcHJvdmlkZSBhIFJvbGUsIHlvdSBtdXN0IGFkZCB0aGUgcmVxdWlyZWQgcGVybWlzc2lvbnMuXG4gICAqXG4gICAqIEBzZWUgcmVxdWlyZWQgcGVybWlzc2lvbnM6IGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1zeW50aGV0aWNzLWNhbmFyeS5odG1sI2Nmbi1zeW50aGV0aWNzLWNhbmFyeS1leGVjdXRpb25yb2xlYXJuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gQSB1bmlxdWUgcm9sZSB3aWxsIGJlIGdlbmVyYXRlZCBmb3IgdGhpcyBjYW5hcnkuXG4gICAqIFlvdSBjYW4gYWRkIHBlcm1pc3Npb25zIHRvIHJvbGVzIGJ5IGNhbGxpbmcgJ2FkZFRvUm9sZVBvbGljeScuXG4gICAqL1xuICByZWFkb25seSByb2xlPzogSVJvbGU7XG5cbiAgLyoqXG4gICAqIEhvdyBsb25nIHRoZSBjYW5hcnkgd2lsbCBiZSBpbiBhICdSVU5OSU5HJyBzdGF0ZS4gRm9yIGV4YW1wbGUsIGlmIHlvdSBzZXQgYHRpbWVUb0xpdmVgIHRvIGJlIDEgaG91ciBhbmQgYHNjaGVkdWxlYCB0byBiZSBgcmF0ZSgxMCBtaW51dGVzKWAsXG4gICAqIHlvdXIgY2FuYXJ5IHdpbGwgcnVuIGF0IDEwIG1pbnV0ZSBpbnRlcnZhbHMgZm9yIGFuIGhvdXIsIGZvciBhIHRvdGFsIG9mIDYgdGltZXMuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm8gbGltaXRcbiAgICovXG4gIHJlYWRvbmx5IHRpbWVUb0xpdmU/OiBEdXJhdGlvbjtcblxuICAvKipcbiAgICogU3BlY2lmeSB0aGUgc2NoZWR1bGUgZm9yIGhvdyBvZnRlbiB0aGUgY2FuYXJ5IHJ1bnMuIEZvciBleGFtcGxlLCBpZiB5b3Ugc2V0IGBzY2hlZHVsZWAgdG8gYHJhdGUoMTAgbWludXRlcylgLCB0aGVuIHRoZSBjYW5hcnkgd2lsbCBydW4gZXZlcnkgMTAgbWludXRlcy5cbiAgICogWW91IGNhbiBzZXQgdGhlIHNjaGVkdWxlIHdpdGggYFNjaGVkdWxlLnJhdGUoRHVyYXRpb24pYCAocmVjb21tZW5kZWQpIG9yIHlvdSBjYW4gc3BlY2lmeSBhbiBleHByZXNzaW9uIHVzaW5nIGBTY2hlZHVsZS5leHByZXNzaW9uKClgLlxuICAgKiBAZGVmYXVsdCAncmF0ZSg1IG1pbnV0ZXMpJ1xuICAgKi9cbiAgcmVhZG9ubHkgc2NoZWR1bGU/OiBTY2hlZHVsZTtcblxuICAvKipcbiAgICogV2hldGhlciBvciBub3QgdGhlIGNhbmFyeSBzaG91bGQgc3RhcnQgYWZ0ZXIgY3JlYXRpb24uXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IHN0YXJ0QWZ0ZXJDcmVhdGlvbj86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIEhvdyBtYW55IGRheXMgc2hvdWxkIHN1Y2Nlc3NmdWwgcnVucyBiZSByZXRhaW5lZC5cbiAgICpcbiAgICogQGRlZmF1bHQgRHVyYXRpb24uZGF5cygzMSlcbiAgICovXG4gIHJlYWRvbmx5IHN1Y2Nlc3NSZXRlbnRpb25QZXJpb2Q/OiBEdXJhdGlvbjtcblxuICAvKipcbiAgICogSG93IG1hbnkgZGF5cyBzaG91bGQgZmFpbGVkIHJ1bnMgYmUgcmV0YWluZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IER1cmF0aW9uLmRheXMoMzEpXG4gICAqL1xuICByZWFkb25seSBmYWlsdXJlUmV0ZW50aW9uUGVyaW9kPzogRHVyYXRpb247XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBjYW5hcnkuIEJlIHN1cmUgdG8gZ2l2ZSBpdCBhIGRlc2NyaXB0aXZlIG5hbWUgdGhhdCBkaXN0aW5ndWlzaGVzIGl0IGZyb21cbiAgICogb3RoZXIgY2FuYXJpZXMgaW4geW91ciBhY2NvdW50LlxuICAgKlxuICAgKiBEbyBub3QgaW5jbHVkZSBzZWNyZXRzIG9yIHByb3ByaWV0YXJ5IGluZm9ybWF0aW9uIGluIHlvdXIgY2FuYXJ5IG5hbWUuIFRoZSBjYW5hcnkgbmFtZVxuICAgKiBtYWtlcyB1cCBwYXJ0IG9mIHRoZSBjYW5hcnkgQVJOLCB3aGljaCBpcyBpbmNsdWRlZCBpbiBvdXRib3VuZCBjYWxscyBvdmVyIHRoZSBpbnRlcm5ldC5cbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQW1hem9uQ2xvdWRXYXRjaC9sYXRlc3QvbW9uaXRvcmluZy9zZXJ2aWNlbGVuc19jYW5hcmllc19zZWN1cml0eS5odG1sXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gQSB1bmlxdWUgbmFtZSB3aWxsIGJlIGdlbmVyYXRlZCBmcm9tIHRoZSBjb25zdHJ1Y3QgSURcbiAgICovXG4gIHJlYWRvbmx5IGNhbmFyeU5hbWU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBWUEMgd2hlcmUgdGhpcyBjYW5hcnkgaXMgcnVuLlxuICAgKlxuICAgKiBTcGVjaWZ5IHRoaXMgaWYgdGhlIGNhbmFyeSBuZWVkcyB0byBhY2Nlc3MgcmVzb3VyY2VzIGluIGEgVlBDLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vdCBpbiBWUENcbiAgICovXG4gIHJlYWRvbmx5IHZwYz86IElWcGM7XG5cbiAgLyoqXG4gICAqIFdoZXJlIHRvIHBsYWNlIHRoZSBuZXR3b3JrIGludGVyZmFjZXMgd2l0aGluIHRoZSBWUEMuIFlvdSBtdXN0IHByb3ZpZGUgYHZwY2Agd2hlbiB1c2luZyB0aGlzIHByb3AuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdGhlIFZwYyBkZWZhdWx0IHN0cmF0ZWd5IGlmIG5vdCBzcGVjaWZpZWRcbiAgICovXG4gIHJlYWRvbmx5IHZwY1N1Ym5ldHM/OiBTdWJuZXRTZWxlY3Rpb247XG5cbiAgLyoqXG4gICAqIFRoZSBsaXN0IG9mIHNlY3VyaXR5IGdyb3VwcyB0byBhc3NvY2lhdGUgd2l0aCB0aGUgY2FuYXJ5J3MgbmV0d29yayBpbnRlcmZhY2VzLiBZb3UgbXVzdCBwcm92aWRlIGB2cGNgIHdoZW4gdXNpbmcgdGhpcyBwcm9wLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIElmIHRoZSBjYW5hcnkgaXMgcGxhY2VkIHdpdGhpbiBhIFZQQyBhbmQgYSBzZWN1cml0eSBncm91cCBpc1xuICAgKiBub3Qgc3BlY2lmaWVkIGEgZGVkaWNhdGVkIHNlY3VyaXR5IGdyb3VwIHdpbGwgYmUgY3JlYXRlZCBmb3IgdGhpcyBjYW5hcnkuXG4gICAqL1xuICByZWFkb25seSBzZWN1cml0eUdyb3Vwcz86IElTZWN1cml0eUdyb3VwW107XG59XG5cbi8qKlxuICogQSBDbG91ZFdhdGNoIFN5bnRoZXRpYyBDYW5hcnkgZm9yIG1vbml0b3JpbmcgQVBJcy5cbiAqL1xuZXhwb3J0IGNsYXNzIEFwaUNhbmFyeSBleHRlbmRzIENhbmFyeSB7XG4gIC8qKlxuICAgKiBBIENsb3VkV2F0Y2ggQWxhcm0gdGhhdCB0cmlnZ2VycyB3aGVuIHRoZSBzdWNjZXNzIHJhdGUgZmFsbHMgYmVsb3cgMTAwJSBvdmVyIHRoZSBwYXN0IDIgcGVyaW9kcy5cbiAgICovXG4gIHN1Y2Nlc3NBbGFybTogQWxhcm07XG5cbiAgLyoqXG4gICAqIEEgQ2xvdWRXYXRjaCBBbGFybSB0aGF0IHRyaWdnZXJzIHdoZW4gdGhlIGR1cmF0aW9uIG9mIHRoZSB0ZXN0cyBleGNlZWRzIHRoZSBnaXZlbiB0aHJlc2hvbGQgb3ZlciB0aGUgcGFzdCAyIHBlcmlvZHMuXG4gICAqL1xuICBkdXJhdGlvbkFsYXJtPzogQWxhcm07XG5cbiAgLyoqXG4gICAqIEBpbnRlcm5hbCBmaWVsZCB0byB0cmFjayBzdGVwcyBmb3IgdGhpcyBjYW5hcnkuXG4gICAqL1xuICBfc3RlcHM6IEFwaVRlc3RTdGVwW107XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEFwaUNhbmFyeVByb3BzKSB7XG4gICAgY29uc3QgYnVuZGxlciA9IG5ldyBDYW5hcnlDb2RlQnVuZGxlcihwYXRoLmpvaW4oX19kaXJuYW1lLCAnLi4nLCAnLi4nLCAnY2FuYXJ5LXNyYycpKTtcbiAgICBjb25zdCBjYW5hcnlBc3NldCA9IG5ldyBBc3NldChzY29wZSwgYCR7aWR9QXBpQ2FuYXJ5QXNzZXRgLCB7XG4gICAgICBwYXRoOiBidW5kbGVyLmNvZGVQYXRoLFxuICAgICAgYnVuZGxpbmc6IHtcbiAgICAgICAgaW1hZ2U6IERvY2tlckltYWdlLmZyb21SZWdpc3RyeSgnbm9kZToxNCcpLFxuICAgICAgICBsb2NhbDogYnVuZGxlcixcbiAgICAgIH0sXG4gICAgfSk7XG4gICAgbGV0IGFydGlmYWN0c0J1Y2tldCA9IHByb3BzLmFydGlmYWN0c0J1Y2tldExvY2F0aW9uPy5idWNrZXQ7XG4gICAgaWYgKCFhcnRpZmFjdHNCdWNrZXQpIHtcbiAgICAgIGFydGlmYWN0c0J1Y2tldCA9IG5ldyBCdWNrZXQoc2NvcGUsIGAke2lkfUFydGlmYWN0c0J1Y2tldGAsIHtcbiAgICAgICAgZW5jcnlwdGlvbjogQnVja2V0RW5jcnlwdGlvbi5TM19NQU5BR0VELFxuICAgICAgICBibG9ja1B1YmxpY0FjY2VzczogQmxvY2tQdWJsaWNBY2Nlc3MuQkxPQ0tfQUxMLFxuICAgICAgICBlbmZvcmNlU1NMOiB0cnVlLFxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICAuLi5wcm9wcyxcbiAgICAgIHRlc3Q6IFRlc3QuY3VzdG9tKHtcbiAgICAgICAgY29kZTogQ29kZS5mcm9tQnVja2V0KGNhbmFyeUFzc2V0LmJ1Y2tldCwgY2FuYXJ5QXNzZXQuczNPYmplY3RLZXkpLFxuICAgICAgICBoYW5kbGVyOiAnaW5kZXguaGFuZGxlcicsXG4gICAgICB9KSxcbiAgICAgIHJ1bnRpbWU6IFJ1bnRpbWUuU1lOVEhFVElDU19OT0RFSlNfUFVQUEVURUVSXzNfOCxcbiAgICAgIGVudmlyb25tZW50VmFyaWFibGVzOiB7XG4gICAgICAgIGJhc2VVcmw6IHByb3BzLmJhc2VVcmwsXG4gICAgICAgIHRocmVhZENvdW50OiAocHJvcHMudGhyZWFkQ291bnQgPz8gMjApLnRvU3RyaW5nKCksXG4gICAgICAgIHRlc3RTdGVwczogTGF6eS5zdHJpbmcoeyBwcm9kdWNlOiAoKSA9PiBKU09OLnN0cmluZ2lmeSh0aGlzLl9zdGVwcykgfSksXG4gICAgICB9LFxuICAgICAgYXJ0aWZhY3RzQnVja2V0TG9jYXRpb246IHtcbiAgICAgICAgYnVja2V0OiBhcnRpZmFjdHNCdWNrZXQsXG4gICAgICAgIHByZWZpeDogcHJvcHMuYXJ0aWZhY3RzQnVja2V0TG9jYXRpb24/LnByZWZpeCxcbiAgICAgIH0sXG4gICAgfSk7XG4gICAgdGhpcy5fc3RlcHMgPSBwcm9wcy5zdGVwcyA/PyBbXTtcblxuICAgIGNvbnN0IHBlcmlvZCA9IER1cmF0aW9uLm1pbnV0ZXMoNSk7XG5cbiAgICB0aGlzLnN1Y2Nlc3NBbGFybSA9IG5ldyBBbGFybSh0aGlzLCAnU3VjY2Vzc0FsYXJtJywge1xuICAgICAgbWV0cmljOiB0aGlzLm1ldHJpY1N1Y2Nlc3NQZXJjZW50KHsgcGVyaW9kIH0pLFxuICAgICAgZXZhbHVhdGlvblBlcmlvZHM6IDIsXG4gICAgICB0aHJlc2hvbGQ6IDEwMCxcbiAgICAgIGNvbXBhcmlzb25PcGVyYXRvcjogQ29tcGFyaXNvbk9wZXJhdG9yLkxFU1NfVEhBTl9USFJFU0hPTEQsXG4gICAgfSk7XG5cbiAgICBpZiAocHJvcHMuZHVyYXRpb25BbGFybVRocmVzaG9sZCkge1xuICAgICAgdGhpcy5kdXJhdGlvbkFsYXJtID0gbmV3IEFsYXJtKHRoaXMsICdEdXJhdGlvbkFsYXJtJywge1xuICAgICAgICBtZXRyaWM6IHRoaXMubWV0cmljRHVyYXRpb24oeyBwZXJpb2QgfSksXG4gICAgICAgIGV2YWx1YXRpb25QZXJpb2RzOiAyLFxuICAgICAgICB0aHJlc2hvbGQ6IHByb3BzLmR1cmF0aW9uQWxhcm1UaHJlc2hvbGQudG9NaWxsaXNlY29uZHMoKSxcbiAgICAgICAgY29tcGFyaXNvbk9wZXJhdG9yOiBDb21wYXJpc29uT3BlcmF0b3IuR1JFQVRFUl9USEFOX1RIUkVTSE9MRCxcbiAgICAgIH0pO1xuICAgIH1cbiAgfVxuXG4gIC8qKlxuICAgKiBBZGQgYSBuZXcgdGVzdCBzdGVwIHRvIHRoaXMgY2FuYXJ5LlxuICAgKlxuICAgKiBAcGFyYW0gc3RlcCAtIEFwaVRlc3RTdGVwIHRvIGFkZC5cbiAgICovXG4gIGFkZFRlc3RTdGVwKHN0ZXA6IEFwaVRlc3RTdGVwKSB7XG4gICAgdGhpcy5fc3RlcHMucHVzaChzdGVwKTtcbiAgfVxufSJdfQ==