"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListDeployments = void 0;
const CodeDeployClient_1 = require("../CodeDeployClient");
const ListDeploymentsCommand_1 = require("../commands/ListDeploymentsCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListDeploymentsCommand_1.ListDeploymentsCommand(input), ...args);
};
async function* paginateListDeployments(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.nextToken = token;
        if (config.client instanceof CodeDeployClient_1.CodeDeployClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected CodeDeploy | CodeDeployClient");
        }
        yield page;
        const prevToken = token;
        token = page.nextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListDeployments = paginateListDeployments;
