import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { CodeDeployClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CodeDeployClient";
import { RegisterOnPremisesInstanceInput } from "../models/models_0";
/**
 * The input for {@link RegisterOnPremisesInstanceCommand}.
 */
export interface RegisterOnPremisesInstanceCommandInput extends RegisterOnPremisesInstanceInput {
}
/**
 * The output of {@link RegisterOnPremisesInstanceCommand}.
 */
export interface RegisterOnPremisesInstanceCommandOutput extends __MetadataBearer {
}
/**
 * <p>Registers an on-premises instance.</p>
 *         <note>
 *             <p>Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.</p>
 *         </note>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CodeDeployClient, RegisterOnPremisesInstanceCommand } from "@aws-sdk/client-codedeploy"; // ES Modules import
 * // const { CodeDeployClient, RegisterOnPremisesInstanceCommand } = require("@aws-sdk/client-codedeploy"); // CommonJS import
 * const client = new CodeDeployClient(config);
 * const command = new RegisterOnPremisesInstanceCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link RegisterOnPremisesInstanceCommandInput} for command's `input` shape.
 * @see {@link RegisterOnPremisesInstanceCommandOutput} for command's `response` shape.
 * @see {@link CodeDeployClientResolvedConfig | config} for CodeDeployClient's `config` shape.
 *
 */
export declare class RegisterOnPremisesInstanceCommand extends $Command<RegisterOnPremisesInstanceCommandInput, RegisterOnPremisesInstanceCommandOutput, CodeDeployClientResolvedConfig> {
    readonly input: RegisterOnPremisesInstanceCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: RegisterOnPremisesInstanceCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CodeDeployClientResolvedConfig, options?: __HttpHandlerOptions): Handler<RegisterOnPremisesInstanceCommandInput, RegisterOnPremisesInstanceCommandOutput>;
    private serialize;
    private deserialize;
}
