import jinja2

EXERCISE_TEMPLATE_STR = """\
<div
    data-type="injected-exercise"
    class="{{ data.class }}"
    data-injected-from-nickname="{{ data.nickname }}"
    data-injected-from-version="{{ data.version }}"
    data-injected-from-url="{{ data.url }}"
    data-tags="{{ ' '.join(data.tags) }}"
    data-is-vocab="{{ data.is_vocab | lower }}">
    {% if data.required_context -%}
    <div data-type="exercise-context"
        data-context-module="{{ data.required_context.module }}"
        data-context-feature="{{ data.required_context.feature }}">
        <a class="autogenerated-content"
        href="#{{ data.required_context.ref }}">[link]</a>
    </div>
    {% endif -%}
    {% if data.stimulus_html -%}
    <div data-type="exercise-stimulus">{{ data.stimulus_html }}</div>
    {% endif -%}
    {% for question in data.questions -%}
    <div
        data-type="exercise-question"
        data-is-answer-order-important="{{ question.is_answer_order_important | lower }}"
        data-formats="{{ ' '.join(question.formats) }}"
        {% if question.id %}data-id="{{ question.id }}"{% endif %}
        >
        {% if question.stimulus_html -%}
        <div data-type="question-stimulus">{{ question.stimulus_html }}</div>
        {% endif -%}
        <div data-type="question-stem">{{ question.stem_html }}</div>
        {% if question.answers -%}
        <ol data-type="question-answers" type="a">
            {% for option in question.answers -%}
            <li data-type="question-answer" data-id="{{ option.id }}" data-correctness="{{ option.correctness }}">
                <div data-type="answer-content">{{ option.content_html }}</div>
                {% if option.feedback_html %}<div data-type="answer-feedback">{{ option.feedback_html }}</div>{% endif %}
            </li>
            {% endfor -%}
        </ol>
        {% endif -%}
        {% for solution in question.collaborator_solutions -%}
        <div data-type="question-solution" data-solution-source="collaborator" data-solution-type="{{ solution.solution_type }}">
            {{ solution.content_html }}
        </div>
        {% endfor -%}
        {% for solution in question.community_solutions -%}
        <div data-type="question-solution" data-solution-source="community" data-solution-type="{{ solution.solution_type }}">
            {{ solution.content_html }}
        </div>
        {% endfor -%}
    </div>
    {% endfor -%}
</div>
"""

EXERCISE_TEMPLATE = jinja2.Template(EXERCISE_TEMPLATE_STR)
