def calculate_fill_time_pits(LSLevel, LSHH, SurfaceArea, InflowRate):
    """
    Calculate the time required to fill from LSLevel to LSHH.

    Parameters:
        LSLevel (float): Low-start level (m).
        LSHH (float): High-high level (m).
        SurfaceArea (float): Surface area of tank (m²).
        InflowRate (float): Inflow rate (L/s).

    Returns:
        float: Time to fill (hours).
    """
    # Convert inflow rate from L/s to m³/s
    inflow_m3s = InflowRate / 1000.0  
    
    # Volume between LSLevel and LSHH
    volume_m3 = (LSHH - LSLevel) * SurfaceArea  
    
    # Time in seconds
    time_seconds = volume_m3 / inflow_m3s  
    
    # Convert to hours
    time_hours = time_seconds / 3600.0 

    print(f"Time to fill = {time_to_fill:.2f} hours") 
    
    return time_hours

if __name__ == "__main__":
    time_to_fill = calculate_fill_time_pits(8.45, 9.12, 1270, 15.0)
    print(f"Time to fill = {time_to_fill:.2f} hours")


