/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.combinatorics;

import cc.redberry.combinatorics.CombinatorialIterator;
import cc.redberry.combinatorics.IntCombinations;
import cc.redberry.combinatorics.IntCombinationsWithPermutations;
import cc.redberry.combinatorics.IntCombinatorialPort;
import cc.redberry.combinatorics.IntCompositions;
import cc.redberry.combinatorics.IntDistinctTuples;
import cc.redberry.combinatorics.IntPermutations;
import cc.redberry.combinatorics.IntTuples;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;

public final class Combinatorics {
    static final Comparator<int[]> arrayComparator = (o1, o2) -> {
        int comp = Integer.compare(((int[])o1).length, ((int[])o2).length);
        if (comp != 0) {
            return comp;
        }
        for (int i = 0; i < ((int[])o1).length; ++i) {
            comp = Integer.compare(o1[i], o2[i]);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    };

    private Combinatorics() {
    }

    public static CombinatorialIterator<int[]> combinations(int n, int k) {
        if (n < k) {
            throw new IllegalArgumentException();
        }
        return new IntCombinations(n, k);
    }

    public static CombinatorialIterator<int[]> combinationsWithPermutations(int n, int k) {
        if (n < k) {
            throw new IllegalArgumentException();
        }
        if (n == k) {
            return new IntPermutations(n);
        }
        return new IntCombinationsWithPermutations(n, k);
    }

    public static CombinatorialIterator<int[]> permutations(int n) {
        return new IntPermutations(n);
    }

    public static CombinatorialIterator<int[]> compositions(int integer, int nPartitions) {
        return new IntCombinatorialPort.Iterator(new IntCompositions(integer, nPartitions));
    }

    public static CombinatorialIterator<int[]> distinctTuples(int[] ... sets) {
        return new IntCombinatorialPort.Iterator(new IntDistinctTuples(Combinatorics.deepClone(sets)));
    }

    private static int[][] deepClone(int[][] sets) {
        sets = (int[][])sets.clone();
        for (int i = 0; i < sets.length; ++i) {
            sets[i] = (int[])sets[i].clone();
        }
        return sets;
    }

    public static CombinatorialIterator<int[]> tuples(int ... bounds) {
        return new IntCombinatorialPort.Iterator(new IntTuples(bounds));
    }

    private static <T> T[] map(T[] array, int[] indices, ArrayFactory<T> factory) {
        T[] r = factory.create(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            r[i] = array[indices[i]];
        }
        return r;
    }

    public static <T> CombinatorialIterator<T[]> permutations(T[] input) {
        return new TIterator<T>(input, new GenericFactory<T>(input), Combinatorics.permutations(input.length));
    }

    public static <T> CombinatorialIterator<T[]> combinations(T[] input, int k) {
        return new TIterator<T>(input, new GenericFactory<T>(input), Combinatorics.combinations(input.length, k));
    }

    public static <T> CombinatorialIterator<T[]> combinationsWithPermutations(T[] input, int k) {
        return new TIterator<T>(input, new GenericFactory<T>(input), Combinatorics.combinationsWithPermutations(input.length, k));
    }

    private static <T> T[] map(T[][] arrays, int[] indices, ArrayFactory<T> factory) {
        T[] r = factory.create(arrays.length);
        for (int i = 0; i < arrays.length; ++i) {
            r[i] = arrays[i][indices[i]];
        }
        return r;
    }

    private static int[] indices(int length) {
        int[] r = new int[length];
        for (int i = 0; i < length; ++i) {
            r[i] = i;
        }
        return r;
    }

    public static <T> CombinatorialIterator<T[]> distinctTuples(T[] ... sets) {
        return new TTIterator<T>(sets, new GenericFactory<T>(sets[0]), Combinatorics.distinctTuples((int[][])Arrays.stream(sets).map(t -> Combinatorics.indices(((Object[])t).length)).toArray(x$0 -> new int[x$0][])));
    }

    public static <T> CombinatorialIterator<T[]> tuples(T[] ... sets) {
        return new TTIterator<T>(sets, new GenericFactory<T>(sets[0]), Combinatorics.tuples(Arrays.stream(sets).mapToInt(t -> ((Object[])t).length).toArray()));
    }

    static final class TTIterator<T>
    implements CombinatorialIterator<T[]> {
        final T[][] initialArray;
        final ArrayFactory<T> factory;
        final CombinatorialIterator<int[]> intIterator;

        public TTIterator(T[][] initialArray, ArrayFactory<T> factory, CombinatorialIterator<int[]> intIterator) {
            this.initialArray = initialArray;
            this.factory = factory;
            this.intIterator = intIterator;
        }

        @Override
        public void reset() {
            this.intIterator.reset();
        }

        @Override
        public T[] current() {
            return Combinatorics.map(this.initialArray, this.intIterator.current(), this.factory);
        }

        @Override
        public boolean hasNext() {
            return this.intIterator.hasNext();
        }

        @Override
        public T[] next() {
            return Combinatorics.map(this.initialArray, (int[])this.intIterator.next(), this.factory);
        }
    }

    static final class TIterator<T>
    implements CombinatorialIterator<T[]> {
        final T[] initialArray;
        final ArrayFactory<T> factory;
        final CombinatorialIterator<int[]> intIterator;

        public TIterator(T[] initialArray, ArrayFactory<T> factory, CombinatorialIterator<int[]> intIterator) {
            this.initialArray = initialArray;
            this.factory = factory;
            this.intIterator = intIterator;
        }

        @Override
        public void reset() {
            this.intIterator.reset();
        }

        @Override
        public T[] current() {
            return Combinatorics.map(this.initialArray, this.intIterator.current(), this.factory);
        }

        @Override
        public boolean hasNext() {
            return this.intIterator.hasNext();
        }

        @Override
        public T[] next() {
            return Combinatorics.map(this.initialArray, (int[])this.intIterator.next(), this.factory);
        }
    }

    private static final class GenericFactory<T>
    implements ArrayFactory<T> {
        final Class<T> tClass;

        GenericFactory(Class<T> tClass) {
            this.tClass = tClass;
        }

        GenericFactory(T el) {
            this(el.getClass());
        }

        GenericFactory(T[] el) {
            this(el.getClass().getComponentType());
        }

        @Override
        public T[] create(int len) {
            return (Object[])Array.newInstance(this.tClass, len);
        }
    }

    private static interface ArrayFactory<T> {
        public T[] create(int var1);
    }
}

