/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.combinatorics;

import cc.redberry.combinatorics.IntCombinations;
import cc.redberry.combinatorics.IntCombinatorialIterator;
import cc.redberry.combinatorics.IntPermutations;

public final class IntCombinationsWithPermutations
extends IntCombinatorialIterator {
    private static final long serialVersionUID = 8846104681881108285L;
    private final int[] permutation;
    private final int[] combination;
    private final int[] combinationPermutation;
    private final IntPermutations permutationsGenerator;
    private final IntCombinations combinationsGenerator;
    private final int k;

    public IntCombinationsWithPermutations(int n, int k) {
        this.k = k;
        this.combinationsGenerator = new IntCombinations(n, k);
        this.combination = this.combinationsGenerator.combination;
        this.permutationsGenerator = new IntPermutations(k);
        this.permutation = this.permutationsGenerator.permutation;
        this.combinationPermutation = new int[k];
        this.combinationsGenerator.next();
        System.arraycopy(this.combination, 0, this.combinationPermutation, 0, k);
    }

    @Override
    public boolean hasNext() {
        return this.combinationsGenerator.hasNext() || this.permutationsGenerator.hasNext();
    }

    @Override
    public int[] next() {
        if (!this.permutationsGenerator.hasNext()) {
            this.permutationsGenerator.reset();
            this.combinationsGenerator.next();
        }
        this.permutationsGenerator.next();
        for (int i = 0; i < this.k; ++i) {
            this.combinationPermutation[i] = this.combination[this.permutation[i]];
        }
        return this.combinationPermutation;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void reset() {
        this.permutationsGenerator.reset();
        this.combinationsGenerator.reset();
        this.combinationsGenerator.next();
    }

    @Override
    public int[] current() {
        return this.combinationPermutation;
    }
}

