/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.combinatorics;

import cc.redberry.combinatorics.IntCombinatorialPort;
import java.util.Arrays;
import java.util.BitSet;

public final class IntDistinctTuples
implements IntCombinatorialPort {
    private static final long serialVersionUID = -7599542899697602636L;
    private final BitSet previousMask;
    private final BitSet[] setMasks;
    private final int[] combination;
    private final BitSet temp;
    private byte state = (byte)-1;

    public IntDistinctTuples(int[] ... sets) {
        int maxIndex = 0;
        for (int[] set : sets) {
            if (set.length == 0) continue;
            Arrays.sort(set);
            if (maxIndex >= set[set.length - 1]) continue;
            maxIndex = set[set.length - 1];
        }
        this.previousMask = new BitSet(++maxIndex);
        this.temp = new BitSet(maxIndex);
        this.setMasks = new BitSet[sets.length];
        for (int i = 0; i < sets.length; ++i) {
            this.setMasks[i] = new BitSet(maxIndex);
            for (int j : sets[i]) {
                this.setMasks[i].set(j);
            }
        }
        this.combination = new int[sets.length];
        this.previousMask.set(0, this.previousMask.size());
        this.init();
    }

    private void init() {
        int i = 0;
        while (i < this.setMasks.length) {
            this.temp.clear();
            this.temp.or(this.setMasks[i]);
            this.temp.and(this.previousMask);
            int nextBit = this.temp.nextSetBit(this.combination[i]);
            if (nextBit == -1) {
                if (i == 0) {
                    this.state = 1;
                    return;
                }
                this.combination[i] = 0;
                this.previousMask.set(this.combination[--i]);
                int n = i;
                this.combination[n] = this.combination[n] + 1;
                continue;
            }
            this.combination[i] = nextBit;
            this.previousMask.clear(nextBit);
            ++i;
        }
    }

    @Override
    public int[] take() {
        if (this.state == 1) {
            return null;
        }
        if (this.state == -1) {
            this.state = 0;
            return this.combination;
        }
        int n = this.setMasks.length - 1;
        int n2 = this.combination[n];
        this.combination[n] = n2 + 1;
        this.previousMask.set(n2);
        int i = this.setMasks.length - 1;
        while (i < this.setMasks.length) {
            this.temp.clear();
            this.temp.or(this.setMasks[i]);
            this.temp.and(this.previousMask);
            int nextBit = this.temp.nextSetBit(this.combination[i]);
            if (nextBit == -1) {
                if (i == 0) {
                    this.state = 1;
                    return null;
                }
                this.combination[i] = 0;
                this.previousMask.set(this.combination[--i]);
                int n3 = i;
                this.combination[n3] = this.combination[n3] + 1;
                continue;
            }
            this.combination[i] = nextBit;
            this.previousMask.clear(nextBit);
            ++i;
        }
        return this.combination;
    }

    @Override
    public void reset() {
        this.state = (byte)-1;
        Arrays.fill(this.combination, 0);
        this.previousMask.set(0, this.previousMask.size());
        this.init();
    }

    @Override
    public int[] getReference() {
        return this.combination;
    }
}

