/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings;

import cc.redberry.libdivide4j.FastDivision;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;

public final class ChineseRemainders {
    private ChineseRemainders() {
    }

    public static long ChineseRemainders(long prime1, long prime2, long remainder1, long remainder2) {
        if (prime1 <= 0L || prime2 <= 0L) {
            throw new RuntimeException("Negative CRT input: " + prime1 + " " + prime2);
        }
        long modulus = Math.multiplyExact(prime1, prime2);
        long result = Math.floorMod(Math.multiplyExact(prime2, Math.floorMod(Math.multiplyExact(ChineseRemainders.bezout0(prime2, prime1), remainder1), prime1)), modulus);
        result = Math.floorMod(Math.addExact(result, Math.floorMod(Math.multiplyExact(prime1, Math.floorMod(Math.multiplyExact(ChineseRemainders.bezout0(prime1, prime2), remainder2), prime2)), modulus)), modulus);
        return result;
    }

    public static BigInteger ChineseRemainders(BigInteger prime1, BigInteger prime2, BigInteger remainder1, BigInteger remainder2) {
        if (prime1.signum() <= 0 || prime2.signum() <= 0) {
            throw new RuntimeException("Negative CRT input: " + prime1 + " " + prime2);
        }
        return ChineseRemainders.ChineseRemainders(Rings.Z, prime1, prime2, remainder1, remainder2);
    }

    public static <E> E ChineseRemainders(Ring<E> ring, E prime1, E prime2, E remainder1, E remainder2) {
        E modulus = ring.multiply(prime1, prime2);
        E result = ring.getZero();
        result = ring.remainder(ring.add(result, ring.multiply(prime2, ring.remainder(ring.multiply(ChineseRemainders.bezout0(ring, prime2, prime1), remainder1), prime1))), modulus);
        result = ring.remainder(ring.add(result, ring.multiply(prime1, ring.remainder(ring.multiply(ChineseRemainders.bezout0(ring, prime1, prime2), remainder2), prime2))), modulus);
        return result;
    }

    public static <E> E ChineseRemainders(Ring<E> ring, ChineseRemaindersMagic<E> magic, E remainder1, E remainder2) {
        E result = ring.getZero();
        result = ring.remainder(ring.add(result, ring.multiply(magic.prime2, ring.remainder(ring.multiply(magic.bezout0_prime2_prime1, remainder1), magic.prime1))), magic.mulPrimes);
        result = ring.remainder(ring.add(result, ring.multiply(magic.prime1, ring.remainder(ring.multiply(magic.bezout0_prime1_prime2, remainder2), magic.prime2))), magic.mulPrimes);
        return result;
    }

    public static <E> ChineseRemaindersMagic<E> createMagic(Ring<E> ring, E prime1, E prime2) {
        return new ChineseRemaindersMagic(ring, prime1, prime2);
    }

    public static long ChineseRemainders(ChineseRemaindersMagicZp64 magic, long remainder1, long remainder2) {
        long result = magic.mulModModulus(magic.prime2, magic.mulModPrime1(magic.bezoutPrime2Prime1, remainder1));
        result = magic.addMod(result, magic.mulModModulus(magic.prime1, magic.mulModPrime2(magic.bezoutPrime1Prime2, remainder2)));
        return result;
    }

    public static ChineseRemaindersMagicZp64 createMagic(long prime1, long prime2) {
        long modulus = Math.multiplyExact(prime1, prime2);
        return new ChineseRemaindersMagicZp64(prime1, prime2, modulus, FastDivision.magicUnsigned(prime1), FastDivision.magicUnsigned(prime2), FastDivision.magicUnsigned(modulus), prime1 <= Integer.MAX_VALUE, prime2 <= Integer.MAX_VALUE, modulus <= Integer.MAX_VALUE, ChineseRemainders.bezout0(prime1, prime2), ChineseRemainders.bezout0(prime2, prime1));
    }

    public static long ChineseRemainders(long[] primes, long[] remainders) {
        if (primes.length != remainders.length) {
            throw new IllegalArgumentException();
        }
        long modulus = primes[0];
        for (int i = 1; i < primes.length; ++i) {
            if (primes[i] <= 0L) {
                throw new RuntimeException("Negative CRT input: " + primes[i]);
            }
            modulus = Math.multiplyExact(primes[i], modulus);
        }
        long result = 0L;
        for (int i = 0; i < primes.length; ++i) {
            long iModulus = modulus / primes[i];
            long bezout = ChineseRemainders.bezout0(iModulus, primes[i]);
            result = Math.floorMod(Math.addExact(result, Math.floorMod(Math.multiplyExact(iModulus, Math.floorMod(Math.multiplyExact(bezout, remainders[i]), primes[i])), modulus)), modulus);
        }
        return result;
    }

    public static BigInteger ChineseRemainders(BigInteger[] primes, BigInteger[] remainders) {
        if (primes.length != remainders.length) {
            throw new IllegalArgumentException();
        }
        BigInteger modulus = primes[0];
        for (int i = 1; i < primes.length; ++i) {
            if (primes[i].signum() <= 0) {
                throw new RuntimeException("Negative CRT input: " + primes[i]);
            }
            modulus = primes[i].multiply(modulus);
        }
        BigInteger result = BigInteger.ZERO;
        for (int i = 0; i < primes.length; ++i) {
            BigInteger iModulus = modulus.divide(primes[i]);
            BigInteger bezout = ChineseRemainders.bezout0(Rings.Z, iModulus, primes[i]);
            result = result.add(iModulus.multiply(bezout.multiply(remainders[i]).mod(primes[i]))).mod(modulus);
        }
        return result;
    }

    public static <E> E ChineseRemainders(Ring<E> ring, E[] primes, E[] remainders) {
        if (primes.length != remainders.length) {
            throw new IllegalArgumentException();
        }
        E modulus = primes[0];
        for (int i = 1; i < primes.length; ++i) {
            modulus = ring.multiply(primes[i], modulus);
        }
        E result = ring.getZero();
        for (int i = 0; i < primes.length; ++i) {
            E iModulus = ring.divideExact(modulus, primes[i]);
            E bezout = ChineseRemainders.bezout0(ring, iModulus, primes[i]);
            result = ring.remainder(ring.add(result, ring.remainder(ring.multiply(iModulus, ring.remainder(ring.multiply(bezout, remainders[i]), primes[i])), modulus)), modulus);
        }
        return result;
    }

    private static long bezout0(long a, long b) {
        long s = 0L;
        long old_s = 1L;
        long r = b;
        long old_r = a;
        while (r != 0L) {
            long q = old_r / r;
            long tmp = old_r;
            old_r = r;
            r = Math.subtractExact(tmp, Math.multiplyExact(q, r));
            tmp = old_s;
            old_s = s;
            s = Math.subtractExact(tmp, Math.multiplyExact(q, s));
        }
        assert (old_r == 1L) : "a = " + a + " b = " + b;
        return old_s;
    }

    private static <E> E bezout0(Ring<E> ring, E a, E b) {
        E[] rs = ring.firstBezoutCoefficient(a, b);
        E r = rs[0];
        E s = rs[1];
        assert (ring.isUnit(r)) : r;
        if (!ring.isOne(r)) {
            s = ring.divideExact(s, r);
        }
        return s;
    }

    public static class ChineseRemaindersMagic<E> {
        final E prime1;
        final E prime2;
        final E mulPrimes;
        final E bezout0_prime2_prime1;
        final E bezout0_prime1_prime2;

        private ChineseRemaindersMagic(Ring<E> ring, E prime1, E prime2) {
            this.prime1 = prime1;
            this.prime2 = prime2;
            this.mulPrimes = ring.multiply(prime1, prime2);
            this.bezout0_prime1_prime2 = ChineseRemainders.bezout0(ring, prime1, prime2);
            this.bezout0_prime2_prime1 = ChineseRemainders.bezout0(ring, prime2, prime1);
        }
    }

    public static class ChineseRemaindersMagicZp64 {
        final long prime1;
        final long prime2;
        final long modulus;
        final FastDivision.Magic magic1;
        final FastDivision.Magic magic2;
        final FastDivision.Magic magicModulus;
        final boolean prime1IsInt;
        final boolean prime2IsInt;
        final boolean modulusIsInt;
        final FastDivision.Magic magic32Prime1;
        final FastDivision.Magic magic32Prime2;
        final FastDivision.Magic magic32Modulus;
        final long bezoutPrime1Prime2;
        final long bezoutPrime2Prime1;

        ChineseRemaindersMagicZp64(long prime1, long prime2, long modulus, FastDivision.Magic magic1, FastDivision.Magic magic2, FastDivision.Magic magicModulus, boolean prime1IsInt, boolean prime2IsInt, boolean modulusIsInt, long bezoutPrime1Prime2, long bezoutPrime2Prime1) {
            this.prime1 = prime1;
            this.prime2 = prime2;
            this.modulus = modulus;
            this.magic1 = magic1;
            this.magic2 = magic2;
            this.magicModulus = magicModulus;
            this.prime1IsInt = prime1IsInt;
            this.prime2IsInt = prime2IsInt;
            this.modulusIsInt = modulusIsInt;
            this.magic32Prime1 = prime1IsInt ? null : FastDivision.magic32ForMultiplyMod(prime1);
            this.magic32Prime2 = prime2IsInt ? null : FastDivision.magic32ForMultiplyMod(prime2);
            this.magic32Modulus = modulusIsInt ? null : FastDivision.magic32ForMultiplyMod(modulus);
            this.bezoutPrime1Prime2 = Math.floorMod(bezoutPrime1Prime2, prime2);
            this.bezoutPrime2Prime1 = Math.floorMod(bezoutPrime2Prime1, prime1);
        }

        long mulModPrime1(long a, long b) {
            return this.prime1IsInt ? FastDivision.modUnsignedFast(a * b, this.magic1) : FastDivision.multiplyMod128Unsigned(a, b, this.prime1, this.magic32Prime1);
        }

        long mulModPrime2(long a, long b) {
            return this.prime2IsInt ? FastDivision.modUnsignedFast(a * b, this.magic2) : FastDivision.multiplyMod128Unsigned(a, b, this.prime2, this.magic32Prime2);
        }

        long mulModModulus(long a, long b) {
            return this.modulusIsInt ? FastDivision.modUnsignedFast(a * b, this.magicModulus) : FastDivision.multiplyMod128Unsigned(a, b, this.modulus, this.magic32Modulus);
        }

        long addMod(long a, long b) {
            long r = a + b;
            return r - this.modulus >= 0L ? r - this.modulus : r;
        }
    }
}

