/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings;

import cc.redberry.rings.AIntegers;
import cc.redberry.rings.FactorDecomposition;
import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.util.RandomUtil;
import java.util.Iterator;
import org.apache.commons.math3.random.RandomGenerator;

public final class IntegersZp
extends AIntegers {
    private static final long serialVersionUID = 1L;
    public final BigInteger modulus;
    private IntegersZp ppBaseDomain = null;
    private IntegersZp64 lDomain;

    public IntegersZp(BigInteger modulus) {
        this.modulus = modulus;
    }

    public IntegersZp(long modulus) {
        this(BigInteger.valueOf(modulus));
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public boolean isEuclideanRing() {
        return true;
    }

    @Override
    public BigInteger cardinality() {
        return this.modulus;
    }

    @Override
    public BigInteger characteristic() {
        return this.modulus;
    }

    @Override
    public boolean isUnit(BigInteger element) {
        return !element.isZero() && !this.modulus.divideAndRemainder(element)[1].isZero();
    }

    public BigInteger modulus(BigInteger val) {
        return val.signum() >= 0 && val.compareTo(this.modulus) < 0 ? val : val.mod(this.modulus);
    }

    public BigInteger symmetricForm(BigInteger value) {
        return value.compareTo(this.modulus.shiftRight(1)) <= 0 ? value : value.subtract(this.modulus);
    }

    public IntegersZp64 asMachineRing() {
        return new IntegersZp64(this.modulus.longValueExact());
    }

    @Override
    public BigInteger add(BigInteger a, BigInteger b) {
        BigInteger r = (a = this.valueOf(a)).add(b = this.valueOf(b));
        BigInteger rm = r.subtract(this.modulus);
        return rm.signum() >= 0 ? rm : r;
    }

    @Override
    public BigInteger subtract(BigInteger a, BigInteger b) {
        BigInteger r = (a = this.valueOf(a)).subtract(b = this.valueOf(b));
        return r.signum() < 0 ? r.add(this.modulus) : r;
    }

    @Override
    public BigInteger negate(BigInteger element) {
        return element.isZero() ? element : this.modulus.subtract(this.valueOf(element));
    }

    @Override
    public BigInteger multiply(BigInteger a, BigInteger b) {
        return this.modulus(a.multiply(b));
    }

    public BigInteger[] divideAndRemainder(BigInteger a, BigInteger b) {
        return new BigInteger[]{this.divide(a, b), BigInteger.ZERO};
    }

    public BigInteger divide(BigInteger a, BigInteger b) {
        return this.multiply(a, b.modInverse(this.modulus));
    }

    @Override
    public BigInteger remainder(BigInteger a, BigInteger b) {
        return this.getZero();
    }

    @Override
    public BigInteger reciprocal(BigInteger element) {
        return element.modInverse(this.modulus);
    }

    @Override
    public FactorDecomposition<BigInteger> factorSquareFree(BigInteger element) {
        return this.factor(element);
    }

    @Override
    public FactorDecomposition<BigInteger> factor(BigInteger element) {
        return FactorDecomposition.of(this, element);
    }

    @Override
    public BigInteger valueOf(BigInteger val) {
        return this.modulus(val);
    }

    @Override
    public BigInteger valueOf(long val) {
        return this.valueOf(BigInteger.valueOf(val));
    }

    @Override
    public BigInteger randomElement(RandomGenerator rnd) {
        return RandomUtil.randomInt(this.modulus, rnd);
    }

    @Override
    public Iterator<BigInteger> iterator() {
        return new It();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntegersZp perfectPowerBaseDomain() {
        if (this.ppBaseDomain == null) {
            IntegersZp integersZp = this;
            synchronized (integersZp) {
                if (this.ppBaseDomain == null) {
                    BigInteger base = this.perfectPowerBase();
                    this.ppBaseDomain = base == null ? this : new IntegersZp(base);
                }
            }
        }
        return this.ppBaseDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntegersZp64 asZp64() {
        if (!this.modulus.isLong()) {
            return null;
        }
        if (this.lDomain == null) {
            IntegersZp integersZp = this;
            synchronized (integersZp) {
                if (this.lDomain == null) {
                    this.lDomain = new IntegersZp64(this.modulus.longValueExact());
                }
            }
        }
        return this.lDomain;
    }

    public String toString() {
        return "Z/" + this.modulus;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegersZp that = (IntegersZp)o;
        return this.modulus.equals(that.modulus);
    }

    public int hashCode() {
        return this.modulus.hashCode();
    }

    private final class It
    implements Iterator<BigInteger> {
        private BigInteger val = BigInteger.ZERO;

        private It() {
        }

        @Override
        public boolean hasNext() {
            return this.val.compareTo(IntegersZp.this.modulus) < 0;
        }

        @Override
        public BigInteger next() {
            BigInteger r = this.val;
            this.val = this.val.increment();
            return r;
        }
    }
}

