/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings;

import cc.redberry.rings.Integers;
import cc.redberry.rings.IntegersZp;
import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Rational;
import cc.redberry.rings.Rationals;
import cc.redberry.rings.Ring;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.poly.AlgebraicNumberField;
import cc.redberry.rings.poly.FiniteField;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.IPolynomialRing;
import cc.redberry.rings.poly.MultipleFieldExtension;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.QuotientRing;
import cc.redberry.rings.poly.SimpleFieldExtension;
import cc.redberry.rings.poly.UnivariateRing;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.Ideal;
import cc.redberry.rings.poly.multivar.MonomialOrder;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.IrreduciblePolynomials;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import java.util.Comparator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.random.Well44497b;

public final class Rings {
    static RandomGenerator privateRandom = new Well44497b(System.nanoTime());
    public static final Integers Z = Integers.Integers;
    public static final Rationals<BigInteger> Q = new Rationals<BigInteger>(Z);
    public static AlgebraicNumberField<UnivariatePolynomial<Rational<BigInteger>>> GaussianRationals = Rings.GaussianNumbers(Q);
    public static AlgebraicNumberField<UnivariatePolynomial<BigInteger>> GaussianIntegers = Rings.GaussianNumbers(Z);
    public static final UnivariateRing<UnivariatePolynomial<BigInteger>> UnivariateRingZ = Rings.UnivariateRing(Z);
    public static final UnivariateRing<UnivariatePolynomial<Rational<BigInteger>>> UnivariateRingQ = Rings.UnivariateRing(Q);

    private Rings() {
    }

    public static <E> Rationals<E> Frac(Ring<E> ring) {
        return new Rationals<E>(ring);
    }

    public static IntegersZp64 Zp64(long modulus) {
        return new IntegersZp64(modulus);
    }

    public static IntegersZp Zp(long modulus) {
        return new IntegersZp(modulus);
    }

    public static IntegersZp Zp(BigInteger modulus) {
        return new IntegersZp(modulus);
    }

    public static FiniteField<UnivariatePolynomialZp64> GF(long prime, int exponent) {
        if (exponent <= 0) {
            throw new IllegalArgumentException("Exponent must be positive");
        }
        return new FiniteField<UnivariatePolynomialZp64>(IrreduciblePolynomials.randomIrreduciblePolynomial(prime, exponent, (RandomGenerator)new Well19937c(2012471214)));
    }

    public static FiniteField<UnivariatePolynomial<BigInteger>> GF(BigInteger prime, int exponent) {
        if (exponent <= 0) {
            throw new IllegalArgumentException("Exponent must be positive");
        }
        return new FiniteField<IntegersZp>(IrreduciblePolynomials.randomIrreduciblePolynomial(Rings.Zp(prime), exponent, (RandomGenerator)new Well19937c(2012471214)));
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> FiniteField<Poly> GF(Poly irreducible) {
        return new FiniteField<Poly>(irreducible);
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> AlgebraicNumberField<Poly> AlgebraicNumberField(Poly minimalPoly) {
        return new AlgebraicNumberField<Poly>(minimalPoly);
    }

    public static <E> AlgebraicNumberField<UnivariatePolynomial<E>> GaussianNumbers(Ring<E> ring) {
        return Rings.AlgebraicNumberField(UnivariatePolynomial.create(ring, ring.createArray(ring.getOne(), ring.getZero(), ring.getOne())));
    }

    @Deprecated
    public static <uPoly extends IUnivariatePolynomial<uPoly>> SimpleFieldExtension<uPoly> UnivariateQuotientRing(uPoly modulus) {
        return Rings.SimpleFieldExtension(modulus);
    }

    public static <uPoly extends IUnivariatePolynomial<uPoly>> SimpleFieldExtension<uPoly> SimpleFieldExtension(uPoly minimalPolynomial) {
        return minimalPolynomial.isOverFiniteField() ? Rings.GF(minimalPolynomial) : Rings.AlgebraicNumberField(minimalPolynomial);
    }

    public static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>> MultipleFieldExtension<Term, mPoly, sPoly> MultipleFieldExtension(sPoly ... minimalPolynomials) {
        return MultipleFieldExtension.mkMultipleExtension(minimalPolynomials);
    }

    public static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>> MultipleFieldExtension<Term, mPoly, sPoly> SplittingField(sPoly polynomial) {
        return MultipleFieldExtension.mkSplittingField(polynomial);
    }

    public static <E> UnivariateRing<UnivariatePolynomial<E>> UnivariateRing(Ring<E> coefficientRing) {
        return new UnivariateRing<UnivariatePolynomial<E>>(UnivariatePolynomial.zero(coefficientRing));
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> UnivariateRing<Poly> UnivariateRing(Poly factory) {
        return new UnivariateRing<Poly>(factory);
    }

    public static UnivariateRing<UnivariatePolynomialZp64> UnivariateRingZp64(long modulus) {
        return new UnivariateRing<UnivariatePolynomialZp64>(UnivariatePolynomialZp64.zero(modulus));
    }

    public static UnivariateRing<UnivariatePolynomialZp64> UnivariateRingZp64(IntegersZp64 modulus) {
        return new UnivariateRing<UnivariatePolynomialZp64>(UnivariatePolynomialZp64.zero(modulus));
    }

    public static UnivariateRing<UnivariatePolynomial<BigInteger>> UnivariateRingZp(BigInteger modulus) {
        return Rings.UnivariateRing(Rings.Zp(modulus));
    }

    public static <E> MultivariateRing<MultivariatePolynomial<E>> MultivariateRing(int nVariables, Ring<E> coefficientRing, Comparator<DegreeVector> monomialOrder) {
        return new MultivariateRing<MultivariatePolynomial<E>>(MultivariatePolynomial.zero(nVariables, coefficientRing, monomialOrder));
    }

    public static <E> MultivariateRing<MultivariatePolynomial<E>> MultivariateRing(int nVariables, Ring<E> coefficientRing) {
        return Rings.MultivariateRing(nVariables, coefficientRing, MonomialOrder.DEFAULT);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> MultivariateRing<Poly> MultivariateRing(Poly factory) {
        return new MultivariateRing<Poly>(factory);
    }

    public static MultivariateRing<MultivariatePolynomial<BigInteger>> MultivariateRingZ(int nVariables) {
        return Rings.MultivariateRing(nVariables, Z);
    }

    public static MultivariateRing<MultivariatePolynomial<Rational<BigInteger>>> MultivariateRingQ(int nVariables) {
        return Rings.MultivariateRing(nVariables, Q);
    }

    public static MultivariateRing<MultivariatePolynomialZp64> MultivariateRingZp64(int nVariables, long modulus, Comparator<DegreeVector> monomialOrder) {
        return new MultivariateRing<MultivariatePolynomialZp64>(MultivariatePolynomialZp64.zero(nVariables, Rings.Zp64(modulus), monomialOrder));
    }

    public static MultivariateRing<MultivariatePolynomialZp64> MultivariateRingZp64(int nVariables, long modulus) {
        return Rings.MultivariateRingZp64(nVariables, modulus, MonomialOrder.DEFAULT);
    }

    public static MultivariateRing<MultivariatePolynomialZp64> MultivariateRingZp64(int nVariables, IntegersZp64 modulus, Comparator<DegreeVector> monomialOrder) {
        return new MultivariateRing<MultivariatePolynomialZp64>(MultivariatePolynomialZp64.zero(nVariables, modulus, monomialOrder));
    }

    public static MultivariateRing<MultivariatePolynomialZp64> MultivariateRingZp64(int nVariables, IntegersZp64 modulus) {
        return Rings.MultivariateRingZp64(nVariables, modulus, MonomialOrder.DEFAULT);
    }

    public static MultivariateRing<MultivariatePolynomial<BigInteger>> MultivariateRingZp(int nVariables, BigInteger modulus) {
        return Rings.MultivariateRing(nVariables, Rings.Zp(modulus));
    }

    public static <Poly extends IPolynomial<Poly>> IPolynomialRing<Poly> PolynomialRing(Poly factory) {
        if (factory instanceof IUnivariatePolynomial) {
            return Rings.UnivariateRing((IUnivariatePolynomial)factory);
        }
        return Rings.MultivariateRing((AMultivariatePolynomial)factory);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> QuotientRing<Term, Poly> QuotientRing(MultivariateRing<Poly> baseRing, Ideal<Term, Poly> ideal) {
        return new QuotientRing<Term, Poly>(baseRing, ideal);
    }
}

