/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.bigint;

import cc.redberry.rings.bigint.BigInteger;

public final class BigIntegerUtil {
    private BigIntegerUtil() {
    }

    public static BigInteger max(BigInteger a, BigInteger b) {
        return a.compareTo(b) > 0 ? a : b;
    }

    public static BigInteger abs(BigInteger a) {
        return a.abs();
    }

    public static BigInteger gcd(BigInteger a, BigInteger b) {
        return a.gcd(b);
    }

    public static BigInteger gcd(BigInteger[] integers, int from, int to) {
        if (integers.length < 2) {
            throw new IllegalArgumentException();
        }
        BigInteger gcd = BigIntegerUtil.gcd(integers[from], integers[from + 1]);
        if (gcd.isOne()) {
            return gcd;
        }
        for (int i = from + 2; i < to; ++i) {
            if (!(gcd = BigIntegerUtil.gcd(integers[i], gcd)).isOne()) continue;
            return gcd;
        }
        return gcd;
    }

    public static BigInteger pow(long base, long exponent) {
        return BigIntegerUtil.pow(BigInteger.valueOf(base), exponent);
    }

    public static BigInteger pow(BigInteger base, long exponent) {
        if (exponent < 0L) {
            throw new IllegalArgumentException();
        }
        if (exponent < Integer.MAX_VALUE) {
            return BigIntegerUtil.pow(base, (int)exponent);
        }
        BigInteger result = BigInteger.ONE;
        BigInteger k2p = base;
        while (true) {
            if ((exponent & 1L) != 0L) {
                result = result.multiply(k2p);
            }
            if ((exponent >>= 1) == 0L) {
                return result;
            }
            k2p = k2p.multiply(k2p);
        }
    }

    public static BigInteger pow(BigInteger base, int exponent) {
        return base.pow(exponent);
    }

    public static BigInteger pow(BigInteger base, BigInteger exponent) {
        if (exponent.signum() < 0) {
            throw new IllegalArgumentException();
        }
        BigInteger result = BigInteger.ONE;
        BigInteger k2p = base;
        while (true) {
            if (exponent.testBit(0)) {
                result = result.multiply(k2p);
            }
            if ((exponent = exponent.shiftRight(1)).isZero()) {
                return result;
            }
            k2p = k2p.multiply(k2p);
        }
    }

    public static BigInteger sqrtFloor(BigInteger val) throws IllegalArgumentException {
        if (val.signum() < 0) {
            throw new IllegalArgumentException("Negative argument.");
        }
        if (val.isZero() || val.isOne()) {
            return val;
        }
        BigInteger y = val.shiftRight(1);
        while (y.compareTo(val.divide(y)) > 0) {
            y = val.divide(y).add(y).shiftRight(1);
        }
        return y;
    }

    public static BigInteger sqrtCeil(BigInteger val) throws IllegalArgumentException {
        if (val.signum() < 0) {
            throw new IllegalArgumentException("Negative argument.");
        }
        if (val.isZero() || val.isOne()) {
            return val;
        }
        BigInteger y = val.shiftRight(1);
        while (y.compareTo(val.divide(y)) > 0) {
            y = val.divide(y).add(y).shiftRight(1);
        }
        if (val.compareTo(y.multiply(y)) == 0) {
            return y;
        }
        return y.add(BigInteger.ONE);
    }

    public static BigInteger[] perfectPowerDecomposition(BigInteger n) {
        if (n.signum() < 0) {
            BigInteger[] ipp = BigIntegerUtil.perfectPowerDecomposition(n = n.negate());
            if (ipp == null) {
                return null;
            }
            if (ipp[1].testBit(0)) {
                return null;
            }
            ipp[0] = ipp[0].negate();
            return ipp;
        }
        if (n.bitCount() == 1) {
            return new BigInteger[]{BigInteger.TWO, BigInteger.valueOf(n.bitLength() - 1)};
        }
        int lgn = 1 + n.bitLength();
        for (int b = 2; b < lgn; ++b) {
            BigInteger lowa = BigInteger.ONE;
            BigInteger higha = BigInteger.ONE.shiftLeft(lgn / b + 1);
            while (lowa.compareTo(higha.decrement()) < 0) {
                BigInteger mida = lowa.add(higha).shiftRight(1);
                BigInteger ab = BigIntegerUtil.pow(mida, b);
                if (ab.compareTo(n) > 0) {
                    higha = mida;
                    continue;
                }
                if (ab.compareTo(n) < 0) {
                    lowa = mida;
                    continue;
                }
                BigInteger[] ipp = BigIntegerUtil.perfectPowerDecomposition(mida);
                if (ipp != null) {
                    return new BigInteger[]{ipp[0], ipp[1].multiply(b)};
                }
                return new BigInteger[]{mida, BigInteger.valueOf(b)};
            }
        }
        return null;
    }

    public static BigInteger factorial(int number) {
        BigInteger r = BigInteger.ONE;
        for (int i = 1; i <= number; ++i) {
            r = r.multiply(i);
        }
        return r;
    }

    public static BigInteger binomial(int n, int k) {
        if (k > n - k) {
            k = n - k;
        }
        BigInteger b = BigInteger.ONE;
        int i = 1;
        int m = n;
        while (i <= k) {
            b = b.multiply(m).divideExact(BigInteger.valueOf(i));
            ++i;
            --m;
        }
        return b;
    }
}

