/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly;

import cc.redberry.rings.ARing;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.IPolynomialRing;
import cc.redberry.rings.poly.PolynomialMethods;
import java.util.Iterator;

abstract class APolynomialRing<Poly extends IPolynomial<Poly>>
extends ARing<Poly>
implements IPolynomialRing<Poly> {
    private static final long serialVersionUID = 1L;
    final Poly factory;

    APolynomialRing(Poly factory) {
        this.factory = factory.createZero();
    }

    @Override
    public Poly factory() {
        return this.factory;
    }

    @Override
    public boolean isEuclideanRing() {
        return this.factory.isOverField();
    }

    @Override
    public final boolean isField() {
        return false;
    }

    @Override
    public final BigInteger cardinality() {
        return null;
    }

    @Override
    public final BigInteger characteristic() {
        return this.factory.coefficientRingCharacteristic();
    }

    @Override
    public final Poly add(Poly a, Poly b) {
        return a.clone().add(b);
    }

    @Override
    public final Poly subtract(Poly a, Poly b) {
        return a.clone().subtract(b);
    }

    @Override
    public final Poly multiply(Poly a, Poly b) {
        return a.clone().multiply(b);
    }

    @Override
    public final Poly negate(Poly element) {
        return element.clone().negate();
    }

    @Override
    public Poly pow(Poly base, BigInteger exponent) {
        return PolynomialMethods.polyPow(base, exponent, true);
    }

    @Override
    public Poly addMutable(Poly a, Poly b) {
        return a.add(b);
    }

    @Override
    public Poly subtractMutable(Poly a, Poly b) {
        return a.subtract(b);
    }

    @Override
    public Poly multiplyMutable(Poly a, Poly b) {
        return a.multiply(b);
    }

    @Override
    public Poly negateMutable(Poly element) {
        return element.negate();
    }

    @Override
    public final Poly reciprocal(Poly element) {
        if (element.isConstant()) {
            return (Poly)((IPolynomial)this.divideExact(this.getOne(), element));
        }
        throw new ArithmeticException("not divisible: 1 / " + element);
    }

    @Override
    public final Poly getZero() {
        return this.factory.createZero();
    }

    @Override
    public final Poly getOne() {
        return this.factory.createOne();
    }

    @Override
    public final boolean isZero(Poly element) {
        return element.isZero();
    }

    @Override
    public final boolean isOne(Poly element) {
        return element.isOne();
    }

    @Override
    public boolean isUnit(Poly element) {
        return element.isOverField() ? element.isConstant() : this.isOne(element) || this.isMinusOne(element);
    }

    @Override
    public final Poly valueOf(long val) {
        return this.factory.createOne().multiply(val);
    }

    @Override
    public Poly valueOfBigInteger(BigInteger val) {
        return this.factory.createOne().multiplyByBigInteger(val);
    }

    @Override
    public final Poly valueOf(Poly val) {
        if (this.factory.sameCoefficientRingWith(val)) {
            return val;
        }
        return val.setCoefficientRingFrom(this.factory);
    }

    @Override
    public Poly copy(Poly element) {
        return element.clone();
    }

    @Override
    public final int compare(Poly o1, Poly o2) {
        return o1.compareTo(o2);
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APolynomialRing that = (APolynomialRing)o;
        return that.factory.getClass().equals(this.factory.getClass()) && this.factory.sameCoefficientRingWith(that.factory);
    }

    public final int hashCode() {
        return this.getOne().hashCode();
    }

    @Override
    public Iterator<Poly> iterator() {
        throw new UnsupportedOperationException("Ring of infinite cardinality.");
    }

    @Override
    public Poly parse(String string) {
        return this.factory.parsePoly(string);
    }

    @Override
    public String toString(IStringifier<Poly> stringifier) {
        String cfRing = this.factory.coefficientRingToString(stringifier);
        if (cfRing.length() > 2) {
            cfRing = "(" + cfRing + ")";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(cfRing);
        sb.append("[");
        int nVars = this.nVariables();
        int i = 0;
        while (true) {
            sb.append(stringifier.getBinding(this.variable(i), IStringifier.defaultVar(i, nVars)));
            if (i == nVars - 1) break;
            sb.append(", ");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString(String ... variables) {
        return this.toString(IStringifier.mkPolyStringifier(this.factory, variables));
    }

    public String toString() {
        return this.toString(IStringifier.defaultVars(this.nVariables()));
    }
}

