/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly;

import cc.redberry.rings.Ring;
import cc.redberry.rings.poly.APolynomialRing;
import cc.redberry.rings.poly.PolynomialFactorDecomposition;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.IMonomialAlgebra;
import cc.redberry.rings.poly.multivar.MultivariateDivision;
import cc.redberry.rings.poly.multivar.MultivariateFactorization;
import cc.redberry.rings.poly.multivar.MultivariateGCD;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariateSquareFreeFactorization;
import cc.redberry.rings.poly.multivar.RandomMultivariatePolynomials;
import java.util.Comparator;
import java.util.function.Function;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well44497b;

public final class MultivariateRing<Poly extends AMultivariatePolynomial<?, Poly>>
extends APolynomialRing<Poly> {
    private static final long serialVersionUID = 1L;
    private static final RandomGenerator privateRandom = new Well44497b(System.nanoTime());
    public static final int DEGREE_OF_RANDOM_POLY = 16;
    public static final int SIZE_OF_RANDOM_POLY = 16;

    public MultivariateRing(Poly factory) {
        super(factory);
    }

    public <Term extends AMonomial<Term>> IMonomialAlgebra<Term> monomialAlgebra() {
        IMonomialAlgebra monomialAlgebra = ((AMultivariatePolynomial)this.factory).monomialAlgebra;
        return monomialAlgebra;
    }

    @Override
    public int nVariables() {
        return ((AMultivariatePolynomial)this.factory).nVariables;
    }

    public Comparator<DegreeVector> ordering() {
        return ((AMultivariatePolynomial)this.factory).ordering;
    }

    public MultivariateRing<Poly> dropVariable() {
        return new MultivariateRing(((AMultivariatePolynomial)this.factory).dropVariable(0));
    }

    @Override
    public Poly[] divideAndRemainder(Poly dividend, Poly divider) {
        AMultivariatePolynomial[] arr = (AMultivariatePolynomial[])divider.createArray(1);
        arr[0] = divider;
        return MultivariateDivision.divideAndRemainder(dividend, (AMultivariatePolynomial[])arr);
    }

    @Override
    public Poly gcd(Poly a, Poly b) {
        return MultivariateGCD.PolynomialGCD(a, b);
    }

    @Override
    public Poly gcd(Poly[] elements) {
        return (Poly)MultivariateGCD.PolynomialGCD(elements);
    }

    @Override
    public Poly gcd(Iterable<Poly> elements) {
        return MultivariateGCD.PolynomialGCD(elements);
    }

    @Override
    public PolynomialFactorDecomposition<Poly> factorSquareFree(Poly element) {
        return MultivariateSquareFreeFactorization.SquareFreeFactorization(element);
    }

    @Override
    public PolynomialFactorDecomposition<Poly> factor(Poly element) {
        return MultivariateFactorization.Factor(element);
    }

    @Override
    public Poly variable(int variable) {
        return ((AMultivariatePolynomial)this.factory).createMonomial(variable, 1);
    }

    public Poly create(DegreeVector term) {
        return ((AMultivariatePolynomial)this.factory).create(term);
    }

    public Poly randomElement(int degree, int size, RandomGenerator rnd) {
        return (Poly)RandomMultivariatePolynomials.randomPolynomial((AMultivariatePolynomial)this.factory, degree, size, rnd);
    }

    public Poly randomElementTree(int degree, int size, RandomGenerator rnd) {
        if (this.factory instanceof MultivariatePolynomial) {
            MultivariatePolynomial f = (MultivariatePolynomial)this.factory;
            Ring cfRing = f.ring;
            Function<RandomGenerator, Object> method = cfRing::randomElementTree;
            return (Poly)RandomMultivariatePolynomials.randomPolynomial(this.nVariables(), degree, size, cfRing, ((MultivariatePolynomial)this.factory).ordering, method, rnd);
        }
        return this.randomElement(degree, size, rnd);
    }

    public Poly randomElement(int degree, int size) {
        return this.randomElement(degree, size, privateRandom);
    }

    @Override
    public Poly randomElement(RandomGenerator rnd) {
        return (Poly)((AMultivariatePolynomial)super.randomElement(rnd));
    }

    @Override
    public Poly randomElementTree(RandomGenerator rnd) {
        return this.randomElementTree(16, 16, rnd);
    }
}

