/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly;

import cc.redberry.rings.ARing;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.IPolynomialRing;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.Ideal;
import java.util.Iterator;
import org.apache.commons.math3.random.RandomGenerator;

public class QuotientRing<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>>
extends ARing<Poly>
implements IPolynomialRing<Poly> {
    private static final long serialVersionUID = 1L;
    public final MultivariateRing<Poly> baseRing;
    public final Ideal<Term, Poly> ideal;
    private final Poly factory;

    public QuotientRing(MultivariateRing<Poly> baseRing, Ideal<Term, Poly> ideal) {
        this.baseRing = baseRing;
        this.ideal = ideal;
        this.factory = (AMultivariatePolynomial)ideal.getBasisGenerator(0).createZero();
    }

    @Override
    public int nVariables() {
        return ((AMultivariatePolynomial)this.factory).nVariables;
    }

    @Override
    public Poly factory() {
        return this.factory;
    }

    @Override
    public Poly variable(int variable) {
        return ((AMultivariatePolynomial)this.factory).createMonomial(variable, 1);
    }

    @Override
    public boolean isField() {
        return this.factory.isOverField() && this.ideal.isMaximal();
    }

    @Override
    public boolean isEuclideanRing() {
        throw new UnsupportedOperationException("Algebraic structure of ring is unknown");
    }

    @Override
    public BigInteger cardinality() {
        return this.factory.coefficientRingCardinality().isZero() ? BigInteger.ZERO : (this.ideal.dimension() != 0 ? null : BigInteger.valueOf(this.ideal.degree()).multiply(this.factory.coefficientRingCardinality()));
    }

    @Override
    public BigInteger characteristic() {
        return this.factory.coefficientRingCharacteristic();
    }

    public Poly mod(Poly el) {
        return this.ideal.normalForm(el);
    }

    public Poly normalForm(Poly el) {
        return this.mod(el);
    }

    @Override
    public Poly add(Poly a, Poly b) {
        return (Poly)this.mod((AMultivariatePolynomial)this.baseRing.add(a, b));
    }

    @Override
    public Poly subtract(Poly a, Poly b) {
        return (Poly)this.mod((AMultivariatePolynomial)this.baseRing.subtract(a, b));
    }

    @Override
    public Poly multiply(Poly a, Poly b) {
        return (Poly)this.mod((AMultivariatePolynomial)this.baseRing.multiply(a, b));
    }

    @Override
    public Poly negate(Poly element) {
        return (Poly)this.mod((AMultivariatePolynomial)this.baseRing.negate(element));
    }

    @Override
    public Poly copy(Poly element) {
        return (Poly)((AMultivariatePolynomial)this.baseRing.copy((IPolynomial)element));
    }

    @Override
    public Poly[] divideAndRemainder(Poly dividend, Poly divider) {
        if (this.baseRing.isUnit((IPolynomial)divider)) {
            return (AMultivariatePolynomial[])this.createArray(this.multiply(dividend, (Poly)((AMultivariatePolynomial)this.baseRing.reciprocal(divider))), this.getZero());
        }
        if (this.isField()) {
            return (AMultivariatePolynomial[])this.createArray(this.multiply(dividend, this.reciprocal(divider)), this.getZero());
        }
        throw new UnsupportedOperationException("Algebraic structure of ring is unknown");
    }

    @Override
    public Poly reciprocal(Poly element) {
        if (this.isOne(element)) {
            return element;
        }
        if (this.isMinusOne(element)) {
            return element;
        }
        if (this.baseRing.isUnit((IPolynomial)element)) {
            return (Poly)this.valueOf((Poly)((AMultivariatePolynomial)this.baseRing.reciprocal(element)));
        }
        if (this.isField()) {
            if (!element.isConstant()) {
                element = this.mod(element);
            }
            if (!element.isConstant()) {
                throw new UnsupportedOperationException("Algebraic structure of ring is unknown");
            }
            return (Poly)((AMultivariatePolynomial)((AMultivariatePolynomial)this.baseRing.getOne()).divideByLC(element));
        }
        throw new UnsupportedOperationException("Algebraic structure of ring is unknown");
    }

    @Override
    public Poly getZero() {
        return (Poly)((AMultivariatePolynomial)this.baseRing.getZero());
    }

    @Override
    public Poly getOne() {
        return (Poly)((AMultivariatePolynomial)this.baseRing.getOne());
    }

    @Override
    public boolean isZero(Poly element) {
        return this.baseRing.isZero(element);
    }

    @Override
    public boolean isOne(Poly element) {
        return this.baseRing.isOne(element);
    }

    @Override
    public boolean isUnit(Poly element) {
        return this.baseRing.isUnit((IPolynomial)element);
    }

    @Override
    public Poly valueOf(long val) {
        return (Poly)this.mod((AMultivariatePolynomial)this.baseRing.valueOf(val));
    }

    @Override
    public Poly valueOfBigInteger(BigInteger val) {
        return (Poly)this.mod((AMultivariatePolynomial)this.baseRing.valueOfBigInteger(val));
    }

    @Override
    public Poly valueOf(Poly val) {
        return (Poly)this.mod((AMultivariatePolynomial)this.baseRing.valueOf(val));
    }

    @Override
    public Iterator<Poly> iterator() {
        throw new UnsupportedOperationException("Algebraic structure of ring is unknown");
    }

    @Override
    public int compare(Poly o1, Poly o2) {
        return this.baseRing.compare(o1, o2);
    }

    @Override
    public Poly parse(String string) {
        return (Poly)this.valueOf((Poly)((AMultivariatePolynomial)this.baseRing.parse(string)));
    }

    @Override
    public Poly randomElement(RandomGenerator rnd) {
        return (Poly)this.valueOf((Poly)this.baseRing.randomElement(rnd));
    }

    @Override
    public Poly randomElementTree(RandomGenerator rnd) {
        return (Poly)this.valueOf((Poly)this.baseRing.randomElementTree(rnd));
    }

    @Override
    public String toString(IStringifier<Poly> stringifier) {
        return this.baseRing.toString((IStringifier)stringifier) + "/<" + this.ideal.toString(stringifier) + ">";
    }

    public String toString() {
        return this.toString(IStringifier.dummy());
    }
}

