/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly;

import cc.redberry.rings.ARing;
import cc.redberry.rings.FactorDecomposition;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.bigint.BigIntegerUtil;
import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.poly.IPolynomialRing;
import cc.redberry.rings.poly.MultipleFieldExtension;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MonomialOrder;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64;
import cc.redberry.rings.poly.multivar.MultivariateResultants;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.RandomUnivariatePolynomials;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariateGCD;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialArithmetic;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import cc.redberry.rings.poly.univar.UnivariateResultants;
import cc.redberry.rings.poly.univar.UnivariateSquareFreeFactorization;
import java.lang.reflect.Array;
import java.util.Comparator;
import org.apache.commons.math3.random.RandomGenerator;

public abstract class SimpleFieldExtension<E extends IUnivariatePolynomial<E>>
extends ARing<E>
implements IPolynomialRing<E> {
    private static final long serialVersionUID = 1L;
    final E minimalPoly;
    final E factory;
    final UnivariateDivision.InverseModMonomial<E> inverseMod;
    final BigInteger cardinality;

    protected SimpleFieldExtension(E minimalPoly) {
        minimalPoly = (IUnivariatePolynomial)minimalPoly.monic();
        if (minimalPoly == null) {
            throw new IllegalArgumentException("Minimal polynomial must be monic");
        }
        this.minimalPoly = minimalPoly;
        this.factory = minimalPoly.clone();
        this.inverseMod = UnivariateDivision.fastDivisionPreConditioning(minimalPoly);
        this.cardinality = minimalPoly.coefficientRingCardinality() == null ? null : BigIntegerUtil.pow(minimalPoly.coefficientRingCardinality(), minimalPoly.degree());
    }

    public boolean isInTheBaseField(E element) {
        return element.isConstant();
    }

    public E generator() {
        return (E)this.minimalPoly.createMonomial(1);
    }

    public int degree() {
        return this.minimalPoly.degree();
    }

    public E getMinimalPolynomial() {
        return (E)this.minimalPoly.clone();
    }

    public E getMinimalPolynomialRef() {
        return this.minimalPoly;
    }

    public E norm(E element) {
        return UnivariateResultants.ResultantAsPoly(this.minimalPoly, element);
    }

    public E conjugatesProduct(E element) {
        return (E)((IUnivariatePolynomial)this.divideExact(this.norm(element), element));
    }

    public E trace(E element) {
        E minimalPoly = this.minimalPolynomial(element);
        return (E)this.negate((E)this.divideExact(minimalPoly.getAsPoly(minimalPoly.degree() - 1), (IUnivariatePolynomial)minimalPoly.lcAsPoly()));
    }

    public E normOfPolynomial(UnivariatePolynomial<E> poly) {
        if (!poly.ring.equals(this)) {
            throw new IllegalArgumentException();
        }
        if (this.minimalPoly instanceof UnivariatePolynomial) {
            return (E)SimpleFieldExtension.normOfPolynomialE(this, poly);
        }
        if (this.minimalPoly instanceof UnivariatePolynomialZp64) {
            return (E)SimpleFieldExtension.normOfPolynomialZp64((SimpleFieldExtension<UnivariatePolynomialZp64>)this, poly);
        }
        throw new RuntimeException();
    }

    private static <E> UnivariatePolynomial<E> normOfPolynomialE(SimpleFieldExtension<UnivariatePolynomial<E>> ring, UnivariatePolynomial<UnivariatePolynomial<E>> poly) {
        return MultivariateResultants.Resultant((MultivariatePolynomial)((UnivariatePolynomial)ring.minimalPoly).asMultivariate((Comparator)MonomialOrder.DEFAULT).setNVariables(2), MultivariatePolynomial.asNormalMultivariate(poly.asMultivariate(), 0), 0).asUnivariate();
    }

    private static UnivariatePolynomialZp64 normOfPolynomialZp64(SimpleFieldExtension<UnivariatePolynomialZp64> ring, UnivariatePolynomial<UnivariatePolynomialZp64> poly) {
        return MultivariateResultants.Resultant((MultivariatePolynomialZp64)((UnivariatePolynomialZp64)ring.minimalPoly).asMultivariate((Comparator)MonomialOrder.DEFAULT).setNVariables(2), MultivariatePolynomialZp64.asNormalMultivariate((MultivariatePolynomial<UnivariatePolynomialZp64>)poly.asMultivariate(), 0), 0).asUnivariate();
    }

    public <MPoly extends AMultivariatePolynomial> MPoly normOfPolynomial(MultivariatePolynomial<E> poly) {
        if (!poly.ring.equals(this)) {
            throw new IllegalArgumentException();
        }
        if (this.minimalPoly instanceof UnivariatePolynomial) {
            return (MPoly)SimpleFieldExtension.normOfPolynomialE(this, poly);
        }
        if (this.minimalPoly instanceof UnivariatePolynomialZp64) {
            return (MPoly)SimpleFieldExtension.normOfPolynomialZp64((SimpleFieldExtension<UnivariatePolynomialZp64>)this, poly);
        }
        throw new RuntimeException();
    }

    private static <E> MultivariatePolynomial<E> normOfPolynomialE(SimpleFieldExtension<UnivariatePolynomial<E>> ring, MultivariatePolynomial<UnivariatePolynomial<E>> poly) {
        return (MultivariatePolynomial)MultivariateResultants.Resultant((MultivariatePolynomial)((UnivariatePolynomial)ring.minimalPoly).asMultivariate((Comparator)MonomialOrder.DEFAULT).setNVariables(poly.nVariables + 1), MultivariatePolynomial.asNormalMultivariate(poly, 0), 0).dropVariable(0);
    }

    private static MultivariatePolynomialZp64 normOfPolynomialZp64(SimpleFieldExtension<UnivariatePolynomialZp64> ring, MultivariatePolynomial<UnivariatePolynomialZp64> poly) {
        return (MultivariatePolynomialZp64)MultivariateResultants.Resultant((MultivariatePolynomialZp64)((UnivariatePolynomialZp64)ring.minimalPoly).asMultivariate((Comparator)MonomialOrder.DEFAULT).setNVariables(poly.nVariables + 1), MultivariatePolynomialZp64.asNormalMultivariate(poly, 0), 0).dropVariable(0);
    }

    public E minimalPolynomial(E element) {
        UnivariatePolynomial<IUnivariatePolynomial> es = UnivariatePolynomial.create(this, (IUnivariatePolynomial[])this.createArray(this.negate(element), this.getOne()));
        return (E)UnivariateSquareFreeFactorization.SquareFreePart(this.normOfPolynomial(es));
    }

    public <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>> MultipleFieldExtension<Term, mPoly, E> asMultipleExtension() {
        return MultipleFieldExtension.mkMultipleExtension(this);
    }

    @Override
    public int nVariables() {
        return 1;
    }

    @Override
    public E factory() {
        return this.factory;
    }

    @Override
    public boolean isEuclideanRing() {
        return this.minimalPoly.isOverField();
    }

    @Override
    public BigInteger cardinality() {
        return this.cardinality;
    }

    @Override
    public BigInteger characteristic() {
        return this.minimalPoly.coefficientRingCharacteristic();
    }

    protected boolean shouldReduceFast(int dividendDegree) {
        int mDeg = this.minimalPoly.degree();
        if (dividendDegree < mDeg) {
            return false;
        }
        if (this.isFiniteField()) {
            if (mDeg < 8) {
                return false;
            }
            int defect = dividendDegree / mDeg;
            if (mDeg <= 20) {
                return defect <= 16;
            }
            return defect <= 30;
        }
        return false;
    }

    @Override
    public E add(E a, E b) {
        return this.shouldReduceFast(Math.max(a.degree(), b.degree())) ? UnivariatePolynomialArithmetic.polyAddMod(a, b, this.minimalPoly, this.inverseMod, true) : UnivariatePolynomialArithmetic.polyAddMod(a, b, this.minimalPoly, true);
    }

    @Override
    public E subtract(E a, E b) {
        return this.shouldReduceFast(Math.max(a.degree(), b.degree())) ? UnivariatePolynomialArithmetic.polySubtractMod(a, b, this.minimalPoly, this.inverseMod, true) : UnivariatePolynomialArithmetic.polySubtractMod(a, b, this.minimalPoly, true);
    }

    @Override
    public E multiply(E a, E b) {
        return this.shouldReduceFast(a.degree() + b.degree()) ? UnivariatePolynomialArithmetic.polyMultiplyMod(a, b, this.minimalPoly, this.inverseMod, true) : UnivariatePolynomialArithmetic.polyMultiplyMod(a, b, this.minimalPoly, true);
    }

    @Override
    public E negate(E element) {
        return this.shouldReduceFast(element.degree()) ? UnivariatePolynomialArithmetic.polyNegateMod(element, this.minimalPoly, this.inverseMod, true) : UnivariatePolynomialArithmetic.polyNegateMod(element, this.minimalPoly, true);
    }

    @Override
    public E addMutable(E a, E b) {
        return this.shouldReduceFast(Math.max(a.degree(), b.degree())) ? UnivariatePolynomialArithmetic.polyAddMod(a, b, this.minimalPoly, this.inverseMod, false) : UnivariatePolynomialArithmetic.polyAddMod(a, b, this.minimalPoly, false);
    }

    @Override
    public E subtractMutable(E a, E b) {
        return this.shouldReduceFast(Math.max(a.degree(), b.degree())) ? UnivariatePolynomialArithmetic.polySubtractMod(a, b, this.minimalPoly, this.inverseMod, false) : UnivariatePolynomialArithmetic.polySubtractMod(a, b, this.minimalPoly, false);
    }

    @Override
    public E multiplyMutable(E a, E b) {
        return this.shouldReduceFast(a.degree() + b.degree()) ? UnivariatePolynomialArithmetic.polyMultiplyMod(a, b, this.minimalPoly, this.inverseMod, false) : UnivariatePolynomialArithmetic.polyMultiplyMod(a, b, this.minimalPoly, false);
    }

    @Override
    public E negateMutable(E element) {
        return this.shouldReduceFast(element.degree()) ? UnivariatePolynomialArithmetic.polyNegateMod(element, this.minimalPoly, this.inverseMod, false) : UnivariatePolynomialArithmetic.polyNegateMod(element, this.minimalPoly, false);
    }

    @Override
    public E reciprocal(E element) {
        if (element.isZero()) {
            throw new ArithmeticException("divide by zero");
        }
        if (this.isOne(element)) {
            return element;
        }
        if (this.isMinusOne(element)) {
            return element;
        }
        IUnivariatePolynomial[] xgcd = UnivariateGCD.PolynomialFirstBezoutCoefficient(element, this.minimalPoly);
        assert (xgcd[0].isConstant());
        return (E)xgcd[1].divideByLC(xgcd[0]);
    }

    @Override
    public FactorDecomposition<E> factor(E element) {
        return FactorDecomposition.unit(this, element);
    }

    @Override
    public E getZero() {
        return (E)((IUnivariatePolynomial)this.minimalPoly.createZero());
    }

    @Override
    public E getOne() {
        return (E)((IUnivariatePolynomial)this.minimalPoly.createOne());
    }

    @Override
    public boolean isZero(E element) {
        return element.isZero();
    }

    @Override
    public boolean isOne(E element) {
        return element.isOne();
    }

    @Override
    public E valueOf(long val) {
        return (E)((IUnivariatePolynomial)this.getOne().multiply(val));
    }

    @Override
    public E valueOfBigInteger(BigInteger val) {
        return (E)((IUnivariatePolynomial)this.getOne().multiplyByBigInteger(val));
    }

    @Override
    public E valueOf(E val) {
        return (E)(this.shouldReduceFast(val.degree()) ? UnivariatePolynomialArithmetic.polyMod((IUnivariatePolynomial)val.setCoefficientRingFrom(this.factory), this.minimalPoly, this.inverseMod, false) : UnivariatePolynomialArithmetic.polyMod((IUnivariatePolynomial)val.setCoefficientRingFrom(this.factory), this.minimalPoly, false));
    }

    @Override
    public E copy(E element) {
        return (E)element.clone();
    }

    @Override
    public E[] createArray(int length) {
        return (IUnivariatePolynomial[])this.minimalPoly.createArray(length);
    }

    @Override
    public E[][] createArray2d(int length) {
        IUnivariatePolynomial[] array = this.createArray(0);
        return (IUnivariatePolynomial[][])Array.newInstance(array.getClass(), length);
    }

    @Override
    public E[][] createArray2d(int m, int n) {
        IUnivariatePolynomial[][] arr = this.createArray2d(m);
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.createArray(n);
        }
        return arr;
    }

    @Override
    public int compare(E o1, E o2) {
        return o1.compareTo(o2);
    }

    @Override
    public E randomElement(RandomGenerator rnd) {
        E r = RandomUnivariatePolynomials.randomPoly(this.minimalPoly, rnd.nextInt(this.minimalPoly.degree()), rnd);
        if (r.isOverFiniteField()) {
            if (r instanceof UnivariatePolynomial) {
                ((UnivariatePolynomial)r).multiply(((UnivariatePolynomial)r).ring.randomElement(rnd));
            } else {
                r.multiply(rnd.nextLong());
            }
        }
        return r;
    }

    @Override
    public E variable(int variable) {
        if (variable != 0) {
            throw new IllegalArgumentException();
        }
        return (E)this.valueOf((E)this.minimalPoly.createMonomial(1));
    }

    @Override
    public E parse(String string) {
        return (E)this.valueOf((E)((IUnivariatePolynomial)this.factory.parsePoly(string)));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleFieldExtension that = (SimpleFieldExtension)o;
        return this.minimalPoly.equals(that.minimalPoly);
    }

    public int hashCode() {
        return this.minimalPoly.hashCode();
    }

    @Override
    public String toString(IStringifier<E> stringifier) {
        String cfrStr = this.factory.coefficientRingToString(stringifier);
        String varStr = stringifier.getBinding(this.factory.createMonomial(1), IStringifier.defaultVar());
        String irrStr = this.minimalPoly.toString(stringifier);
        return "(" + cfrStr + ")[" + varStr + "]/<" + irrStr + ">";
    }

    public String toString(String ... variables) {
        return this.toString(IStringifier.mkPolyStringifier(this.factory, variables));
    }

    public String toString() {
        return this.toString(IStringifier.defaultVars(1));
    }
}

