/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly;

import cc.redberry.rings.Ring;
import cc.redberry.rings.poly.APolynomialRing;
import cc.redberry.rings.poly.PolynomialFactorDecomposition;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.RandomUnivariatePolynomials;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariateFactorization;
import cc.redberry.rings.poly.univar.UnivariateGCD;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariateSquareFreeFactorization;
import java.util.function.Function;
import org.apache.commons.math3.random.RandomGenerator;

public final class UnivariateRing<Poly extends IUnivariatePolynomial<Poly>>
extends APolynomialRing<Poly> {
    private static final long serialVersionUID = 1L;
    public static final int MIN_DEGREE_OF_RANDOM_POLY = 0;
    public static final int MAX_DEGREE_OF_RANDOM_POLY = 32;

    public UnivariateRing(Poly factory) {
        super(factory);
    }

    @Override
    public int nVariables() {
        return 1;
    }

    @Override
    public Poly remainder(Poly a, Poly b) {
        return UnivariateDivision.remainder(a, b, true);
    }

    @Override
    public Poly[] divideAndRemainder(Poly a, Poly b) {
        return UnivariateDivision.divideAndRemainder(a, b, (boolean)true);
    }

    @Override
    public Poly gcd(Poly a, Poly b) {
        return UnivariateGCD.PolynomialGCD(a, b);
    }

    @Override
    public Poly[] extendedGCD(Poly a, Poly b) {
        return UnivariateGCD.PolynomialExtendedGCD(a, b);
    }

    @Override
    public Poly[] firstBezoutCoefficient(Poly a, Poly b) {
        return UnivariateGCD.PolynomialFirstBezoutCoefficient(a, b);
    }

    @Override
    public PolynomialFactorDecomposition<Poly> factorSquareFree(Poly element) {
        return UnivariateSquareFreeFactorization.SquareFreeFactorization(element);
    }

    @Override
    public PolynomialFactorDecomposition<Poly> factor(Poly element) {
        return UnivariateFactorization.Factor(element);
    }

    @Override
    public Poly variable(int variable) {
        if (variable != 0) {
            throw new IllegalArgumentException();
        }
        return ((IUnivariatePolynomial)this.factory).createMonomial(1);
    }

    public Poly randomElement(int minDegree, int maxDegree, RandomGenerator rnd) {
        return (Poly)RandomUnivariatePolynomials.randomPoly((IUnivariatePolynomial)this.factory, minDegree + (minDegree == maxDegree ? 0 : rnd.nextInt(maxDegree - minDegree)), rnd);
    }

    public Poly randomElement(int degree, RandomGenerator rnd) {
        return this.randomElement(degree, degree, rnd);
    }

    @Override
    public Poly randomElement(RandomGenerator rnd) {
        return this.randomElement(0, 32, rnd);
    }

    public Poly randomElementTree(int minDegree, int maxDegree, RandomGenerator rnd) {
        if (this.factory instanceof UnivariatePolynomial) {
            UnivariatePolynomial f = (UnivariatePolynomial)this.factory;
            Ring cfRing = f.ring;
            Function<RandomGenerator, Object> method = cfRing::randomElementTree;
            return (Poly)RandomUnivariatePolynomials.randomPoly(minDegree + (minDegree == maxDegree ? 0 : rnd.nextInt(maxDegree - minDegree)), cfRing, method, rnd);
        }
        return this.randomElement(minDegree, maxDegree, rnd);
    }

    @Override
    public Poly randomElementTree(RandomGenerator rnd) {
        return this.randomElementTree(0, 32, rnd);
    }
}

